/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.DipoleMagnet;
import lach_01298.qmd.accelerator.QuadrupoleMagnet;
import lach_01298.qmd.accelerator.RFCavity;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorYoke;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.CuboidalOrToroidalMultiblock;
import lach_01298.qmd.multiblock.IMultiBlockTank;
import lach_01298.qmd.multiblock.IQMDPacketMultiblock;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.RecipeInfo;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Accelerator
extends CuboidalOrToroidalMultiblock<Accelerator, IAcceleratorPart>
implements ILogicMultiblock<Accelerator, AcceleratorLogic, IAcceleratorPart>,
IQMDPacketMultiblock<Accelerator, IAcceleratorPart, AcceleratorUpdatePacket>,
IMultiBlockTank {
    public static final ObjectSet<Class<? extends IAcceleratorPart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends AcceleratorLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    @Nonnull
    protected AcceleratorLogic logic = new AcceleratorLogic(this);
    protected final Multiblock.PartSuperMap<Accelerator, IAcceleratorPart> partSuperMap = new Multiblock.PartSuperMap();
    protected final Long2ObjectMap<TileAcceleratorBeam> beamMap = new Long2ObjectOpenHashMap();
    protected final Long2ObjectMap<RFCavity> rfCavityMap = new Long2ObjectOpenHashMap();
    protected final Long2ObjectMap<QuadrupoleMagnet> quadrupoleMap = new Long2ObjectOpenHashMap();
    protected final Long2ObjectMap<DipoleMagnet> dipoleMap = new Long2ObjectOpenHashMap();
    protected final ObjectSet<TileAcceleratorBeamPort> beamPorts = new ObjectOpenHashSet();
    public IAcceleratorController controller;
    public TileAcceleratorBeamPort input;
    public TileAcceleratorBeamPort output;
    public final HeatBuffer heatBuffer = new HeatBuffer((long)QMDConfig.accelerator_base_heat_capacity);
    public final EnergyStorage energyStorage = new EnergyStorage((long)QMDConfig.accelerator_base_energy_capacity);
    public List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(QMDConfig.accelerator_base_input_tank_capacity, QMDRecipes.accelerator_cooling_valid_fluids.get(0)), new Tank(QMDConfig.accelerator_base_output_tank_capacity, null), new Tank(1, null), new Tank(1, null), new Tank(1, null), new Tank(1, null), new Tank(1, null)});
    public final List<ParticleStorageAccelerator> beams = Lists.newArrayList((Object[])new ParticleStorageAccelerator[]{new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator()});
    public boolean isControllorOn = false;
    public boolean isNew = true;
    public static final int MAX_TEMP = 400;
    public int ambientTemp = 290;
    public int maxOperatingTemp = 0;
    public long cooling = 0L;
    public long rawHeating = 0L;
    public long currentHeating = 0L;
    public int maxCoolantIn = 0;
    public int maxCoolantOut = 0;
    public double efficiency = 0.0;
    public int requiredEnergy = 0;
    public int acceleratingVoltage = 0;
    public int RFCavityNumber = 0;
    public int quadrupoleNumber = 0;
    public int dipoleNumber = 0;
    public double quadrupoleStrength = 0.0;
    public double dipoleStrength = 0.0;
    public int energyPercentage = 0;
    public boolean computerControlled = false;
    public int errorCode = 0;
    public static final int errorCode_Nothing = 0;
    public static final int errorCode_ToHot = 1;
    public static final int errorCode_OutOfPower = 2;
    public static final int errorCode_NotEnoughQuadrupoles = 3;
    public static final int errorCode_InputParticleEnergyToLow = 4;
    public static final int errorCode_InputParticleEnergyToHigh = 5;
    public static final int thickness = 5;
    public RecipeInfo<BasicRecipe> coolingRecipeInfo;
    protected final Set<EntityPlayer> updatePacketListeners;

    public Accelerator(World world) {
        super(world, Accelerator.class, IAcceleratorPart.class, 5);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
        this.updatePacketListeners = new ObjectOpenHashSet();
    }

    @Nonnull
    public AcceleratorLogic getLogic() {
        return this.logic;
    }

    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (AcceleratorLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
        this.SetToriodThickness(this.logic.getThickness());
    }

    public Multiblock.PartSuperMap<Accelerator, IAcceleratorPart> getPartSuperMap() {
        return this.partSuperMap;
    }

    public Long2ObjectMap<TileAcceleratorBeam> getBeamMap() {
        return this.beamMap;
    }

    public Long2ObjectMap<RFCavity> getRFCavityMap() {
        return this.rfCavityMap;
    }

    public Long2ObjectMap<QuadrupoleMagnet> getQuadrupoleMap() {
        return this.quadrupoleMap;
    }

    public Long2ObjectMap<DipoleMagnet> getDipoleMap() {
        return this.dipoleMap;
    }

    public ObjectSet<TileAcceleratorBeamPort> getValidBeamPorts() {
        return this.beamPorts;
    }

    public boolean isValidRFCavity(BlockPos center, EnumFacing.Axis axis) {
        if (!(this.WORLD.func_175625_s(center.func_177984_a()) instanceof TileAcceleratorRFCavity)) {
            return false;
        }
        Class<?> cavityType = this.WORLD.func_175625_s(center.func_177984_a()).getClass();
        if (!cavityType.isInstance(this.WORLD.func_175625_s(center.func_177977_b()))) {
            return false;
        }
        if (axis == EnumFacing.Axis.X) {
            if (this.WORLD.func_175625_s(center.func_177984_a().func_177974_f()) instanceof TileAcceleratorRFCavity || this.WORLD.func_175625_s(center.func_177984_a().func_177976_e()) instanceof TileAcceleratorRFCavity) {
                return false;
            }
            if (cavityType.isInstance(this.WORLD.func_175625_s(center.func_177978_c())) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177968_d())) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(0, 1, 1))) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(0, 1, -1))) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(0, -1, 1))) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(0, -1, -1)))) {
                return true;
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            if (this.WORLD.func_175625_s(center.func_177984_a().func_177978_c()) instanceof TileAcceleratorRFCavity || this.WORLD.func_175625_s(center.func_177984_a().func_177968_d()) instanceof TileAcceleratorRFCavity) {
                return false;
            }
            if (cavityType.isInstance(this.WORLD.func_175625_s(center.func_177974_f())) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177976_e())) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(1, 1, 0))) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(-1, 1, 0))) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(1, -1, 0))) && cavityType.isInstance(this.WORLD.func_175625_s(center.func_177982_a(-1, -1, 0)))) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidQuadrupole(BlockPos center, EnumFacing.Axis axis) {
        if (!(this.WORLD.func_175625_s(center.func_177984_a()) instanceof TileAcceleratorMagnet)) {
            return false;
        }
        Class<?> magnetType = this.WORLD.func_175625_s(center.func_177984_a()).getClass();
        if (!magnetType.isInstance(this.WORLD.func_175625_s(center.func_177977_b()))) {
            return false;
        }
        if (axis == EnumFacing.Axis.X && magnetType.isInstance(this.WORLD.func_175625_s(center.func_177978_c())) && magnetType.isInstance(this.WORLD.func_175625_s(center.func_177968_d()))) {
            return true;
        }
        return axis == EnumFacing.Axis.Z && magnetType.isInstance(this.WORLD.func_175625_s(center.func_177974_f())) && magnetType.isInstance(this.WORLD.func_175625_s(center.func_177976_e()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidDipole(BlockPos center, boolean vertical) {
        if (vertical) {
            if (this.WORLD.func_175625_s(center.func_177978_c()) instanceof TileAcceleratorMagnet) {
                Class<?> magnetType = this.WORLD.func_175625_s(center.func_177978_c()).getClass();
                if (!magnetType.isInstance(this.WORLD.func_175625_s(center.func_177968_d()))) {
                    return false;
                }
                if (!(this.WORLD.func_175625_s(center.func_177978_c().func_177984_a()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177977_b()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177984_a().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177984_a().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177977_b().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177977_b().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177984_a()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177977_b()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177984_a().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177984_a().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177977_b().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177977_b().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177976_e()) instanceof TileAcceleratorYoke)) {
                    return false;
                }
                ArrayList<BlockPos> faces = new ArrayList<BlockPos>();
                faces.add(center.func_177984_a());
                faces.add(center.func_177977_b());
                faces.add(center.func_177974_f());
                faces.add(center.func_177976_e());
                for (BlockPos pos : faces) {
                    if (this.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam || this.WORLD.func_175625_s(pos) instanceof TileAcceleratorYoke) continue;
                    return false;
                }
                return true;
            } else {
                if (!(this.WORLD.func_175625_s(center.func_177974_f()) instanceof TileAcceleratorMagnet)) return false;
                Class<?> magnetType = this.WORLD.func_175625_s(center.func_177974_f()).getClass();
                if (!magnetType.isInstance(this.WORLD.func_175625_s(center.func_177976_e()))) {
                    return false;
                }
                if (!(this.WORLD.func_175625_s(center.func_177974_f().func_177984_a()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177977_b()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177984_a().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177984_a().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177977_b().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177974_f().func_177977_b().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177984_a()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177977_b()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177984_a().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177984_a().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177977_b().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177976_e().func_177977_b().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177968_d()) instanceof TileAcceleratorYoke)) {
                    return false;
                }
                ArrayList<BlockPos> faces = new ArrayList<BlockPos>();
                faces.add(center.func_177984_a());
                faces.add(center.func_177977_b());
                faces.add(center.func_177978_c());
                faces.add(center.func_177968_d());
                for (BlockPos pos : faces) {
                    if (this.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam || this.WORLD.func_175625_s(pos) instanceof TileAcceleratorYoke) continue;
                    return false;
                }
            }
            return true;
        } else {
            if (!(this.WORLD.func_175625_s(center.func_177984_a()) instanceof TileAcceleratorMagnet)) {
                return false;
            }
            Class<?> magnetType = this.WORLD.func_175625_s(center.func_177984_a()).getClass();
            if (!magnetType.isInstance(this.WORLD.func_175625_s(center.func_177977_b()))) {
                return false;
            }
            if (!(this.WORLD.func_175625_s(center.func_177984_a().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177978_c().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177978_c().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177968_d().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177984_a().func_177968_d().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177978_c()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177968_d()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177978_c().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177978_c().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177968_d().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177977_b().func_177968_d().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177978_c().func_177976_e()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177974_f()) instanceof TileAcceleratorYoke && this.WORLD.func_175625_s(center.func_177968_d().func_177976_e()) instanceof TileAcceleratorYoke)) {
                return false;
            }
            ArrayList<BlockPos> faces = new ArrayList<BlockPos>();
            faces.add(center.func_177978_c());
            faces.add(center.func_177968_d());
            faces.add(center.func_177974_f());
            faces.add(center.func_177976_e());
            for (BlockPos pos : faces) {
                if (this.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam || this.WORLD.func_175625_s(pos) instanceof TileAcceleratorYoke) continue;
                return false;
            }
        }
        return true;
    }

    public void onAttachedPartWithMultiblockData(IAcceleratorPart part, NBTTagCompound data) {
        this.logic.onAttachedPartWithMultiblockData(part, data);
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    protected void onBlockAdded(IAcceleratorPart newPart) {
        this.onPartAdded((ITileMultiblockPart)newPart);
        this.logic.onBlockAdded(newPart);
    }

    protected void onBlockRemoved(IAcceleratorPart oldPart) {
        this.onPartRemoved((ITileMultiblockPart)oldPart);
        this.logic.onBlockRemoved(oldPart);
    }

    protected void onMachineAssembled() {
        this.logic.onMachineAssembled();
    }

    protected void onMachineRestored() {
        this.logic.onMachineRestored();
    }

    protected void onMachinePaused() {
        this.logic.onMachinePaused();
    }

    protected void onMachineDisassembled() {
        this.logic.onMachineDisassembled();
    }

    @Override
    protected boolean isMachineWhole() {
        return this.setLogic(this) && super.isMachineWhole() && this.logic.isMachineWhole();
    }

    public boolean setLogic(Multiblock multiblock) {
        if (this.getPartMap(IAcceleratorController.class).isEmpty()) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(IAcceleratorController.class).size() > 1) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        ObjectIterator objectIterator = this.getPartMap(IAcceleratorController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IAcceleratorController contr;
            this.controller = contr = (IAcceleratorController)objectIterator.next();
        }
        this.setLogic(this.controller.getLogicID());
        return true;
    }

    protected void onAssimilate(Accelerator assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    protected void onAssimilated(Accelerator assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    protected boolean updateServer() {
        boolean flag = false;
        this.updateActivity();
        if (this.logic.onUpdateServer()) {
            flag = true;
        }
        return flag;
    }

    public void updateActivity() {
        boolean wasControllerOn = this.isControllorOn;
        boolean bl = this.isControllorOn = this.isAssembled() && this.logic.isAcceleratorOn();
        if (this.isControllorOn != wasControllerOn && this.controller != null) {
            this.controller.setActivity(this.isControllorOn);
            this.sendMultiblockUpdatePacketToAll();
        }
    }

    public int getTemperature() {
        return Math.round(400.0f * (float)this.heatBuffer.getHeatStored() / (float)this.heatBuffer.getHeatCapacity());
    }

    public long getExternalHeating() {
        return (long)((double)(this.ambientTemp - this.getTemperature()) * QMDConfig.accelerator_thermal_conductivity * (double)this.getExteriorSurfaceArea());
    }

    public long getMaxExternalHeating() {
        return (long)((double)this.ambientTemp * QMDConfig.accelerator_thermal_conductivity * (double)this.getExteriorSurfaceArea());
    }

    public void switchIO() {
        boolean changed = false;
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (!port.isTriggered()) continue;
            if (port.getSetting() != port.getIOType()) {
                port.switchMode();
                changed = true;
                if (port.getIOType() == EnumTypes.IOType.INPUT) {
                    this.input = port;
                }
                if (port.getIOType() == EnumTypes.IOType.OUTPUT) {
                    this.output = port;
                }
            }
            port.resetTrigger();
        }
        if (changed) {
            for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
                if (port == this.input || port == this.output) continue;
                port.setIOType(EnumTypes.IOType.DISABLED);
            }
            this.checkIfMachineIsWhole();
        }
    }

    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.heatBuffer.writeToNBT(data, "heatBuffer");
        this.energyStorage.writeToNBT(data, "energyStorage");
        this.writeTanks(this.tanks, data, "tanks");
        this.writeBeams(this.beams, data);
        data.func_74757_a("isAcceleratorOn", this.isControllorOn);
        data.func_74772_a("cooling", this.cooling);
        data.func_74772_a("rawHeating", this.rawHeating);
        data.func_74768_a("coolantIn", this.maxCoolantIn);
        data.func_74768_a("coolantOut", this.maxCoolantOut);
        data.func_74780_a("maxOperatingTemp", (double)this.maxOperatingTemp);
        data.func_74772_a("requiredEnergy", (long)this.requiredEnergy);
        data.func_74780_a("efficiency", this.efficiency);
        data.func_74768_a("acceleratingVoltage", this.acceleratingVoltage);
        data.func_74768_a("RFCavityNumber", this.RFCavityNumber);
        data.func_74768_a("quadrapoleNumber", this.quadrupoleNumber);
        data.func_74780_a("quadrupoleStrength", this.quadrupoleStrength);
        data.func_74768_a("dipoleNumber", this.dipoleNumber);
        data.func_74780_a("dipoleStrength", this.dipoleStrength);
        data.func_74768_a("errorCode", this.errorCode);
        data.func_74757_a("isNew", this.isNew);
        data.func_74757_a("computerControlled", this.computerControlled);
        data.func_74768_a("energyPercentage", this.energyPercentage);
        this.writeLogicNBT(data, syncReason);
    }

    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.heatBuffer.readFromNBT(data, "heatBuffer");
        this.energyStorage.readFromNBT(data, "energyStorage");
        this.readTanks(this.tanks, data, "tanks");
        this.readBeams(this.beams, data);
        this.isControllorOn = data.func_74767_n("isAcceleratorOn");
        this.cooling = data.func_74763_f("cooling");
        this.rawHeating = data.func_74763_f("rawHeating");
        this.maxCoolantIn = data.func_74762_e("coolantIn");
        this.maxCoolantOut = data.func_74762_e("coolantOut");
        this.maxOperatingTemp = data.func_74762_e("maxOperatingTemp");
        this.requiredEnergy = data.func_74762_e("requiredEnergy");
        this.efficiency = data.func_74769_h("efficiency");
        this.acceleratingVoltage = data.func_74762_e("acceleratingVoltage");
        this.RFCavityNumber = data.func_74762_e("RFCavityNumber");
        this.quadrupoleNumber = data.func_74762_e("quadrapoleNumber");
        this.quadrupoleStrength = data.func_74769_h("quadrupoleStrength");
        this.dipoleNumber = data.func_74762_e("dipoleNumber");
        this.dipoleStrength = data.func_74769_h("dipoleStrength");
        this.errorCode = data.func_74762_e("errorCode");
        this.isNew = data.func_74767_n("isNew");
        this.computerControlled = data.func_74767_n("computerControlled");
        this.energyPercentage = data.func_74762_e("energyPercentage");
        this.readLogicNBT(data, syncReason);
    }

    public Set<EntityPlayer> getMultiblockUpdatePacketListeners() {
        return this.updatePacketListeners;
    }

    public AcceleratorUpdatePacket getMultiblockUpdatePacket() {
        return this.logic.getMultiblockUpdatePacket();
    }

    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
        int i;
        this.heatBuffer.setHeatCapacity(message.heatBuffer.getHeatCapacity());
        this.heatBuffer.setHeatStored(message.heatBuffer.getHeatStored());
        this.energyStorage.setStorageCapacity((long)message.energyStorage.getMaxEnergyStored());
        this.energyStorage.setEnergyStored((long)message.energyStorage.getEnergyStored());
        for (i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).readInfo(message.tanksInfo.get(i));
        }
        for (i = 0; i < message.beams.size(); ++i) {
            this.beams.set(i, message.beams.get(i));
        }
        this.isControllorOn = message.isAcceleratorOn;
        this.cooling = message.cooling;
        this.rawHeating = message.rawHeating;
        this.currentHeating = message.currentHeating;
        this.maxCoolantIn = message.maxCoolantIn;
        this.maxCoolantOut = message.maxCoolantOut;
        this.maxOperatingTemp = message.maxOperatingTemp;
        this.requiredEnergy = message.requiredEnergy;
        this.efficiency = message.efficiency;
        this.acceleratingVoltage = message.acceleratingVoltage;
        this.RFCavityNumber = message.RFCavityNumber;
        this.quadrupoleNumber = message.quadrupoleNumber;
        this.quadrupoleStrength = message.quadrupoleStrength;
        this.dipoleNumber = message.dipoleNumber;
        this.dipoleStrength = message.dipoleStrength;
        this.errorCode = message.errorCode;
        this.logic.onMultiblockUpdatePacket(message);
    }

    public void clearAllMaterial() {
        this.logic.clearAllMaterial();
        super.clearAllMaterial();
    }

    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return this.logic.isBlockGoodForInterior(world, pos);
    }

    @Override
    protected int getMinimumInteriorLength() {
        return this.logic.getMinimumInteriorLength();
    }

    @Override
    protected int getMaximumInteriorLength() {
        return this.logic.getMaximumInteriorLength();
    }

    public NBTTagCompound writeBeams(List<ParticleStorageAccelerator> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).writeToNBT(data, i);
        }
        return data;
    }

    public void readBeams(List<ParticleStorageAccelerator> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).readFromNBT(data, i);
        }
    }

    @Override
    public List<Tank> getTanks() {
        return this.tanks;
    }
}

