/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.DipoleMagnet;
import lach_01298.qmd.accelerator.QuadrupoleMagnet;
import lach_01298.qmd.accelerator.RFCavity;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorCooler;
import lach_01298.qmd.accelerator.tile.TileAcceleratorEnergyPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRedstonePort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorVent;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.block.property.BlockProperties;
import nc.multiblock.IPacketMultiblockLogic;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.MaterialHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class AcceleratorLogic
extends MultiblockLogic<Accelerator, AcceleratorLogic, IAcceleratorPart>
implements IPacketMultiblockLogic<Accelerator, AcceleratorLogic, IAcceleratorPart, AcceleratorUpdatePacket> {
    public boolean searchFlag = false;
    public final ObjectSet<TileAcceleratorCooler> coolerCache = new ObjectOpenHashSet();
    public final Long2ObjectMap<TileAcceleratorCooler> componentFailCache = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<TileAcceleratorCooler> assumedValidCache = new Long2ObjectOpenHashMap();
    protected boolean operational = false;
    private double excessCoolingRecipes = 0.0;
    private double excessHeat = 0.0;

    public AcceleratorLogic(Accelerator accelerator) {
        super((Multiblock)accelerator);
    }

    public AcceleratorLogic(AcceleratorLogic oldLogic) {
        super((MultiblockLogic)oldLogic);
    }

    public String getID() {
        return "";
    }

    public Accelerator getMultiblock() {
        return (Accelerator)this.multiblock;
    }

    public void onMachineAssembled() {
        this.onAcceleratorFormed();
    }

    public void onMachineRestored() {
        this.onAcceleratorFormed();
    }

    public void onMachinePaused() {
        this.onAcceleratorBroken();
    }

    public void onMachineDisassembled() {
        this.onAcceleratorBroken();
    }

    public void onAssimilate(Accelerator assimilated) {
        this.getMultiblock().heatBuffer.mergeHeatBuffers(assimilated.heatBuffer);
        this.getMultiblock().energyStorage.mergeEnergyStorage(assimilated.energyStorage);
        if (this.getMultiblock().isAssembled()) {
            this.onAcceleratorFormed();
        } else {
            this.onAcceleratorBroken();
        }
    }

    public void onAssimilated(Accelerator assimilator) {
    }

    public int getBeamLength() {
        return 0;
    }

    public double getBeamRadius() {
        return 0.0;
    }

    public int getCapacityMultiplier() {
        return this.getMultiblock().getInteriorVolume();
    }

    @Nonnull
    public List<Tank> getTanks(List<Tank> backupTanks) {
        return this.getMultiblock().isAssembled() ? this.getMultiblock().tanks : backupTanks;
    }

    public boolean isMachineWhole() {
        boolean inlet = false;
        boolean outlet = false;
        for (TileAcceleratorVent vent : this.getPartMap(TileAcceleratorVent.class).values()) {
            if (!((Boolean)vent.getBlockState(vent.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                inlet = true;
                continue;
            }
            outlet = true;
        }
        if (!inlet) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.no_inlet", null, new Object[0]);
            return false;
        }
        if (!outlet) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.no_outlet", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileAcceleratorEnergyPort.class).size() < 1) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return true;
    }

    public int getMinimumInteriorLength() {
        return 3;
    }

    public int getMaximumInteriorLength() {
        return QMDConfig.accelerator_linear_max_size;
    }

    public int getThickness() {
        return 5;
    }

    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends IAcceleratorPart>, String>>();
    }

    public boolean isBlockGoodForInterior(World world, BlockPos pos) {
        if (MaterialHelper.isReplaceable((Material)world.func_180495_p(pos).func_185904_a()) || world.func_175625_s(pos) instanceof TileAcceleratorPart) {
            return true;
        }
        return this.getMultiblock().standardLastError(pos);
    }

    public void onAcceleratorFormed() {
        Accelerator acc = this.getMultiblock();
        ObjectIterator objectIterator = this.getPartMap(IAcceleratorController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IAcceleratorController contr;
            acc.controller = contr = (IAcceleratorController)objectIterator.next();
        }
        acc.energyStorage.setStorageCapacity((long)(QMDConfig.accelerator_base_energy_capacity * this.getCapacityMultiplier()));
        acc.energyStorage.setMaxTransfer(QMDConfig.accelerator_base_energy_capacity * this.getCapacityMultiplier());
        acc.heatBuffer.setHeatCapacity((long)(QMDConfig.accelerator_base_heat_capacity * this.getCapacityMultiplier()));
        acc.ambientTemp = 273 + (int)(this.getWorld().func_180494_b(acc.getMiddleCoord()).func_180626_a(acc.getMiddleCoord()) * 20.0f);
        acc.tanks.get(0).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * this.getCapacityMultiplier());
        acc.tanks.get(1).setCapacity(QMDConfig.accelerator_base_output_tank_capacity * this.getCapacityMultiplier());
        if (!this.getWorld().field_72995_K) {
            if (acc.isNew) {
                acc.heatBuffer.setHeatStored((long)acc.ambientTemp * acc.heatBuffer.getHeatCapacity() / 400L);
            }
            acc.isNew = false;
            acc.currentHeating = 0L;
            acc.updateActivity();
            for (ParticleStorageAccelerator beam : acc.beams) {
                beam.setMaxEnergy(Long.MAX_VALUE);
            }
            acc.cooling = 0L;
            acc.maxOperatingTemp = 400;
            this.componentFailCache.clear();
            do {
                this.assumedValidCache.clear();
                this.refreshCoolers();
            } while (this.searchFlag);
            for (IAcceleratorComponent part : acc.getPartMap(IAcceleratorComponent.class).values()) {
                if (part instanceof TileAcceleratorCooler) {
                    TileAcceleratorCooler cooler = (TileAcceleratorCooler)part;
                    if (!part.isFunctional()) continue;
                    acc.cooling += (long)cooler.coolingRate;
                    continue;
                }
                if (!(part instanceof TileAcceleratorMagnet) && !(part instanceof TileAcceleratorRFCavity) || part.getMaxOperatingTemp() >= acc.maxOperatingTemp) continue;
                acc.maxOperatingTemp = part.getMaxOperatingTemp();
            }
        }
    }

    public void setBeamlineFunctional(Set<BlockPos> beamline) {
        for (BlockPos pos : beamline) {
            if (!(this.getMultiblock().WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam)) continue;
            TileAcceleratorBeam beam = (TileAcceleratorBeam)this.getWorld().func_175625_s(pos);
            beam.setFunctional(true);
        }
    }

    public void resetBeams() {
        for (ParticleStorageAccelerator beam : this.getMultiblock().beams) {
            beam.setMinEnergy(0L);
            beam.setMaxEnergy(Long.MAX_VALUE);
        }
    }

    public void formComponents() {
        Accelerator acc = this.getMultiblock();
        for (TileAcceleratorBeam beam : acc.getPartMap(TileAcceleratorBeam.class).values()) {
            if (!beam.isFunctional()) continue;
            if (acc.isValidRFCavity(beam.func_174877_v(), EnumFacing.Axis.X)) {
                acc.getRFCavityMap().put(beam.func_174877_v().func_177986_g(), (Object)new RFCavity(acc, beam.func_174877_v(), EnumFacing.Axis.X));
                continue;
            }
            if (acc.isValidRFCavity(beam.func_174877_v(), EnumFacing.Axis.Z)) {
                acc.getRFCavityMap().put(beam.func_174877_v().func_177986_g(), (Object)new RFCavity(acc, beam.func_174877_v(), EnumFacing.Axis.Z));
                continue;
            }
            if (acc.isValidQuadrupole(beam.func_174877_v(), EnumFacing.Axis.X)) {
                acc.getQuadrupoleMap().put(beam.func_174877_v().func_177986_g(), (Object)new QuadrupoleMagnet(acc, beam.func_174877_v(), EnumFacing.Axis.X));
                continue;
            }
            if (acc.isValidQuadrupole(beam.func_174877_v(), EnumFacing.Axis.Z)) {
                acc.getQuadrupoleMap().put(beam.func_174877_v().func_177986_g(), (Object)new QuadrupoleMagnet(acc, beam.func_174877_v(), EnumFacing.Axis.Z));
                continue;
            }
            if (acc.isValidDipole(beam.func_174877_v(), false)) {
                acc.getDipoleMap().put(beam.func_174877_v().func_177986_g(), (Object)new DipoleMagnet(acc, beam.func_174877_v()));
                continue;
            }
            if (!acc.isValidDipole(beam.func_174877_v(), true)) continue;
            acc.getDipoleMap().put(beam.func_174877_v().func_177986_g(), (Object)new DipoleMagnet(acc, beam.func_174877_v()));
        }
        acc.RFCavityNumber = acc.getRFCavityMap().size();
        acc.quadrupoleNumber = acc.getQuadrupoleMap().size();
        acc.dipoleNumber = acc.getDipoleMap().size();
        for (RFCavity cavity : acc.getRFCavityMap().values()) {
            for (IAcceleratorComponent componet : cavity.getComponents().values()) {
                componet.setFunctional(true);
            }
        }
        for (QuadrupoleMagnet quad : acc.getQuadrupoleMap().values()) {
            for (IAcceleratorComponent componet : quad.getComponents().values()) {
                componet.setFunctional(true);
            }
        }
        for (DipoleMagnet dipole : acc.dipoleMap.values()) {
            for (IAcceleratorComponent componet : dipole.getComponents().values()) {
                componet.setFunctional(true);
            }
        }
        for (TileAcceleratorBeamPort port : acc.getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (port.getIOType() == EnumTypes.IOType.INPUT) {
                acc.input = port;
            }
            if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
            acc.output = port;
        }
    }

    public void refreshStats() {
        TileAcceleratorMagnet magnet;
        int energy = 0;
        long heat = 0L;
        int parts = 0;
        double efficiency = 0.0;
        double quadStrength = 0.0;
        double dipoleStrength = 0.0;
        int voltage = 0;
        block0: for (DipoleMagnet dipole : this.getMultiblock().dipoleMap.values()) {
            for (IAcceleratorComponent componet : dipole.getComponents().values()) {
                if (!(componet instanceof TileAcceleratorMagnet)) continue;
                magnet = (TileAcceleratorMagnet)componet;
                dipoleStrength += magnet.strength;
                heat += (long)magnet.heat;
                energy += magnet.basePower;
                ++parts;
                efficiency += magnet.efficiency;
                continue block0;
            }
        }
        block2: for (QuadrupoleMagnet quad : this.getMultiblock().getQuadrupoleMap().values()) {
            for (IAcceleratorComponent componet : quad.getComponents().values()) {
                if (!(componet instanceof TileAcceleratorMagnet)) continue;
                magnet = (TileAcceleratorMagnet)componet;
                quadStrength += magnet.strength;
                heat += (long)magnet.heat;
                energy += magnet.basePower;
                ++parts;
                efficiency += magnet.efficiency;
                continue block2;
            }
        }
        block4: for (RFCavity cavity : this.getMultiblock().getRFCavityMap().values()) {
            for (IAcceleratorComponent componet : cavity.getComponents().values()) {
                if (!(componet instanceof TileAcceleratorRFCavity)) continue;
                TileAcceleratorRFCavity cav = (TileAcceleratorRFCavity)componet;
                voltage += cav.voltage;
                heat += (long)cav.heat;
                energy += cav.basePower;
                ++parts;
                efficiency += cav.efficiency;
                continue block4;
            }
        }
        for (TileAcceleratorIonSource source : this.getMultiblock().getPartMap(TileAcceleratorIonSource.class).values()) {
            energy += source.basePower;
        }
        this.getMultiblock().requiredEnergy = (int)((double)energy / (efficiency /= (double)parts));
        this.getMultiblock().rawHeating = heat;
        this.getMultiblock().dipoleStrength = dipoleStrength;
        this.getMultiblock().quadrupoleStrength = quadStrength;
        this.getMultiblock().acceleratingVoltage = voltage;
        this.getMultiblock().efficiency = efficiency;
    }

    private void refreshCoolers() {
        this.searchFlag = false;
        if (this.getPartMap(TileAcceleratorCooler.class).isEmpty()) {
            return;
        }
        for (TileAcceleratorCooler cooler : this.getParts(TileAcceleratorCooler.class)) {
            cooler.isInValidPosition = false;
            cooler.isSearched = false;
        }
        this.coolerCache.clear();
        for (TileAcceleratorCooler cooler : this.getParts(TileAcceleratorCooler.class)) {
            if (!cooler.isSearchRoot()) continue;
            this.iterateCoolerSearch(cooler, this.coolerCache);
        }
        for (TileAcceleratorCooler cooler : this.assumedValidCache.values()) {
            if (cooler.isInValidPosition) continue;
            this.componentFailCache.put(cooler.func_174877_v().func_177986_g(), (Object)cooler);
            this.searchFlag = true;
        }
    }

    private void iterateCoolerSearch(TileAcceleratorCooler rootCooler, ObjectSet<TileAcceleratorCooler> coolerCache) {
        ObjectOpenHashSet searchCache = new ObjectOpenHashSet();
        rootCooler.coolerSearch(coolerCache, (ObjectSet<TileAcceleratorCooler>)searchCache, this.componentFailCache, this.assumedValidCache);
        do {
            ObjectIterator searchIterator = searchCache.iterator();
            ObjectOpenHashSet searchSubCache = new ObjectOpenHashSet();
            while (searchIterator.hasNext()) {
                TileAcceleratorCooler component = (TileAcceleratorCooler)searchIterator.next();
                searchIterator.remove();
                component.coolerSearch(coolerCache, (ObjectSet<TileAcceleratorCooler>)searchSubCache, this.componentFailCache, this.assumedValidCache);
            }
            searchCache.addAll((Collection)searchSubCache);
        } while (!searchCache.isEmpty());
    }

    public void onAcceleratorBroken() {
        Accelerator acc = this.getMultiblock();
        for (RFCavity cavity : acc.getRFCavityMap().values()) {
            for (IAcceleratorComponent componet : cavity.getComponents().values()) {
                componet.setFunctional(false);
            }
        }
        for (QuadrupoleMagnet quad : acc.getQuadrupoleMap().values()) {
            for (IAcceleratorComponent componet : quad.getComponents().values()) {
                componet.setFunctional(false);
            }
        }
        for (DipoleMagnet dipole : acc.dipoleMap.values()) {
            for (IAcceleratorComponent componet : dipole.getComponents().values()) {
                componet.setFunctional(false);
            }
        }
        acc.getRFCavityMap().clear();
        acc.getQuadrupoleMap().clear();
        acc.dipoleMap.clear();
        for (TileAcceleratorBeam beam : acc.getPartMap(TileAcceleratorBeam.class).values()) {
            beam.setFunctional(false);
        }
        for (TileAcceleratorCooler cooler : acc.getPartMap(TileAcceleratorCooler.class).values()) {
            cooler.setFunctional(false);
        }
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            port.setRedstoneLevel(0);
        }
        acc.input = null;
        acc.output = null;
        this.operational = false;
        if (!this.getWorld().field_72995_K) {
            acc.updateActivity();
        }
    }

    public boolean onUpdateServer() {
        this.getMultiblock().errorCode = 0;
        this.getMultiblock().currentHeating = 0L;
        this.operate();
        this.externalHeating();
        this.refreshFluidRecipe();
        if (this.canProcessFluidInputs()) {
            this.produceFluidProducts();
        }
        this.updateRedstone();
        this.getMultiblock().updateActivity();
        return true;
    }

    public boolean isAcceleratorOn() {
        return this.operational;
    }

    protected void operate() {
        if (this.isRedstonePowered() && !this.getMultiblock().computerControlled || this.getMultiblock().computerControlled && this.getMultiblock().energyPercentage > 0) {
            this.refreshBeams();
            if (this.shouldUseEnergy()) {
                if (this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
                    this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
                    this.internalHeating();
                } else {
                    this.operational = false;
                    this.getMultiblock().errorCode = 2;
                    return;
                }
            }
            if (this.getMultiblock().getTemperature() <= this.getMultiblock().maxOperatingTemp) {
                this.operational = true;
                return;
            }
            if (this.operational) {
                this.quenchMagnets();
            }
            this.operational = false;
            this.getMultiblock().errorCode = 1;
            return;
        }
        this.operational = false;
    }

    protected void refreshBeams() {
    }

    protected boolean shouldUseEnergy() {
        return true;
    }

    public void quenchMagnets() {
        if (QMDConfig.accelerator_explosion) {
            ArrayList<BlockPos> components = new ArrayList<BlockPos>();
            for (TileAcceleratorMagnet magnet : this.getPartMap(TileAcceleratorMagnet.class).values()) {
                if (!magnet.isToHot()) continue;
                components.add(magnet.func_174877_v());
            }
            for (TileAcceleratorRFCavity cavity : this.getPartMap(TileAcceleratorRFCavity.class).values()) {
                if (!cavity.isToHot()) continue;
                components.add(cavity.func_174877_v());
            }
            if (!components.isEmpty()) {
                int explosions = 1 + this.rand.nextInt(1 + components.size() / 10);
                for (int i = 0; i < explosions; ++i) {
                    int j = this.rand.nextInt(components.size());
                    BlockPos component = (BlockPos)components.get(j);
                    ((Accelerator)this.multiblock).WORLD.func_72876_a(null, (double)component.func_177958_n(), (double)component.func_177956_o(), (double)component.func_177952_p(), 6.0f, true);
                    components.remove(j);
                }
            }
        }
    }

    protected void push() {
        TileEntity tile;
        if (this.getMultiblock().output != null && this.getMultiblock().output.getExternalFacing() != null && (tile = this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().output.func_174877_v().func_177972_a(this.getMultiblock().output.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().output.getExternalFacing().func_176734_d())) {
            IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().output.getExternalFacing().func_176734_d());
            otherStorage.reciveParticle(this.getMultiblock().output.getExternalFacing().func_176734_d(), this.getMultiblock().beams.get(1).getParticleStack());
        }
    }

    protected void pull() {
        TileEntity tile;
        if (this.getMultiblock().input != null && this.getMultiblock().input.getExternalFacing() != null && (tile = this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().input.func_174877_v().func_177972_a(this.getMultiblock().input.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().input.getExternalFacing().func_176734_d())) {
            IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().input.getExternalFacing().func_176734_d());
            ParticleStack stack = otherStorage.extractParticle(this.getMultiblock().input.getExternalFacing().func_176734_d());
            if (!this.getMultiblock().beams.get(0).reciveParticle(this.getMultiblock().input.getExternalFacing(), stack)) {
                this.getMultiblock().errorCode = stack.getMeanEnergy() > this.getMultiblock().beams.get(0).getMaxEnergy() ? 5 : 4;
            }
        }
    }

    protected void refreshFluidRecipe() {
        this.getMultiblock().coolingRecipeInfo = QMDRecipes.accelerator_cooling.getRecipeInfoFromInputs(new ArrayList(), this.getMultiblock().tanks.subList(0, 1));
        if (this.getMultiblock().coolingRecipeInfo != null) {
            this.getMultiblock().maxCoolantIn = (int)((double)this.getMultiblock().cooling / (double)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * 1000.0);
            this.getMultiblock().maxCoolantOut = (int)((double)((long)((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0)).getMaxStackSize(0) * this.getMultiblock().cooling) / (double)(((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * ((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getMaxStackSize(0)) * 1000.0);
        }
    }

    protected boolean canProcessFluidInputs() {
        if (this.getMultiblock().coolingRecipeInfo == null) {
            return false;
        }
        IFluidIngredient fluidInput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0);
        IFluidIngredient fluidOutput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        Tank outputTank = this.getMultiblock().tanks.get(1);
        long maximumHeatChange = this.getMultiblock().cooling;
        int heatPerMB = ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB();
        if (this.getMultiblock().getTemperature() <= ((FluidStack)fluidInput.getStack()).getFluid().getTemperature()) {
            return false;
        }
        if (fluidOutput.getMaxStackSize(0) <= 0 || fluidOutput.getStack() == null) {
            return false;
        }
        double recipesPerTick = (double)maximumHeatChange / (double)(fluidInput.getMaxStackSize(0) * heatPerMB);
        if (!outputTank.isEmpty()) {
            if (!outputTank.getFluid().isFluidEqual((FluidStack)fluidOutput.getStack())) {
                return false;
            }
            if ((double)outputTank.getFluidAmount() + (recipesPerTick + this.excessCoolingRecipes) * (double)fluidOutput.getMaxStackSize(0) > (double)outputTank.getCapacity()) {
                return false;
            }
        }
        return this.getMultiblock().heatBuffer.getHeatStored() >= (long)(fluidInput.getMaxStackSize(0) * heatPerMB);
    }

    private void produceFluidProducts() {
        IFluidIngredient fluidInput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0);
        IFluidIngredient fluidOutput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        Tank inputTank = this.getMultiblock().tanks.get(0);
        Tank outputTank = this.getMultiblock().tanks.get(1);
        long maximumHeatChange = this.getMultiblock().cooling;
        int heatPerMB = ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB();
        double recipesPerTick = (double)maximumHeatChange / (double)(fluidInput.getMaxStackSize(0) * heatPerMB);
        if (recipesPerTick * (double)fluidInput.getMaxStackSize(0) > (double)inputTank.getFluidAmount()) {
            recipesPerTick = (double)inputTank.getFluidAmount() / (double)fluidInput.getMaxStackSize(0);
        }
        if (recipesPerTick * (double)fluidInput.getMaxStackSize(0) * (double)heatPerMB > (double)this.getMultiblock().heatBuffer.getHeatStored()) {
            recipesPerTick = this.getMultiblock().heatBuffer.getHeatStored() / (long)(fluidInput.getMaxStackSize(0) * heatPerMB);
        }
        int recipesThisTick = (int)Math.floor(recipesPerTick);
        this.excessCoolingRecipes += recipesPerTick - (double)recipesThisTick;
        if (this.excessCoolingRecipes >= 1.0) {
            recipesThisTick += (int)Math.floor(this.excessCoolingRecipes);
            this.excessCoolingRecipes -= Math.floor(this.excessCoolingRecipes);
        }
        inputTank.changeFluidAmount(-recipesThisTick * fluidInput.getMaxStackSize(0));
        if (inputTank.getFluidAmount() <= 0) {
            inputTank.setFluidStored(null);
        }
        if (outputTank.isEmpty()) {
            outputTank.changeFluidStored(fluidOutput.getNextStack(0).getFluid(), recipesThisTick * fluidOutput.getMaxStackSize(0));
        } else {
            outputTank.changeFluidAmount(recipesThisTick * fluidOutput.getMaxStackSize(0));
        }
        double heatChange = recipesThisTick * fluidInput.getMaxStackSize(0) * heatPerMB;
        this.excessHeat += heatChange;
        if (this.excessHeat > 1.0) {
            long thisTickHeatChange = (long)Math.floor(this.excessHeat);
            this.excessHeat -= (double)thisTickHeatChange;
            this.getMultiblock().heatBuffer.changeHeatStored(-thisTickHeatChange);
        }
    }

    protected void externalHeating() {
        this.getMultiblock().heatBuffer.addHeat(this.getMultiblock().getExternalHeating(), false);
        this.getMultiblock().currentHeating += this.getMultiblock().getExternalHeating();
    }

    protected void internalHeating() {
        this.getMultiblock().heatBuffer.addHeat(this.getMultiblock().rawHeating, false);
        this.getMultiblock().currentHeating += this.getMultiblock().rawHeating;
    }

    protected boolean isRedstonePowered() {
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || !port.checkIsRedstonePowered(this.getWorld(), port.func_174877_v())) continue;
            return true;
        }
        return this.getMultiblock().controller != null && this.getMultiblock().controller.checkIsRedstonePowered(this.getWorld(), this.getMultiblock().controller.getTilePos());
    }

    protected int getRedstoneLevel() {
        int level = this.getWorld().func_175687_A(this.getMultiblock().controller.getTilePos());
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || this.getWorld().func_175687_A(port.func_174877_v()) <= level) continue;
            level = this.getWorld().func_175687_A(port.func_174877_v());
        }
        return level;
    }

    protected void updateRedstone() {
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            if (!((Boolean)this.getMultiblock().WORLD.func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) continue;
            port.setRedstoneLevel((int)(15.0 * ((double)this.getMultiblock().getTemperature() / (double)this.getMultiblock().maxOperatingTemp)));
        }
    }

    public void onUpdateClient() {
    }

    public void writeToLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        data.func_74780_a("excessCoolingRecipes", this.excessCoolingRecipes);
        data.func_74780_a("excessHeat", this.excessHeat);
    }

    public void readFromLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.excessCoolingRecipes = data.func_74769_h("excessCoolingRecipes");
        this.excessHeat = data.func_74769_h("excessHeat");
    }

    public AcceleratorUpdatePacket getMultiblockUpdatePacket() {
        return null;
    }

    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
    }

    public void clearAllMaterial() {
        for (Tank tank : this.getMultiblock().tanks) {
            tank.setFluidStored(null);
        }
    }
}

