/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonCollector;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSynchrotronPort;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.BeamSplitterUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Equations;
import nc.multiblock.tile.TileBeefAbstract;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class BeamSplitterLogic
extends AcceleratorLogic {
    public static final List<Pair<Class<? extends IAcceleratorPart>, String>> PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileAcceleratorSynchrotronPort.class, (Object)"qmd.multiblock_validation.accelerator.no_synch_ports"), Pair.of(TileAcceleratorRFCavity.class, (Object)"qmd.multiblock_validation.accelerator.no_rf_cavity"), Pair.of(TileAcceleratorIonSource.class, (Object)"qmd.multiblock_validation.accelerator.no_source"), Pair.of(TileAcceleratorIonCollector.class, (Object)"qmd.multiblock_validation.accelerator.no_ion_collectors"), Pair.of(TileAcceleratorPort.class, (Object)"qmd.multiblock_validation.accelerator.no_ion_ports")});

    public BeamSplitterLogic(AcceleratorLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "beam_splitter";
    }

    @Override
    public int getBeamLength() {
        return this.getMultiblock().getExteriorLengthX();
    }

    @Override
    public double getBeamRadius() {
        return QMDConfig.beamDiverterRadius;
    }

    public long getEnergyLoss() {
        return Equations.cornerEnergyLoss(this.getMultiblock().beams.get(0).getParticleStack(), this.getBeamRadius());
    }

    public long getMaxEnergy() {
        if (this.getMultiblock().beams.get(0).getParticleStack() != null) {
            Particle particle = this.getMultiblock().beams.get(0).getParticleStack().getParticle();
            return Equations.ringEnergyMaxEnergyFromDipole(this.getMultiblock().dipoleStrength, this.getBeamRadius(), particle.getCharge(), particle.getMass());
        }
        return 0L;
    }

    public long getAcceleratorMaxEnergy(Particle particle) {
        if (particle != null) {
            return Equations.ringEnergyMaxEnergyFromDipole(this.getMultiblock().dipoleStrength, this.getBeamRadius(), particle.getCharge(), particle.getMass());
        }
        return 0L;
    }

    @Override
    public boolean isMachineWhole() {
        Accelerator acc = this.getMultiblock();
        if (acc.getExteriorLengthX() != this.getThickness() || acc.getExteriorLengthY() != this.getThickness() || acc.getExteriorLengthZ() != this.getThickness()) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.beam_director.must_be_cube", null, new Object[0]);
            return false;
        }
        if (!(acc.WORLD.func_175625_s(acc.getMiddleCoord()) instanceof TileAcceleratorBeam)) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.beam_director.must_be_beam", acc.getMiddleCoord(), new Object[0]);
            return false;
        }
        if (!acc.isValidDipole(acc.getMiddleCoord(), false) && !acc.isValidDipole(acc.getMiddleCoord(), true)) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.beam_director.must_be_dipole", acc.getMiddleCoord(), new Object[0]);
            return false;
        }
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            boolean valid = false;
            if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177981_b(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177979_c(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177964_d(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177970_e(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177965_g(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177985_f(2).func_177986_g()) {
                valid = true;
            }
            if (valid) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.invalid_beam_port", port.func_174877_v(), new Object[0]);
            return false;
        }
        int inputs = 0;
        int outputs = 0;
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            port.recalculateExternalDirection(acc.getMinimumCoord(), acc.getMaximumCoord());
            if (port.getExternalFacing() == null) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.something_is_wrong", port.func_174877_v(), new Object[0]);
                return false;
            }
            if (!(acc.WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing().func_176734_d())) instanceof TileAcceleratorBeam)) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.beam_port_must_connect", port.func_174877_v().func_177972_a(port.getExternalFacing().func_176734_d()), new Object[0]);
                return false;
            }
            if (port.getIOType() == EnumTypes.IOType.INPUT) {
                ++inputs;
            }
            if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
            ++outputs;
        }
        if (inputs != 1 || outputs != 2) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.splitter.must_have_io", null, new Object[0]);
            return false;
        }
        if (this.containsBlacklistedPart()) {
            return false;
        }
        return super.isMachineWhole();
    }

    @Override
    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }

    @Override
    public void onAcceleratorFormed() {
        Accelerator acc = this.getMultiblock();
        if (!this.getWorld().field_72995_K) {
            this.resetBeams();
            HashSet<BlockPos> postions = new HashSet<BlockPos>();
            postions.add(acc.getMiddleCoord().func_185334_h());
            this.setBeamlineFunctional(postions);
            this.formComponents();
        }
        this.refreshStats();
        super.onAcceleratorFormed();
        acc.cooling = 2L * (acc.rawHeating + acc.getMaxExternalHeating());
    }

    @Override
    public boolean onUpdateServer() {
        super.onUpdateServer();
        if (this.getMultiblock().isControllorOn) {
            this.produceBeam();
        } else {
            this.resetOutputBeam();
        }
        this.push();
        this.getMultiblock().sendMultiblockUpdatePacketToListeners();
        return true;
    }

    @Override
    protected void refreshBeams() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.pull();
    }

    @Override
    protected boolean shouldUseEnergy() {
        return this.getMultiblock().beams.get(0).getParticleStack() != null;
    }

    @Override
    protected void push() {
        if (this.getMultiblock().input != null && this.getMultiblock().input.getExternalFacing() != null) {
            for (TileAcceleratorBeamPort port : this.getMultiblock().getPartMap(TileAcceleratorBeamPort.class).values()) {
                IParticleStackHandler otherStorage;
                TileEntity tile;
                if (port.getExternalFacing() == null || port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                if (port.func_174877_v().func_177967_a(port.getExternalFacing().func_176734_d(), this.getThickness() - 1).equals((Object)this.getMultiblock().input.func_174877_v())) {
                    tile = this.getMultiblock().WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing()));
                    if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d())) continue;
                    otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d());
                    otherStorage.reciveParticle(port.getExternalFacing().func_176734_d(), this.getMultiblock().beams.get(2).getParticleStack());
                    continue;
                }
                tile = this.getMultiblock().WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing()));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d())) continue;
                otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d());
                otherStorage.reciveParticle(port.getExternalFacing().func_176734_d(), this.getMultiblock().beams.get(1).getParticleStack());
            }
        }
    }

    @Override
    protected void pull() {
        IParticleStackHandler otherStorage;
        ParticleStack stack;
        TileEntity tile;
        if (this.getMultiblock().input != null && this.getMultiblock().input.getExternalFacing() != null && (tile = this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().input.func_174877_v().func_177972_a(this.getMultiblock().input.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().input.getExternalFacing().func_176734_d()) && (stack = (otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().input.getExternalFacing().func_176734_d())).extractParticle(this.getMultiblock().input.getExternalFacing().func_176734_d())) != null) {
            this.getMultiblock().beams.get(0).setMaxEnergy(this.getAcceleratorMaxEnergy(stack.getParticle()));
            if (!this.getMultiblock().beams.get(0).reciveParticle(this.getMultiblock().input.getExternalFacing(), stack)) {
                if (stack.getMeanEnergy() > this.getMultiblock().beams.get(0).getMaxEnergy()) {
                    this.getMultiblock().errorCode = 5;
                } else if (stack.getMeanEnergy() < this.getMultiblock().beams.get(0).getMinEnergy()) {
                    this.getMultiblock().errorCode = 4;
                }
            }
        }
    }

    private void resetOutputBeam() {
        this.getMultiblock().beams.get(1).setParticleStack(null);
        this.getMultiblock().beams.get(2).setParticleStack(null);
    }

    private void produceBeam() {
        if (this.getMultiblock().beams.get(0).getParticleStack() != null) {
            ParticleStack stackIn = this.getMultiblock().beams.get(0).getParticleStack();
            this.getMultiblock().beams.get(1).setParticleStack(stackIn.copy());
            this.getMultiblock().beams.get(1).getParticleStack().setAmount(stackIn.getAmount() / 2);
            this.getMultiblock().beams.get(2).setParticleStack(stackIn.copy());
            this.getMultiblock().beams.get(2).getParticleStack().setAmount(stackIn.getAmount() / 2);
            if (stackIn.getMeanEnergy() <= this.getMaxEnergy()) {
                ParticleStack particleOut = this.getMultiblock().beams.get(1).getParticleStack();
                ParticleStack particleStraightOut = this.getMultiblock().beams.get(2).getParticleStack();
                particleOut.addMeanEnergy(-Equations.cornerEnergyLoss(stackIn, this.getBeamRadius()));
                particleOut.addFocus(-Equations.focusLoss(this.getBeamLength(), stackIn));
                particleStraightOut.addFocus(-Equations.focusLoss(this.getBeamLength(), stackIn));
                if (particleOut.getFocus() <= 0.0) {
                    particleOut = null;
                    this.getMultiblock().errorCode = 3;
                }
                if (particleStraightOut.getFocus() <= 0.0) {
                    particleStraightOut = null;
                    this.getMultiblock().errorCode = 3;
                }
            }
        } else {
            this.resetOutputBeam();
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
    }

    @Override
    public BeamSplitterUpdatePacket getMultiblockUpdatePacket() {
        return new BeamSplitterUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isControllorOn, this.getMultiblock().cooling, this.getMultiblock().rawHeating, this.getMultiblock().currentHeating, this.getMultiblock().maxCoolantIn, this.getMultiblock().maxCoolantOut, this.getMultiblock().maxOperatingTemp, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().acceleratingVoltage, this.getMultiblock().RFCavityNumber, this.getMultiblock().quadrupoleNumber, this.getMultiblock().quadrupoleStrength, this.getMultiblock().dipoleNumber, this.getMultiblock().dipoleStrength, this.getMultiblock().errorCode, this.getMultiblock().heatBuffer, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams);
    }

    @Override
    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof BeamSplitterUpdatePacket) {
            BeamSplitterUpdatePacket beamSplitterUpdatePacket = (BeamSplitterUpdatePacket)message;
        }
    }
}

