/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonCollector;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSynchrotronPort;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.DeceleratorUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Equations;
import nc.multiblock.tile.TileBeefAbstract;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class DeceleratorLogic
extends AcceleratorLogic {
    public static final List<Pair<Class<? extends IAcceleratorPart>, String>> PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileAcceleratorIonSource.class, (Object)"qmd.multiblock_validation.accelerator.source"), Pair.of(TileAcceleratorSynchrotronPort.class, (Object)"qmd.multiblock_validation.accelerator.no_synch_ports"), Pair.of(TileAcceleratorIonCollector.class, (Object)"qmd.multiblock_validation.accelerator.no_ion_collectors"), Pair.of(TileAcceleratorPort.class, (Object)"qmd.multiblock_validation.accelerator.no_ion_ports")});

    public DeceleratorLogic(AcceleratorLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "decelerator";
    }

    @Override
    public int getBeamLength() {
        return 4 * (this.getMultiblock().getInteriorLengthX() - 2);
    }

    @Override
    public double getBeamRadius() {
        return (double)(this.getMultiblock().getInteriorLengthX() - 2) / 2.0;
    }

    public long getAcceleratorMaxEnergy(Particle particle) {
        if (particle != null && this.getMultiblock().acceleratingVoltage > 0) {
            return Equations.ringEnergyMaxEnergyFromDipole(this.getMultiblock().dipoleStrength, this.getBeamRadius(), particle.getCharge(), particle.getMass());
        }
        return 0L;
    }

    @Override
    public boolean isMachineWhole() {
        Accelerator acc = this.getMultiblock();
        if (acc.getExteriorLengthY() != this.getThickness()) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.wrong_height", null, new Object[0]);
            return false;
        }
        if (acc.getExteriorLengthX() != acc.getExteriorLengthZ()) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.must_be_square", null, new Object[0]);
            return false;
        }
        if (acc.getExteriorLengthX() < QMDConfig.accelerator_ring_min_size) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.to_short", null, new Object[0]);
            return false;
        }
        if (acc.getExteriorLengthX() > QMDConfig.accelerator_ring_max_size) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.to_long", null, new Object[0]);
            return false;
        }
        for (BlockPos pos : this.getinteriorAxisPositions()) {
            if (acc.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.must_be_beam", pos, new Object[0]);
            return false;
        }
        for (BlockPos pos : this.getinteriorAxisConners()) {
            if (acc.isValidDipole(pos, false)) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.must_be_dipole_in_conner", pos, new Object[0]);
            return false;
        }
        int inputs = 0;
        int outputs = 0;
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (port.getIOType() == EnumTypes.IOType.INPUT) {
                ++inputs;
            }
            if (port.getIOType() == EnumTypes.IOType.OUTPUT) {
                ++outputs;
            }
            if (port.func_174877_v().func_177956_o() != acc.getMiddleY()) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.must_be_inline_with_beam", port.func_174877_v(), new Object[0]);
                return false;
            }
            port.recalculateExternalDirection(acc.getMinimumCoord(), acc.getMaximumCoord());
            if (port.getExternalFacing() == null) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.something_is_wrong", port.func_174877_v(), new Object[0]);
                return false;
            }
            if (!(acc.WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing().func_176734_d())) instanceof TileAcceleratorBeam)) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.beam_port_must_connect", port.func_174877_v().func_177972_a(port.getExternalFacing().func_176734_d()), new Object[0]);
                return false;
            }
            if (acc.isValidDipole(port.func_174877_v().func_177967_a(port.getExternalFacing().func_176734_d(), 2), false)) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.must_be_dipole", port.func_174877_v().func_177967_a(port.getExternalFacing().func_176734_d(), 2), new Object[0]);
            return false;
        }
        if (inputs != 1 || outputs != 1) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.must_have_io", null, new Object[0]);
            return false;
        }
        if (this.containsBlacklistedPart()) {
            return false;
        }
        return super.isMachineWhole();
    }

    public Set<BlockPos> getinteriorAxisPositions() {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        Accelerator acc = this.getMultiblock();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, false).func_177982_a(1, acc.getInteriorLengthY() / 2, (this.getThickness() - 2) / 2), (BlockPos)acc.getExtremeInteriorCoord(true, false, false).func_177982_a(-1, acc.getInteriorLengthY() / 2, (this.getThickness() - 2) / 2))) {
            postions.add(pos.func_185334_h());
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, true).func_177982_a(1, acc.getInteriorLengthY() / 2, -(this.getThickness() - 2) / 2), (BlockPos)acc.getExtremeInteriorCoord(true, false, true).func_177982_a(-1, acc.getInteriorLengthY() / 2, -(this.getThickness() - 2) / 2))) {
            postions.add(pos.func_185334_h());
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, false).func_177982_a((this.getThickness() - 2) / 2, acc.getInteriorLengthY() / 2, 1), (BlockPos)acc.getExtremeInteriorCoord(false, false, true).func_177982_a((this.getThickness() - 2) / 2, acc.getInteriorLengthY() / 2, -1))) {
            postions.add(pos.func_185334_h());
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(true, false, false).func_177982_a(-(this.getThickness() - 2) / 2, acc.getInteriorLengthY() / 2, 1), (BlockPos)acc.getExtremeInteriorCoord(true, false, true).func_177982_a(-(this.getThickness() - 2) / 2, acc.getInteriorLengthY() / 2, -1))) {
            postions.add(pos.func_185334_h());
        }
        return postions;
    }

    public Set<BlockPos> getinteriorAxisConners() {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        Accelerator acc = this.getMultiblock();
        postions.add(acc.getExtremeInteriorCoord(false, false, false).func_177982_a(1, acc.getInteriorLengthY() / 2, (this.getThickness() - 2) / 2));
        postions.add(acc.getExtremeInteriorCoord(false, false, true).func_177982_a(1, acc.getInteriorLengthY() / 2, -(this.getThickness() - 2) / 2));
        postions.add(acc.getExtremeInteriorCoord(true, false, false).func_177982_a(-(this.getThickness() - 2) / 2, acc.getInteriorLengthY() / 2, 1));
        postions.add(acc.getExtremeInteriorCoord(true, false, true).func_177982_a(-(this.getThickness() - 2) / 2, acc.getInteriorLengthY() / 2, -1));
        return postions;
    }

    @Override
    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }

    @Override
    public void onAcceleratorFormed() {
        Accelerator acc = this.getMultiblock();
        if (!this.getWorld().field_72995_K) {
            this.resetBeams();
            this.setBeamlineFunctional(this.getinteriorAxisPositions());
            this.formComponents();
        }
        this.refreshStats();
        super.onAcceleratorFormed();
    }

    @Override
    public boolean onUpdateServer() {
        super.onUpdateServer();
        if (this.getMultiblock().isControllorOn) {
            this.produceBeam();
        } else {
            this.resetOutputBeam();
        }
        this.push();
        this.getMultiblock().sendMultiblockUpdatePacketToListeners();
        return true;
    }

    @Override
    protected void refreshBeams() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.pull();
    }

    @Override
    protected boolean shouldUseEnergy() {
        return this.getMultiblock().beams.get(0).getParticleStack() != null;
    }

    @Override
    protected void pull() {
        IParticleStackHandler otherStorage;
        ParticleStack stack;
        TileEntity tile;
        if (this.getMultiblock().input != null && this.getMultiblock().input.getExternalFacing() != null && (tile = this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().input.func_174877_v().func_177972_a(this.getMultiblock().input.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().input.getExternalFacing().func_176734_d()) && (stack = (otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getMultiblock().input.getExternalFacing().func_176734_d())).extractParticle(this.getMultiblock().input.getExternalFacing().func_176734_d())) != null) {
            this.getMultiblock().beams.get(0).setMaxEnergy(this.getAcceleratorMaxEnergy(stack.getParticle()));
            if (!this.getMultiblock().beams.get(0).reciveParticle(this.getMultiblock().input.getExternalFacing(), stack)) {
                if (stack.getMeanEnergy() > this.getMultiblock().beams.get(0).getMaxEnergy()) {
                    this.getMultiblock().errorCode = 5;
                } else if (stack.getMeanEnergy() < this.getMultiblock().beams.get(0).getMinEnergy()) {
                    this.getMultiblock().errorCode = 4;
                }
            }
        }
    }

    private void resetOutputBeam() {
        this.getMultiblock().beams.get(1).setParticleStack(null);
    }

    private void produceBeam() {
        if (this.getMultiblock().beams.get(0).getParticleStack() != null) {
            ParticleStack beam = this.getMultiblock().beams.get(0).getParticleStack();
            this.getMultiblock().beams.get(1).setParticleStack(beam.copy());
            Particle particle = beam.getParticle();
            ParticleStack beamOut = this.getMultiblock().beams.get(1).getParticleStack();
            double fraction = 1.0;
            fraction = this.getMultiblock().computerControlled ? 1.0 - (double)this.getMultiblock().energyPercentage / 100.0 : 1.0 - (double)this.getRedstoneLevel() / 15.0;
            long energyTarget = (long)((double)this.getAcceleratorMaxEnergy(particle) * fraction);
            if (energyTarget > beam.getMeanEnergy()) {
                beamOut.setMeanEnergy(beam.getMeanEnergy());
            } else {
                beamOut.setMeanEnergy(energyTarget);
            }
            beamOut.addFocus(Equations.focusGain(this.getMultiblock().quadrupoleStrength, beamOut));
            if (beamOut.getFocus() <= 0.0) {
                this.getMultiblock().errorCode = 3;
            }
        } else {
            this.resetOutputBeam();
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
    }

    @Override
    public DeceleratorUpdatePacket getMultiblockUpdatePacket() {
        return new DeceleratorUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isControllorOn, this.getMultiblock().cooling, this.getMultiblock().rawHeating, this.getMultiblock().currentHeating, this.getMultiblock().maxCoolantIn, this.getMultiblock().maxCoolantOut, this.getMultiblock().maxOperatingTemp, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().acceleratingVoltage, this.getMultiblock().RFCavityNumber, this.getMultiblock().quadrupoleNumber, this.getMultiblock().quadrupoleStrength, this.getMultiblock().dipoleNumber, this.getMultiblock().dipoleStrength, this.getMultiblock().errorCode, this.getMultiblock().heatBuffer, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams);
    }

    @Override
    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof DeceleratorUpdatePacket) {
            DeceleratorUpdatePacket deceleratorUpdatePacket = (DeceleratorUpdatePacket)message;
        }
    }
}

