/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonCollector;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSynchrotronPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorYoke;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.LinearAcceleratorUpdatePacket;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.util.Equations;
import nc.block.property.BlockProperties;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.fluid.Tank;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class LinearAcceleratorLogic
extends AcceleratorLogic {
    protected TileAcceleratorIonSource source;
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public static final List<Pair<Class<? extends IAcceleratorPart>, String>> PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileAcceleratorYoke.class, (Object)"qmd.multiblock_validation.accelerator.no_yokes"), Pair.of(TileAcceleratorSynchrotronPort.class, (Object)"qmd.multiblock_validation.accelerator.no_synch_ports"), Pair.of(TileAcceleratorIonCollector.class, (Object)"qmd.multiblock_validation.accelerator.no_ion_collectors")});

    public LinearAcceleratorLogic(AcceleratorLogic oldLogic) {
        super(oldLogic);
        if (!(oldLogic instanceof LinearAcceleratorLogic) && !oldLogic.getID().equals("")) {
            this.getMultiblock().tanks.get(2).setFluidStored(null);
        }
    }

    @Override
    public String getID() {
        return "linear_accelerator";
    }

    @Override
    public int getBeamLength() {
        return this.getMultiblock().getExteriorLengthX() > this.getMultiblock().getExteriorLengthZ() ? this.getMultiblock().getExteriorLengthX() : this.getMultiblock().getExteriorLengthZ();
    }

    public TileAcceleratorIonSource getSource() {
        return this.source;
    }

    @Override
    public boolean isMachineWhole() {
        int outputs;
        int inputs;
        ArrayList<TileAcceleratorBeamPort> ports;
        ObjectIterator end2;
        BlockPos end1;
        EnumFacing.Axis axis;
        Accelerator acc = this.getMultiblock();
        if (acc.getExteriorLengthY() != this.getThickness()) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.wrong_height", null, new Object[0]);
            return false;
        }
        if (acc.getExteriorLengthX() > acc.getExteriorLengthZ()) {
            axis = EnumFacing.Axis.X;
            if (acc.getExteriorLengthX() < QMDConfig.accelerator_linear_min_size) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.to_short", null, new Object[0]);
                return false;
            }
            if (acc.getExteriorLengthZ() != this.getThickness()) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_be_5_wide", null, new Object[0]);
                return false;
            }
        } else {
            axis = EnumFacing.Axis.Z;
            if (acc.getExteriorLengthZ() < QMDConfig.accelerator_linear_min_size) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.to_short", null, new Object[0]);
                return false;
            }
            if (acc.getExteriorLengthX() != this.getThickness()) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_be_5_wide", null, new Object[0]);
                return false;
            }
        }
        for (BlockPos pos : this.getinteriorAxisPositions(axis)) {
            if (acc.WORLD.func_175625_s(pos) instanceof TileAcceleratorBeam) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_be_beam", pos, new Object[0]);
            return false;
        }
        if (axis == EnumFacing.Axis.X) {
            end1 = acc.getExtremeCoord(false, false, false).func_177982_a(0, this.getThickness() / 2, this.getThickness() / 2);
            end2 = acc.getExtremeCoord(true, false, false).func_177982_a(0, this.getThickness() / 2, this.getThickness() / 2);
            if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort) {
                ports = new ArrayList<TileAcceleratorBeamPort>();
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s(end1));
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s((BlockPos)end2));
                inputs = 0;
                outputs = 0;
                for (TileAcceleratorBeamPort port : ports) {
                    if (port.getIOType() == EnumTypes.IOType.INPUT) {
                        ++inputs;
                    }
                    if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                    ++outputs;
                }
                if (inputs != 1 || outputs != 1) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_have_io", null, new Object[0]);
                    return false;
                }
            } else {
                if (!(acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorIonSource && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort || acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorIonSource)) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.have_source_and_beam_port", null, new Object[0]);
                    return false;
                }
                if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorIonSource) {
                    if (acc.WORLD.func_180495_p(end1).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.EAST) {
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", end1, new Object[0]);
                        return false;
                    }
                } else if (acc.WORLD.func_180495_p((BlockPos)end2).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.WEST) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", (BlockPos)end2, new Object[0]);
                    return false;
                }
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            end1 = acc.getExtremeCoord(false, false, false).func_177982_a(this.getThickness() / 2, this.getThickness() / 2, 0);
            end2 = acc.getExtremeCoord(false, false, true).func_177982_a(this.getThickness() / 2, this.getThickness() / 2, 0);
            if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort) {
                ports = new ArrayList();
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s(end1));
                ports.add((TileAcceleratorBeamPort)acc.WORLD.func_175625_s((BlockPos)end2));
                inputs = 0;
                outputs = 0;
                for (TileAcceleratorBeamPort port : ports) {
                    if (port.getIOType() == EnumTypes.IOType.INPUT) {
                        ++inputs;
                    }
                    if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                    ++outputs;
                }
                if (inputs != 1 || outputs != 1) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.must_have_io", null, new Object[0]);
                    return false;
                }
            } else {
                if (!(acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorIonSource && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorBeamPort || acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorBeamPort && acc.WORLD.func_175625_s((BlockPos)end2) instanceof TileAcceleratorIonSource)) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.have_source_and_beam_port", null, new Object[0]);
                    return false;
                }
                if (acc.WORLD.func_175625_s(end1) instanceof TileAcceleratorIonSource) {
                    if (acc.WORLD.func_180495_p(end1).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.SOUTH) {
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", end1, new Object[0]);
                        return false;
                    }
                } else if (acc.WORLD.func_180495_p((BlockPos)end2).func_177229_b((IProperty)BlockProperties.FACING_ALL) != EnumFacing.NORTH) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.source_must_face_in", (BlockPos)end2, new Object[0]);
                    return false;
                }
            }
        }
        int sources = 0;
        for (TileAcceleratorIonSource port : this.getPartMap(TileAcceleratorIonSource.class).values()) {
            ++sources;
        }
        if (sources > 1) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.only_one_source", null, new Object[0]);
            return false;
        }
        int ports2 = 0;
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            ++ports2;
        }
        if (ports2 > 2 - sources) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.linear.to_many_beam_ports", null, new Object[0]);
            return false;
        }
        if (this.containsBlacklistedPart()) {
            return false;
        }
        return super.isMachineWhole();
    }

    public Set<BlockPos> getinteriorAxisPositions(EnumFacing.Axis axis) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        Accelerator acc = this.getMultiblock();
        if (axis == EnumFacing.Axis.X) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, false).func_177982_a(0, acc.getInteriorLengthY() / 2, acc.getInteriorLengthZ() / 2), (BlockPos)acc.getExtremeInteriorCoord(true, false, false).func_177982_a(0, acc.getInteriorLengthY() / 2, acc.getInteriorLengthZ() / 2))) {
                postions.add(pos.func_185334_h());
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)acc.getExtremeInteriorCoord(false, false, false).func_177982_a(acc.getInteriorLengthX() / 2, acc.getInteriorLengthY() / 2, 0), (BlockPos)acc.getExtremeInteriorCoord(false, false, true).func_177982_a(acc.getInteriorLengthX() / 2, acc.getInteriorLengthY() / 2, 0))) {
                postions.add(pos.func_185334_h());
            }
        }
        return postions;
    }

    @Override
    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }

    @Override
    public void onAcceleratorFormed() {
        Accelerator acc = this.getMultiblock();
        if (!this.getWorld().field_72995_K) {
            this.resetBeams();
            EnumFacing.Axis axis = ((Accelerator)this.multiblock).getExteriorLengthX() > ((Accelerator)this.multiblock).getExteriorLengthZ() ? EnumFacing.Axis.X : EnumFacing.Axis.Z;
            this.setBeamlineFunctional(this.getinteriorAxisPositions(axis));
            this.formComponents();
            ObjectIterator objectIterator = acc.getPartMap(TileAcceleratorIonSource.class).values().iterator();
            while (objectIterator.hasNext()) {
                TileAcceleratorIonSource source;
                this.source = source = (TileAcceleratorIonSource)objectIterator.next();
            }
            if (this.source != null) {
                this.source.setIONumber(2);
            }
            this.getMultiblock().tanks.get(2).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * 1000);
            this.getMultiblock().tanks.get(2).setAllowedFluids(QMDRecipes.accelerator_ion_source_valid_fluids.get(0));
            for (TileAcceleratorPort port : acc.getPartMap(TileAcceleratorPort.class).values()) {
                port.setSource(this);
            }
        }
        this.refreshStats();
        super.onAcceleratorFormed();
    }

    @Override
    public void onAcceleratorBroken() {
        if (this.source != null) {
            this.source.setIONumber(0);
        }
        this.source = null;
        super.onAcceleratorBroken();
    }

    @Override
    public boolean onUpdateServer() {
        super.onUpdateServer();
        if (this.getMultiblock().isControllorOn) {
            if (this.source != null) {
                if (this.recipeInfo != null) {
                    this.produceSourceBeam();
                } else {
                    this.resetOutputBeam();
                }
            } else {
                this.produceBeam();
            }
        } else {
            this.resetOutputBeam();
        }
        this.push();
        this.getMultiblock().sendMultiblockUpdatePacketToListeners();
        return true;
    }

    @Override
    protected void refreshBeams() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.getMultiblock().beams.get(1).setParticleStack(null);
        this.pull();
    }

    @Override
    protected boolean shouldUseEnergy() {
        if (this.source != null) {
            this.refreshRecipe();
            if (this.recipeInfo != null) {
                return true;
            }
        } else if (this.getMultiblock().beams.get(0).getParticleStack() != null) {
            return true;
        }
        return false;
    }

    private void resetOutputBeam() {
        this.getMultiblock().beams.get(1).setParticleStack(null);
    }

    private void produceSourceBeam() {
        IParticleIngredient particleProduct = this.recipeInfo.getRecipe().getParticleProducts().get(0);
        if (particleProduct.getStack() != null) {
            int outputAmount = ((ParticleStack)particleProduct.getStack()).getAmount() * this.source.outputParticleMultiplier;
            ParticleStack outputStack = (ParticleStack)particleProduct.getStack();
            outputStack.addFocus(this.source.outputFocus);
            this.getMultiblock().beams.get(1).setParticleStack(outputStack);
            ParticleStack beam = this.getMultiblock().beams.get(1).getParticleStack();
            if (this.getMultiblock().computerControlled) {
                beam.addMeanEnergy((long)((double)Equations.linacEnergyGain(this.getMultiblock().acceleratingVoltage, beam) * ((double)this.getMultiblock().energyPercentage / 100.0)));
            } else {
                beam.addMeanEnergy((long)((double)(Equations.linacEnergyGain(this.getMultiblock().acceleratingVoltage, beam) * (long)this.getRedstoneLevel()) / 15.0));
            }
            beam.addFocus(Equations.focusGain(this.getMultiblock().quadrupoleStrength, beam) - Equations.focusLoss(this.getBeamLength(), beam));
            if (beam.getFocus() <= 0.0) {
                this.getMultiblock().errorCode = 3;
            }
            if (!((ItemStack)this.source.getInventoryStacks().get(0)).func_190926_b()) {
                if (((ItemStack)this.source.getInventoryStacks().get(0)).func_77973_b() instanceof IItemParticleAmount) {
                    IItemParticleAmount item = (IItemParticleAmount)((ItemStack)this.source.getInventoryStacks().get(0)).func_77973_b();
                    if (item.getAmountStored((ItemStack)this.source.getInventoryStacks().get(0)) < outputAmount) {
                        outputAmount = item.getAmountStored((ItemStack)this.source.getInventoryStacks().get(0));
                    }
                    this.source.getInventoryStacks().set(0, (Object)item.use((ItemStack)this.source.getInventoryStacks().get(0), outputAmount));
                    if (item.isEmptyItem((ItemStack)this.source.getInventoryStacks().get(0)) && !((ItemStack)this.source.getInventoryStacks().get(1)).func_190926_b()) {
                        ItemStack stack = ((ItemStack)this.source.getInventoryStacks().get(1)).func_77946_l();
                        this.source.getInventoryStacks().set(1, (Object)((ItemStack)this.source.getInventoryStacks().get(0)).func_77946_l());
                        this.source.getInventoryStacks().set(0, (Object)stack);
                    }
                }
            } else if (!this.source.getTanks().get(0).isEmpty()) {
                FluidStack fluidStack = (FluidStack)this.recipeInfo.getRecipe().getFluidIngredients().get(0).getStack();
                Tank tank = this.source.getTanks().get(0);
                int mBtoDrain = fluidStack.amount * this.source.outputParticleMultiplier;
                FluidStack mBDrained = tank.drain(mBtoDrain, true);
                outputAmount *= mBDrained.amount / mBtoDrain;
            }
            outputStack.setAmount(outputAmount);
        }
    }

    private void produceBeam() {
        ParticleStack inputBeam = this.getMultiblock().beams.get(0).getParticleStack();
        if (inputBeam != null) {
            this.getMultiblock().beams.get(1).setParticleStack(inputBeam.copy());
            ParticleStack outputBeam = this.getMultiblock().beams.get(1).getParticleStack();
            if (outputBeam != null) {
                outputBeam.addFocus(Equations.focusGain(this.getMultiblock().quadrupoleStrength, outputBeam) - Equations.focusLoss(this.getBeamLength(), outputBeam));
                if (this.getMultiblock().computerControlled) {
                    outputBeam.addMeanEnergy((long)((double)Equations.linacEnergyGain(this.getMultiblock().acceleratingVoltage, outputBeam) * ((double)this.getMultiblock().energyPercentage / 100.0)));
                } else {
                    outputBeam.addMeanEnergy((long)((double)(Equations.linacEnergyGain(this.getMultiblock().acceleratingVoltage, outputBeam) * (long)this.getRedstoneLevel()) / 15.0));
                }
                if (outputBeam.getFocus() <= 0.0) {
                    outputBeam = null;
                    this.getMultiblock().errorCode = 3;
                }
            }
        }
    }

    protected void refreshRecipe() {
        if (((ItemStack)this.source.getInventoryStacks().get(0)).func_190926_b() && !((ItemStack)this.source.getInventoryStacks().get(1)).func_190926_b()) {
            ItemStack stack = ((ItemStack)this.source.getInventoryStacks().get(1)).func_77946_l();
            this.source.getInventoryStacks().set(1, (Object)ItemStack.field_190927_a);
            this.source.getInventoryStacks().set(0, (Object)stack);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack item = IItemParticleAmount.cleanNBT((ItemStack)this.source.getInventoryStacks().get(0));
        items.add(item);
        ArrayList<Tank> tanks = new ArrayList<Tank>();
        tanks.add(this.source.getTanks().get(0));
        this.recipeInfo = QMDRecipes.accelerator_source.getRecipeInfoFromInputs(items, tanks, new ArrayList<ParticleStack>());
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
    }

    @Override
    public AcceleratorUpdatePacket getMultiblockUpdatePacket() {
        return new LinearAcceleratorUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isControllorOn, this.getMultiblock().cooling, this.getMultiblock().rawHeating, this.getMultiblock().currentHeating, this.getMultiblock().maxCoolantIn, this.getMultiblock().maxCoolantOut, this.getMultiblock().maxOperatingTemp, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().acceleratingVoltage, this.getMultiblock().RFCavityNumber, this.getMultiblock().quadrupoleNumber, this.getMultiblock().quadrupoleStrength, this.getMultiblock().dipoleNumber, this.getMultiblock().dipoleStrength, this.getMultiblock().errorCode, this.getMultiblock().heatBuffer, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams);
    }

    @Override
    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof LinearAcceleratorUpdatePacket) {
            LinearAcceleratorUpdatePacket linearAcceleratorUpdatePacket = (LinearAcceleratorUpdatePacket)message;
        }
    }
}

