/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonCollector;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSynchrotronPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorYoke;
import lach_01298.qmd.accelerator.tile.TileMassSpectrometerController;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.multiblock.InventoryHelper;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.MassSpectrometerUpdatePacket;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.block.property.BlockProperties;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.ITile;
import nc.tile.internal.fluid.Tank;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MassSpectrometerLogic
extends AcceleratorLogic {
    public RecipeInfo<BasicRecipe> recipeInfo;
    public static final int diameter = 7;
    public double workDone = 0.0;
    public double recipeWork = 100.0;
    public double speed = 1.0;
    public static final List<Pair<Class<? extends IAcceleratorPart>, String>> PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileAcceleratorBeamPort.class, (Object)"qmd.multiblock_validation.accelerator.no_beam_ports"), Pair.of(TileAcceleratorSynchrotronPort.class, (Object)"qmd.multiblock_validation.accelerator.no_synch_ports"), Pair.of(TileAcceleratorRFCavity.class, (Object)"qmd.multiblock_validation.accelerator.no_rf_cavity")});

    public MassSpectrometerLogic(AcceleratorLogic oldLogic) {
        super(oldLogic);
        if (!(oldLogic instanceof MassSpectrometerLogic) && !oldLogic.getID().equals("")) {
            this.getMultiblock().tanks.get(2).setFluidStored(null);
            this.getMultiblock().tanks.get(3).setFluidStored(null);
            this.getMultiblock().tanks.get(4).setFluidStored(null);
            this.getMultiblock().tanks.get(5).setFluidStored(null);
            this.getMultiblock().tanks.get(6).setFluidStored(null);
        }
    }

    @Override
    public String getID() {
        return "mass_spectrometer";
    }

    @Override
    public int getBeamLength() {
        return 13;
    }

    @Override
    public double getBeamRadius() {
        return 2.5;
    }

    @Override
    public boolean isMachineWhole() {
        EnumFacing.Axis axis;
        Accelerator acc = this.getMultiblock();
        if (acc.getExteriorLengthY() != 7) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.wrong_height", null, new Object[0]);
            return false;
        }
        if (acc.getExteriorLengthX() != 7 && acc.getExteriorLengthZ() != 7) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.wrong_width", null, new Object[0]);
            return false;
        }
        int length = 5;
        if (acc.getExteriorLengthX() == acc.getExteriorLengthZ()) {
            axis = null;
        } else if (acc.getExteriorLengthX() == 7) {
            axis = EnumFacing.Axis.Z;
            length = acc.getInteriorLengthZ();
        } else {
            axis = EnumFacing.Axis.X;
            length = acc.getInteriorLengthX();
        }
        if (length % 2 == 0) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_odd_length", null, new Object[0]);
            return false;
        }
        int sourceAmount = length / 2;
        if (this.getPartMap(TileAcceleratorIonSource.class).size() != sourceAmount) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.need_ion_source_amount", null, new Object[]{sourceAmount});
            return false;
        }
        if (axis == null) {
            TileAcceleratorIonSource source = (TileAcceleratorIonSource)this.getPartMap(TileAcceleratorIonSource.class).values().iterator().next();
            ObjectIterator normal = this.getWallNormal(source.func_174877_v());
            if (normal == null) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_wrong_pos", source.func_174877_v(), new Object[0]);
                return false;
            }
            axis = normal.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        }
        boolean[] layerHasSource = new boolean[sourceAmount];
        Arrays.fill(layerHasSource, false);
        for (TileAcceleratorIonSource source : this.getPartMap(TileAcceleratorIonSource.class).values()) {
            int n;
            BlockPos sourcePos = source.func_174877_v();
            boolean validSource = false;
            for (String validSourceName : QMDConfig.mass_spectrometer_valid_sources) {
                if (!validSourceName.equals(source.name)) continue;
                validSource = true;
            }
            if (!validSource) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_wrong_type", sourcePos, new Object[0]);
                return false;
            }
            if (sourcePos.func_177956_o() != acc.getMinInteriorY()) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_wrong_pos", sourcePos, new Object[0]);
                return false;
            }
            if (this.getWallNormal(source.func_174877_v()) == null) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_wrong_pos", source.func_174877_v(), new Object[0]);
                return false;
            }
            if (acc.WORLD.func_180495_p(sourcePos).func_177229_b((IProperty)BlockProperties.FACING_ALL) != this.getWallNormal(sourcePos).func_176734_d()) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_wrong_facing", sourcePos, new Object[0]);
                return false;
            }
            int n2 = n = axis == EnumFacing.Axis.X ? sourcePos.func_177958_n() - acc.getMinInteriorX() : sourcePos.func_177952_p() - acc.getMinInteriorZ();
            if (n % 2 != 1 || n / 2 >= layerHasSource.length || n < 0) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_wrong_pos", sourcePos, new Object[0]);
                return false;
            }
            if (layerHasSource[n / 2]) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_source_in_layer_already", sourcePos, new Object[0]);
                return false;
            }
            layerHasSource[n / 2] = true;
            for (int i = 1; i <= 4; ++i) {
                if (!(acc.WORLD.func_175625_s(sourcePos.func_177981_b(i)) instanceof TileAcceleratorIonCollector)) {
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_ion_collector", sourcePos.func_177981_b(i), new Object[0]);
                    return false;
                }
                if (acc.WORLD.func_180495_p(sourcePos.func_177981_b(i)).func_177229_b((IProperty)BlockProperties.FACING_ALL) == this.getWallNormal(sourcePos).func_176734_d()) continue;
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.ion_collector_wrong_facing", sourcePos.func_177981_b(i), new Object[0]);
                return false;
            }
        }
        if (this.getPartMap(TileAcceleratorIonCollector.class).size() != sourceAmount * 4) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.need_ion_collector_amount", null, new Object[0]);
            return false;
        }
        Class<?> magnetType = null;
        for (int layerNumber = 0; layerNumber < length; ++layerNumber) {
            Iterable<BlockPos.MutableBlockPos> layer = acc.getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis), layerNumber, 0, 0, 0, 0);
            if (layerNumber % 2 == 0) {
                for (BlockPos blockPos : layer) {
                    boolean validMagnet;
                    TileAcceleratorMagnet magnet;
                    if (axis == EnumFacing.Axis.X) {
                        if (blockPos.func_177956_o() > acc.getMinInteriorY() && blockPos.func_177956_o() < acc.getMaxInteriorY() && blockPos.func_177952_p() > acc.getMinInteriorZ() && blockPos.func_177952_p() < acc.getMaxInteriorZ()) {
                            if (acc.WORLD.func_175625_s(blockPos) instanceof TileAcceleratorYoke) continue;
                            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_yoke", blockPos, new Object[0]);
                            return false;
                        }
                        if (!(acc.WORLD.func_175625_s(blockPos) instanceof TileAcceleratorMagnet)) {
                            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_magnet", blockPos, new Object[0]);
                            return false;
                        }
                        if (magnetType == null) {
                            magnet = (TileAcceleratorMagnet)acc.WORLD.func_175625_s(blockPos);
                            validMagnet = false;
                            for (String validSourceName : QMDConfig.mass_spectrometer_valid_magnets) {
                                if (!validSourceName.equals(magnet.name)) continue;
                                validMagnet = true;
                                break;
                            }
                            if (!validMagnet) {
                                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.magnet_wrong_type", blockPos, new Object[0]);
                                return false;
                            }
                            magnetType = acc.WORLD.func_175625_s(blockPos).getClass();
                            continue;
                        }
                        if (magnetType.isInstance(acc.WORLD.func_175625_s(blockPos))) continue;
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_one_magnet_type", blockPos, new Object[0]);
                        return false;
                    }
                    if (blockPos.func_177956_o() > acc.getMinInteriorY() && blockPos.func_177956_o() < acc.getMaxInteriorY() && blockPos.func_177958_n() > acc.getMinInteriorX() && blockPos.func_177958_n() < acc.getMaxInteriorX()) {
                        if (acc.WORLD.func_175625_s(blockPos) instanceof TileAcceleratorYoke) continue;
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_yoke", blockPos, new Object[0]);
                        return false;
                    }
                    if (!(acc.WORLD.func_175625_s(blockPos) instanceof TileAcceleratorMagnet)) {
                        ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_magnet", blockPos, new Object[0]);
                        return false;
                    }
                    if (magnetType == null) {
                        magnet = (TileAcceleratorMagnet)acc.WORLD.func_175625_s(blockPos);
                        validMagnet = false;
                        for (String validSourceName : QMDConfig.mass_spectrometer_valid_magnets) {
                            if (!validSourceName.equals(magnet.name)) continue;
                            validMagnet = true;
                            break;
                        }
                        if (!validMagnet) {
                            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.magnet_wrong_type", blockPos, new Object[0]);
                            return false;
                        }
                        magnetType = acc.WORLD.func_175625_s(blockPos).getClass();
                        continue;
                    }
                    if (magnetType.isInstance(acc.WORLD.func_175625_s(blockPos))) continue;
                    ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_one_magnet_type", blockPos, new Object[0]);
                    return false;
                }
                continue;
            }
            for (BlockPos blockPos : layer) {
                if (acc.WORLD.func_175625_s(blockPos) instanceof TileAcceleratorBeam) continue;
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.mass_spectrometer.must_be_beam", blockPos, new Object[0]);
                return false;
            }
        }
        return super.isMachineWhole();
    }

    public EnumFacing getWallNormal(BlockPos pos) {
        Accelerator acc = this.getMultiblock();
        if (pos.func_177956_o() == acc.getMaxY()) {
            return EnumFacing.UP;
        }
        if (pos.func_177956_o() == acc.getMinY()) {
            return EnumFacing.DOWN;
        }
        if (pos.func_177958_n() == acc.getMinX()) {
            return EnumFacing.WEST;
        }
        if (pos.func_177958_n() == acc.getMaxX()) {
            return EnumFacing.EAST;
        }
        if (pos.func_177952_p() == acc.getMaxZ()) {
            return EnumFacing.SOUTH;
        }
        if (pos.func_177952_p() == acc.getMinZ()) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    @Override
    public int getThickness() {
        return -1;
    }

    @Override
    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }

    @Override
    public void onAcceleratorFormed() {
        Accelerator acc = this.getMultiblock();
        acc.tanks.get(2).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * 1000);
        acc.tanks.get(2).setAllowedFluids(QMDRecipes.mass_spectrometer_valid_fluids.get(0));
        acc.tanks.get(3).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * 1000);
        acc.tanks.get(4).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * 1000);
        acc.tanks.get(5).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * 1000);
        acc.tanks.get(6).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * 1000);
        if (!this.getWorld().field_72995_K) {
            this.resetBeams();
            this.speed = 0.0;
            for (TileAcceleratorIonSource source : this.getPartMap(TileAcceleratorIonSource.class).values()) {
                BlockPos sourcePos = source.func_174877_v();
                source.setIONumber(2);
                this.speed += (double)source.outputParticleMultiplier / 2.0;
                for (int i = 1; i <= 4; ++i) {
                    if (!(acc.WORLD.func_175625_s(sourcePos.func_177981_b(i)) instanceof TileAcceleratorIonCollector)) continue;
                    TileAcceleratorIonCollector collector = (TileAcceleratorIonCollector)((Accelerator)this.multiblock).WORLD.func_175625_s(sourcePos.func_177981_b(i));
                    collector.setIONumber(i + 2);
                }
            }
        }
        this.refreshStats();
        super.onAcceleratorFormed();
        acc.cooling = 2L * (acc.rawHeating + acc.getMaxExternalHeating());
    }

    @Override
    public void refreshStats() {
        Accelerator acc = this.getMultiblock();
        int energy = 0;
        long heat = 0L;
        for (TileAcceleratorMagnet magnet : this.getMultiblock().getPartMap(TileAcceleratorMagnet.class).values()) {
            energy += magnet.basePower / 16;
            heat += (long)(magnet.heat / 16);
        }
        for (TileAcceleratorIonSource source : this.getMultiblock().getPartMap(TileAcceleratorIonSource.class).values()) {
            energy += source.basePower;
        }
        acc.requiredEnergy = energy;
        acc.rawHeating = heat;
        acc.dipoleStrength = 0.0;
        acc.quadrupoleStrength = 0.0;
        acc.efficiency = 1.0;
        acc.acceleratingVoltage = 0;
    }

    @Override
    public void onAcceleratorBroken() {
        for (TileAcceleratorIonSource source : this.getPartMap(TileAcceleratorIonSource.class).values()) {
            source.setIONumber(0);
        }
        for (TileAcceleratorIonCollector collector : this.getPartMap(TileAcceleratorIonCollector.class).values()) {
            collector.setIONumber(0);
        }
        super.onAcceleratorBroken();
    }

    @Override
    public boolean onUpdateServer() {
        super.onUpdateServer();
        if (this.getMultiblock().isControllorOn) {
            this.refreshRecipe();
            if (this.recipeInfo != null) {
                if (this.canProduceProduct() && this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
                    this.internalHeating();
                    this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
                    this.workDone += this.speed;
                    this.produceProduct();
                }
            } else {
                this.workDone = 0.0;
            }
        } else {
            this.workDone = 0.0;
        }
        this.getMultiblock().sendMultiblockUpdatePacketToListeners();
        return true;
    }

    @Override
    protected void operate() {
        if (this.isRedstonePowered() && !this.getMultiblock().computerControlled || this.getMultiblock().computerControlled && this.getMultiblock().energyPercentage > 0) {
            if (this.getMultiblock().getTemperature() <= this.getMultiblock().maxOperatingTemp) {
                this.operational = true;
                return;
            }
            if (this.operational) {
                this.quenchMagnets();
            }
            this.operational = false;
            this.getMultiblock().errorCode = 1;
            return;
        }
        this.operational = false;
    }

    private boolean canProduceProduct() {
        ItemStack stack;
        int i;
        TileMassSpectrometerController inv = (TileMassSpectrometerController)this.getMultiblock().controller;
        List productItems = ((BasicRecipe)this.recipeInfo.getRecipe()).getItemProducts();
        List productFluids = ((BasicRecipe)this.recipeInfo.getRecipe()).getFluidProducts();
        for (i = 0; i < productItems.size(); ++i) {
            stack = (ItemStack)((IItemIngredient)productItems.get(i)).getStack();
            if (stack == null) continue;
            if (((ItemStack)inv.getInventoryStacks().get(i + 2)).func_190916_E() <= 0) {
                inv.getInventoryStacks().set(i + 2, (Object)ItemStack.field_190927_a);
            }
            if (!((ItemStack)inv.getInventoryStacks().get(i + 2)).func_77969_a(stack) && inv.getInventoryStacks().get(i + 2) != ItemStack.field_190927_a) {
                return false;
            }
            if (((ItemStack)inv.getInventoryStacks().get(i + 2)).func_190916_E() + stack.func_190916_E() <= stack.func_77976_d()) continue;
            return false;
        }
        for (i = 0; i < productFluids.size(); ++i) {
            stack = (FluidStack)((IFluidIngredient)productFluids.get(i)).getStack();
            if (stack == null || this.getMultiblock().tanks.get(i + 3).fill((FluidStack)stack, false) == stack.amount) continue;
            return false;
        }
        return true;
    }

    private void produceProduct() {
        this.recipeWork = ((BasicRecipe)this.recipeInfo.getRecipe()).getBaseProcessTime((double)QMDConfig.processor_time[2]);
        while (this.workDone >= this.recipeWork && this.canProduceProduct()) {
            TileMassSpectrometerController inv = (TileMassSpectrometerController)this.getMultiblock().controller;
            List productItems = ((BasicRecipe)this.recipeInfo.getRecipe()).getItemProducts();
            for (int i = 0; i < productItems.size(); ++i) {
                ItemStack productItem = (ItemStack)((IItemIngredient)productItems.get(i)).getStack();
                if (productItem == null) {
                    productItem = ItemStack.field_190927_a;
                } else {
                    productItem.func_190920_e(((IItemIngredient)productItems.get(i)).getNextStackSize(0));
                }
                InventoryHelper.addItem(i + 2, productItem, inv.getInventoryStacks(), (ITile)inv);
            }
            InventoryHelper.removeItem(0, ((IItemIngredient)((BasicRecipe)this.recipeInfo.getRecipe()).getItemIngredients().get(0)).getMaxStackSize(0), inv.getInventoryStacks(), (ITile)inv);
            List productFluids = ((BasicRecipe)this.recipeInfo.getRecipe()).getFluidProducts();
            for (int i = 0; i < productFluids.size(); ++i) {
                FluidStack productFluid = (FluidStack)((IFluidIngredient)productFluids.get(i)).getStack();
                if (productFluid == null) continue;
                productFluid.amount = ((IFluidIngredient)productFluids.get(i)).getNextStackSize(0);
                this.getMultiblock().tanks.get(i + 3).fill(productFluid, true);
            }
            FluidStack ingredientFluid = (FluidStack)((IFluidIngredient)((BasicRecipe)this.recipeInfo.getRecipe()).getFluidIngredients().get(0)).getStack();
            if (ingredientFluid != null) {
                this.getMultiblock().tanks.get(2).drain(ingredientFluid, true);
            }
            this.workDone = Math.max(0.0, this.workDone - this.recipeWork);
        }
    }

    protected void refreshRecipe() {
        TileMassSpectrometerController cont = (TileMassSpectrometerController)this.getMultiblock().controller;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack item = ((ItemStack)cont.getInventoryStacks().get(0)).func_77946_l();
        items.add(item);
        ArrayList<Tank> tanks = new ArrayList<Tank>();
        tanks.add(this.getMultiblock().tanks.get(2));
        this.recipeInfo = QMDRecipes.mass_spectrometer.getRecipeInfoFromInputs(items, tanks);
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        logicTag.func_74780_a("workDone", this.workDone);
        logicTag.func_74780_a("recipeWork", this.recipeWork);
        logicTag.func_74780_a("speed", this.speed);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.workDone = logicTag.func_74769_h("workDone");
        this.recipeWork = logicTag.func_74769_h("recipeWork");
        this.speed = logicTag.func_74769_h("speed");
    }

    @Override
    public AcceleratorUpdatePacket getMultiblockUpdatePacket() {
        return new MassSpectrometerUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isControllorOn, this.getMultiblock().cooling, this.getMultiblock().rawHeating, this.getMultiblock().currentHeating, this.getMultiblock().maxCoolantIn, this.getMultiblock().maxCoolantOut, this.getMultiblock().maxOperatingTemp, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().acceleratingVoltage, this.getMultiblock().RFCavityNumber, this.getMultiblock().quadrupoleNumber, this.getMultiblock().quadrupoleStrength, this.getMultiblock().dipoleNumber, this.getMultiblock().dipoleStrength, this.getMultiblock().errorCode, this.getMultiblock().heatBuffer, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams, this.workDone, this.recipeWork, this.speed);
    }

    @Override
    public void onMultiblockUpdatePacket(AcceleratorUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof MassSpectrometerUpdatePacket) {
            MassSpectrometerUpdatePacket packet = (MassSpectrometerUpdatePacket)message;
            this.workDone = packet.workDone;
            this.recipeWork = packet.recipeWork;
            this.speed = packet.speed;
        }
    }
}

