/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.MassSpectrometerLogic;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileMassSpectrometerController;
import lach_01298.qmd.util.InventoryStackList;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.passive.ITilePassive;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAcceleratorIonCollector
extends TileAcceleratorPart
implements ITileInventory,
ITileFluid,
ITickable {
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private TileMassSpectrometerController controller;
    @Nonnull
    private final String inventoryName = "qmd.container.ion_collector";
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll((List)Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.OUT}));
    @Nonnull
    private final List<Tank> backupTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1, new ArrayList())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll((List)Lists.newArrayList((Object[])new TankSorption[]{TankSorption.OUT}));
    @Nonnull
    private FluidTileWrapper[] fluidSides = ITileFluid.getDefaultFluidSides((ITileFluid)this);
    private int IONumber = 0;

    public TileAcceleratorIonCollector() {
        super(CuboidalPartPositionType.WALL);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onMachineAssembled(Accelerator accelerator) {
        if (accelerator.controller instanceof TileMassSpectrometerController) {
            this.controller = (TileMassSpectrometerController)accelerator.controller;
        }
        super.onMachineAssembled(accelerator);
    }

    @Override
    public void onMachineBroken() {
        this.controller = null;
        super.onMachineBroken();
    }

    public void func_73660_a() {
        EnumFacing facing = this.getPartPosition().getFacing();
        if (!this.field_145850_b.field_72995_K && !this.getTanks().get(0).isEmpty() && facing != null && this.getTankSorption(facing, 0).canDrain()) {
            this.pushFluidToSide(facing);
        }
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        if (this.controller != null && this.IONumber != 0 && this.getLogic() instanceof MassSpectrometerLogic) {
            return new InventoryStackList(this.controller.getInventoryStacks().subList(this.IONumber - 1, this.IONumber));
        }
        return this.inventoryStacks;
    }

    public String func_70005_c_() {
        return "qmd.container.ion_collector";
    }

    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    @Nonnull
    public List<Tank> getTanks() {
        if (this.getMultiblock() != null && this.IONumber != 0 && this.getLogic() instanceof MassSpectrometerLogic) {
            return ((Accelerator)this.getMultiblock()).isAssembled() ? ((Accelerator)this.getMultiblock()).tanks.subList(this.IONumber, this.IONumber + 1) : this.backupTanks;
        }
        return this.backupTanks;
    }

    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    public GasTileWrapper getGasWrapper() {
        return null;
    }

    public void pushFluidToSide(@Nonnull EnumFacing side) {
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof TileAcceleratorIonCollector || tile instanceof TileAcceleratorIonSource) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) continue;
            this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
        }
    }

    public boolean getInputTanksSeparated() {
        return false;
    }

    public void setInputTanksSeparated(boolean separated) {
    }

    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        this.writeTankSettings(nbt);
        nbt.func_74768_a("IONumber", this.IONumber);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.readTankSettings(nbt);
        this.IONumber = nbt.func_74762_e("IONumber");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public void setIONumber(int number) {
        if (number >= 0 && number <= 6) {
            this.IONumber = number;
        }
    }

    public int getIONumber() {
        return this.IONumber;
    }
}

