/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.MassSpectrometerLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileLinearAcceleratorController;
import lach_01298.qmd.accelerator.tile.TileMassSpectrometerController;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.multiblock.network.AcceleratorSourceUpdatePacket;
import lach_01298.qmd.network.QMDPacketHandler;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.tile.ITileIONumber;
import lach_01298.qmd.util.InventoryStackList;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.ITileGui;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.Lang;
import nc.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAcceleratorIonSource
extends TileAcceleratorPart
implements ITileInventory,
ITileFluid,
ITileIONumber,
ITileGui<AcceleratorSourceUpdatePacket>,
ITickable {
    private IAcceleratorController controller;
    @Nonnull
    private final String inventoryName = "qmd.container.accelerator_source";
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(Arrays.asList(ItemSorption.NON, ItemSorption.NON));
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    private final List<Tank> backupTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(QMDConfig.accelerator_base_input_tank_capacity * 1000, new ArrayList())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll((List)Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON}));
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    protected Set<EntityPlayer> playersToUpdate;
    public final int outputParticleMultiplier;
    public final double outputFocus;
    public final int basePower;
    public final String name;
    private int IONumber;

    public TileAcceleratorIonSource(int outputParticleMultipler, double outputFocus, int basePower, String name) {
        super(CuboidalPartPositionType.WALL);
        this.outputParticleMultiplier = outputParticleMultipler < 1 ? 1 : outputParticleMultipler;
        this.outputFocus = outputFocus;
        this.basePower = basePower;
        this.name = name;
        this.fluidSides = ITileFluid.getDefaultFluidSides((ITileFluid)this);
        this.IONumber = 0;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    @Override
    public void onMachineAssembled(Accelerator accelerator) {
        if (accelerator.controller instanceof TileMassSpectrometerController) {
            this.controller = (TileMassSpectrometerController)accelerator.controller;
            for (int i = 0; i < 6; ++i) {
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.IN);
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.NON);
                this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.IN);
            }
        } else if (accelerator.controller instanceof TileLinearAcceleratorController) {
            this.controller = (TileLinearAcceleratorController)accelerator.controller;
            for (int i = 0; i < 6; ++i) {
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.BOTH);
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.BOTH);
                this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.IN);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.NON);
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.NON);
                this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.NON);
            }
        }
        super.onMachineAssembled(accelerator);
    }

    @Override
    public void onMachineBroken() {
        this.controller = null;
        for (int i = 0; i < 6; ++i) {
            this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.NON);
            this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.NON);
            this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.NON);
        }
        super.onMachineBroken();
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        if (this.controller != null && this.IONumber != 0 && this.getLogic() instanceof MassSpectrometerLogic && this.controller instanceof TileMassSpectrometerController) {
            TileMassSpectrometerController massSpec = (TileMassSpectrometerController)this.controller;
            return new InventoryStackList(massSpec.getInventoryStacks().subList(0, 2));
        }
        return this.inventoryStacks;
    }

    public String func_70005_c_() {
        return Lang.localise((String)"gui.qmd.container.accelerator_source");
    }

    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public int func_70297_j_() {
        if (this.controller instanceof TileMassSpectrometerController) {
            return 64;
        }
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.controller instanceof TileMassSpectrometerController) {
            return QMDRecipes.mass_spectrometer.isValidItemInput(stack);
        }
        return QMDRecipes.accelerator_source.isValidItemInput(IItemParticleAmount.cleanNBT(stack));
    }

    @Nonnull
    public List<Tank> getTanks() {
        if (this.getMultiblock() != null && this.IONumber != 0) {
            return ((Accelerator)this.getMultiblock()).isAssembled() ? ((Accelerator)this.getMultiblock()).tanks.subList(this.IONumber, this.IONumber + 1) : this.backupTanks;
        }
        return this.backupTanks;
    }

    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    public GasTileWrapper getGasWrapper() {
        return null;
    }

    public boolean getInputTanksSeparated() {
        return false;
    }

    public void setInputTanksSeparated(boolean separated) {
    }

    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        this.writeTankSettings(nbt);
        nbt.func_74768_a("IONumber", this.IONumber);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.readTankSettings(nbt);
        this.IONumber = nbt.func_74762_e("IONumber");
    }

    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
        return nbt;
    }

    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public int getGuiID() {
        return 3;
    }

    public Set<EntityPlayer> getTileUpdatePacketListeners() {
        return this.playersToUpdate;
    }

    public AcceleratorSourceUpdatePacket getTileUpdatePacket() {
        return new AcceleratorSourceUpdatePacket(this.field_174879_c, this.getTanks());
    }

    public void onTileUpdatePacket(AcceleratorSourceUpdatePacket message) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendTileUpdatePacketToListeners();
        }
    }

    @Override
    public void setIONumber(int number) {
        if (number >= 0 && number <= 2) {
            this.IONumber = number;
        }
    }

    @Override
    public int getIONumber() {
        return this.IONumber;
    }

    public void sendTileUpdatePacketToListeners() {
        for (EntityPlayer player : this.getTileUpdatePacketListeners()) {
            QMDPacketHandler.instance.sendTo((IMessage)this.getTileUpdatePacket(), (EntityPlayerMP)player);
        }
    }

    public void sendTileUpdatePacketToPlayer(EntityPlayer player) {
        if (this.getTileWorld().field_72995_K) {
            return;
        }
        QMDPacketHandler.instance.sendTo((IMessage)this.getTileUpdatePacket(), (EntityPlayerMP)player);
    }

    public void sendTileUpdatePacketToAll() {
        QMDPacketHandler.instance.sendToAll((IMessage)this.getTileUpdatePacket());
    }

    public static class Laser
    extends TileAcceleratorIonSource {
        public Laser() {
            super(QMDConfig.ion_source_output_multiplier[1], QMDConfig.ion_source_focus[1], QMDConfig.ion_source_power[1], "laser");
        }
    }

    public static class Basic
    extends TileAcceleratorIonSource {
        public Basic() {
            super(QMDConfig.ion_source_output_multiplier[0], QMDConfig.ion_source_focus[0], QMDConfig.ion_source_power[0], "basic");
        }
    }
}

