/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.LinearAcceleratorLogic;
import lach_01298.qmd.accelerator.MassSpectrometerLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.TileAcceleratorIonSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileLinearAcceleratorController;
import lach_01298.qmd.accelerator.tile.TileMassSpectrometerController;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.util.InventoryStackList;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileAcceleratorPort
extends TileAcceleratorPart
implements ITileInventory,
ITileFluid {
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private TileAcceleratorIonSource source;
    private IAcceleratorController controller;
    @Nonnull
    private final List<Tank> backupTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(QMDConfig.accelerator_base_input_tank_capacity * 1000, new ArrayList())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll((List)Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON}));
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private final String inventoryName = "qmd.container.accelerator_port";
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll((List)Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.NON, ItemSorption.NON}));

    public TileAcceleratorPort() {
        super(CuboidalPartPositionType.WALL);
        this.fluidSides = ITileFluid.getDefaultFluidSides((ITileFluid)this);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onMachineAssembled(Accelerator accelerator) {
        if (accelerator.controller instanceof TileMassSpectrometerController) {
            this.controller = (TileMassSpectrometerController)accelerator.controller;
            for (int i = 0; i < 6; ++i) {
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.IN);
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.NON);
                this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.IN);
            }
        } else if (accelerator.controller instanceof TileLinearAcceleratorController) {
            this.controller = (TileLinearAcceleratorController)accelerator.controller;
            for (int i = 0; i < 6; ++i) {
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.BOTH);
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.BOTH);
                this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.IN);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.NON);
                this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.NON);
                this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.NON);
            }
        }
        super.onMachineAssembled(accelerator);
    }

    public void setSource(LinearAcceleratorLogic logic) {
        this.source = logic.getSource();
    }

    @Override
    public void onMachineBroken() {
        this.controller = null;
        this.source = null;
        for (int i = 0; i < 6; ++i) {
            this.setItemSorption(EnumFacing.func_82600_a((int)i), 0, ItemSorption.NON);
            this.setItemSorption(EnumFacing.func_82600_a((int)i), 1, ItemSorption.NON);
            this.setTankSorption(EnumFacing.func_82600_a((int)i), 0, TankSorption.NON);
        }
        super.onMachineBroken();
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        if (this.controller != null && this.getLogic() instanceof MassSpectrometerLogic && this.controller instanceof TileMassSpectrometerController) {
            TileMassSpectrometerController massSpec = (TileMassSpectrometerController)this.controller;
            return new InventoryStackList(massSpec.getInventoryStacks().subList(0, 2));
        }
        return this.source == null ? this.inventoryStacks : this.source.getInventoryStacks();
    }

    public String func_70005_c_() {
        return "qmd.container.accelerator_port";
    }

    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public int func_70297_j_() {
        if (this.controller instanceof TileMassSpectrometerController) {
            return 64;
        }
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.controller instanceof TileMassSpectrometerController) {
            return QMDRecipes.mass_spectrometer.isValidItemInput(stack);
        }
        return QMDRecipes.accelerator_source.isValidItemInput(IItemParticleAmount.cleanNBT(stack));
    }

    @Nonnull
    public List<Tank> getTanks() {
        if (this.getMultiblock() != null) {
            return ((Accelerator)this.getMultiblock()).isAssembled() ? ((Accelerator)this.getMultiblock()).tanks.subList(2, 3) : this.backupTanks;
        }
        return this.backupTanks;
    }

    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    public GasTileWrapper getGasWrapper() {
        return null;
    }

    public boolean getInputTanksSeparated() {
        return false;
    }

    public void setInputTanksSeparated(boolean separated) {
    }

    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        this.writeTankSettings(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.readTankSettings(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }
}

