/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.multiblock.container.ContainerLinearAcceleratorController;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.block.property.BlockProperties;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.Lang;
import nc.util.NBTHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileLinearAcceleratorController
extends TileAcceleratorPart
implements IAcceleratorController<TileLinearAcceleratorController>,
ITileInventory {
    @Nonnull
    private final String inventoryName = "qmd.container.linear_accelerator_controller";
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(Arrays.asList(ItemSorption.BOTH, ItemSorption.BOTH));
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);

    public TileLinearAcceleratorController() {
        super(CuboidalPartPositionType.WALL);
    }

    public String getLogicID() {
        return "linear_accelerator";
    }

    @Override
    public void onMachineAssembled(Accelerator controller) {
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    public String func_70005_c_() {
        return Lang.localise((String)"gui.qmd.container.linear_accelerator_controller");
    }

    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        if (this.getMultiblock() != null) {
            ((Accelerator)this.getMultiblock()).updateActivity();
        }
    }

    public ContainerMultiblockController getContainer(EntityPlayer player) {
        return new ContainerLinearAcceleratorController(player, this);
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
    }

    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
        return nbt;
    }

    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return QMDRecipes.accelerator_source.isValidItemInput(IItemParticleAmount.cleanNBT(stack));
    }
}

