/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.List;
import lach_01298.qmd.crafttweaker.AddQMDRecipe;
import lach_01298.qmd.crafttweaker.CTAddAntiParticle;
import lach_01298.qmd.crafttweaker.CTAddComponentParticle;
import lach_01298.qmd.crafttweaker.CTAddParticle;
import lach_01298.qmd.crafttweaker.CTSetEmptyItemSource;
import lach_01298.qmd.crafttweaker.RemoveAllQMDRecipes;
import lach_01298.qmd.crafttweaker.RemoveQMDRecipe;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.integration.crafttweaker.CTAddRecipe;
import nc.integration.crafttweaker.CTClearRecipes;
import nc.integration.crafttweaker.CTRemoveRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.IngredientSorption;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class QMDCraftTweaker {

    @ZenClass(value="mods.qmd.mass_spectrometer")
    @ZenRegister
    public static class MassSpectrometerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputItem, IIngredient inputFluid, IIngredient outputItem1, IIngredient outputItem2, IIngredient outputItem3, IIngredient outputItem4, IIngredient outputFluid1, IIngredient outputFluid2, IIngredient outputFluid3, IIngredient outputFluid4, @Optional(valueDouble=1.0) double timeMultiplier) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.mass_spectrometer, (List)Lists.newArrayList((Object[])new Object[]{inputItem, inputFluid, outputItem1, outputItem2, outputItem3, outputItem4, outputFluid1, outputFluid2, outputFluid3, outputFluid4, timeMultiplier})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputItem, IIngredient inputFluid) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.mass_spectrometer, IngredientSorption.INPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{inputItem, inputFluid})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient outputItem1, IIngredient outputItem2, IIngredient outputItem3, IIngredient outputItem4, IIngredient outputFluid1, IIngredient outputFluid2, IIngredient outputFluid3, IIngredient outputFluid4) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.mass_spectrometer, IngredientSorption.OUTPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{outputItem1, outputItem2, outputItem3, outputItem4, outputFluid1, outputFluid2, outputFluid3, outputFluid4})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes((BasicRecipeHandler)QMDRecipes.mass_spectrometer));
        }
    }

    @ZenClass(value="mods.qmd.containment_chamber_cell_filling")
    @ZenRegister
    public static class ContainmentChamberCellFillingHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputFluid, IIngredient inputFullCell) {
            ItemStack fullCellStack;
            if (inputFullCell instanceof IItemStack && ((IItemStack)inputFullCell).getInternal() instanceof ItemStack && (fullCellStack = (ItemStack)inputFullCell.getInternal()).func_77973_b() instanceof IItemParticleAmount) {
                IItemParticleAmount fullCell = (IItemParticleAmount)fullCellStack.func_77973_b();
                if (!fullCell.getEmptyItem().equals(ItemStack.field_190927_a)) {
                    IItemStack emptyCell = CraftTweakerAPI.itemUtils.getItem(fullCell.getEmptyItem().func_77973_b().getRegistryName().toString(), fullCell.getEmptyItem().func_77960_j());
                    CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.cell_filling, (List)Lists.newArrayList((Object[])new Object[]{emptyCell, inputFluid, inputFullCell, null})));
                    CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.cell_filling, (List)Lists.newArrayList((Object[])new Object[]{inputFullCell, null, emptyCell, inputFluid})));
                    return;
                }
                CraftTweakerAPI.logError((String)(inputFullCell.toString() + " does not have a registed empty item. Can not add cell_filling recipe."));
                return;
            }
            CraftTweakerAPI.logError((String)(inputFullCell.toString() + " is not an instance of IItemParticleAmount. Can not add cell_filling recipe."));
        }
    }

    @ZenClass(value="mods.qmd.containment_chamber")
    @ZenRegister
    public static class ContainmentChamberHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputParticle1, IIngredient inputParticle2, IIngredient outputFluid, @Optional(valueLong=0x7FFFFFFFFFFFFFFFL) long maxEnergy) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.neutral_containment, Lists.newArrayList((Object[])new Object[]{inputParticle1, inputParticle2, outputFluid, maxEnergy})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputParticle1, IIngredient inputParticle2) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.neutral_containment, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputParticle1, inputParticle2})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.neutral_containment));
        }
    }

    @ZenClass(value="mods.qmd.accelerator_source")
    @ZenRegister
    public static class AcceleratorSourceHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient outputParticle) {
            if (input instanceof IItemStack) {
                if (((IItemStack)input).getInternal() instanceof ItemStack) {
                    ItemStack stack = (ItemStack)input.getInternal();
                    if (stack.func_77973_b() instanceof IItemParticleAmount) {
                        CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.accelerator_source, Lists.newArrayList((Object[])new IIngredient[]{input, null, outputParticle})));
                    } else {
                        CraftTweakerAPI.logError((String)(input.toString() + " is not an instance of IItemParticleAmount. Can not add accelerator_source recipe."));
                    }
                }
            } else if (input instanceof ILiquidStack) {
                CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.accelerator_source, Lists.newArrayList((Object[])new IIngredient[]{null, input, outputParticle})));
            }
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            if (input instanceof IItemStack) {
                CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.accelerator_source, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input, null})));
            } else if (input instanceof ILiquidStack) {
                CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.accelerator_source, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{null, input})));
            }
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.accelerator_source));
        }
    }

    @ZenClass(value="mods.qmd.item_source")
    @ZenRegister
    public static class ItemSourceHandler {
        @ZenMethod
        public static void setEmptyItem(IIngredient itemSource, IIngredient itemEmpty) {
            CraftTweakerAPI.apply((IAction)new CTSetEmptyItemSource(itemSource, itemEmpty));
        }
    }

    @ZenClass(value="mods.qmd.nucleosynthesis_chamber_heater")
    @ZenRegister
    public static class NucleosynthesisChamberHeaterHandler {
        @ZenMethod
        public static void addRecipe(IIngredient fluidInput, IIngredient fluidOutput, int heatRemoved) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.vacuum_chamber_heating, (List)Lists.newArrayList((Object[])new Object[]{fluidInput, fluidOutput, heatRemoved})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient fluidInput) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.vacuum_chamber_heating, IngredientSorption.INPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{fluidInput})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient fluidOutput) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.vacuum_chamber_heating, IngredientSorption.OUTPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{fluidOutput})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes((BasicRecipeHandler)QMDRecipes.vacuum_chamber_heating));
        }
    }

    @ZenClass(value="mods.qmd.nucleosynthesis_chamber")
    @ZenRegister
    public static class NucleosynthesisChamberHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputFluid1, IIngredient inputFluid2, IIngredient inputParticle, IIngredient outputFluid1, IIngredient outputFluid2, @Optional(valueLong=0x7FFFFFFFFFFFFFFFL) long maxEnergy, @Optional(valueLong=0L) long heatRelased) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.nucleosynthesis_chamber, Lists.newArrayList((Object[])new Object[]{inputFluid1, inputFluid2, inputParticle, outputFluid1, outputFluid2, maxEnergy, heatRelased})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputFluid1, IIngredient inputFluid2, IIngredient inputParticle) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.nucleosynthesis_chamber, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputFluid1, inputFluid2, inputParticle})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.nucleosynthesis_chamber));
        }
    }

    @ZenClass(value="mods.qmd.particle")
    @ZenRegister
    public static class ParticleHandler {
        @ZenMethod
        public static void addParticle(String name, String textureLocation, double mass, double charge, double spin, @Optional(valueBoolean=false) boolean weakCharged, @Optional(valueBoolean=false) boolean coloured) {
            CraftTweakerAPI.apply((IAction)new CTAddParticle(name, textureLocation, mass, charge, spin, weakCharged, coloured));
        }

        @ZenMethod
        public static void addAntiParticle(IIngredient particle, IIngredient antiParticle) {
            CraftTweakerAPI.apply((IAction)new CTAddAntiParticle(particle, antiParticle));
        }

        @ZenMethod
        public static void addComponentParticle(IIngredient parentParticle, IIngredient particle) {
            CraftTweakerAPI.apply((IAction)new CTAddComponentParticle(parentParticle, particle));
        }
    }

    @ZenClass(value="mods.qmd.beam_dump")
    @ZenRegister
    public static class BeamDumpHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputParticle, IIngredient outputFluid, @Optional(valueLong=0x7FFFFFFFFFFFFFFFL) long maxEnergy) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.beam_dump, Lists.newArrayList((Object[])new Object[]{inputParticle, outputFluid, maxEnergy})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputParticle) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.beam_dump, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputParticle})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.beam_dump));
        }
    }

    @ZenClass(value="mods.qmd.collision_chamber")
    @ZenRegister
    public static class CollisionChamberHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputParticle1, IIngredient inputParticle2, IIngredient outputParticle1, IIngredient outputParticle2, IIngredient outputParticle3, IIngredient outputParticle4, long maxEnergy, double crossSection, @Optional(valueLong=0L) long energyReleased) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.collision_chamber, Lists.newArrayList((Object[])new Object[]{inputParticle1, inputParticle2, outputParticle1, outputParticle2, outputParticle3, outputParticle4, maxEnergy, crossSection, energyReleased})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputParticle1, IIngredient inputParticle2) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.collision_chamber, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputParticle1, inputParticle2})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.collision_chamber));
        }
    }

    @ZenClass(value="mods.qmd.decay_chamber")
    @ZenRegister
    public static class DecayChamberHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputParticle, IIngredient outputParticle1, IIngredient outputParticle2, IIngredient outputParticle3, double crossSection, @Optional(valueLong=0L) long energyReleased, @Optional(valueLong=0x7FFFFFFFFFFFFFFFL) long maxEnergy) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.decay_chamber, Lists.newArrayList((Object[])new Object[]{inputParticle, outputParticle1, outputParticle2, outputParticle3, maxEnergy, crossSection, energyReleased})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputParticle) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.decay_chamber, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputParticle})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.decay_chamber));
        }
    }

    @ZenClass(value="mods.qmd.target_chamber")
    @ZenRegister
    public static class TargetChamberHandler {
        @ZenMethod
        public static void addRecipe(IIngredient inputItem, IIngredient inputFluid, IIngredient inputParticle, IIngredient outputItem, IIngredient outputFluid, IIngredient outputParticle1, IIngredient outputParticle2, IIngredient outputParticle3, long maxEnergy, double crossSection, @Optional(valueLong=0L) long energyReleased) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.target_chamber, Lists.newArrayList((Object[])new Object[]{inputItem, inputFluid, inputParticle, outputItem, outputFluid, outputParticle1, outputParticle2, outputParticle3, maxEnergy, crossSection, energyReleased})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient inputItem, IIngredient inputParticle, IIngredient outputItem, IIngredient outputParticle1, IIngredient outputParticle2, IIngredient outputParticle3, long maxEnergy, double crossSection, @Optional(valueLong=0L) long energyReleased) {
            CraftTweakerAPI.apply((IAction)new AddQMDRecipe(QMDRecipes.target_chamber, Lists.newArrayList((Object[])new Object[]{inputItem, null, inputParticle, outputItem, null, outputParticle1, outputParticle2, outputParticle3, maxEnergy, crossSection, energyReleased})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputItem, IIngredient inputParticle) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.target_chamber, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputItem, null, inputParticle})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient inputItem, IIngredient inputFluid, IIngredient inputParticle) {
            CraftTweakerAPI.apply((IAction)new RemoveQMDRecipe(QMDRecipes.target_chamber, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{inputItem, inputFluid, inputParticle})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllQMDRecipes(QMDRecipes.target_chamber));
        }
    }

    @ZenClass(value="mods.qmd.accelerator_cooling")
    @ZenRegister
    public static class AcceleratorCoolingHandler {
        @ZenMethod
        public static void addRecipe(IIngredient fluidInput, IIngredient fluidOutput, int heatRemoved) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.accelerator_cooling, (List)Lists.newArrayList((Object[])new Object[]{fluidInput, fluidOutput, heatRemoved})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient fluidInput) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.accelerator_cooling, IngredientSorption.INPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{fluidInput})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient fluidOutput) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.accelerator_cooling, IngredientSorption.OUTPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{fluidOutput})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes((BasicRecipeHandler)QMDRecipes.accelerator_cooling));
        }
    }

    @ZenClass(value="mods.qmd.irradiator_fuel")
    @ZenRegister
    public static class IrradiatorFuelHandler {
        @ZenMethod
        public static void addFuel(IIngredient input, double speedMultiplier) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.irradiator_fuel, (List)Lists.newArrayList((Object[])new Object[]{input, speedMultiplier})));
        }

        @ZenMethod
        public static void removeFuel(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.irradiator_fuel, IngredientSorption.INPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeAllFuels() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes((BasicRecipeHandler)QMDRecipes.irradiator_fuel));
        }
    }

    @ZenClass(value="mods.qmd.irradiator")
    @ZenRegister
    public static class IrradiatorHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.irradiator, (List)Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.irradiator, IngredientSorption.INPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.irradiator, IngredientSorption.OUTPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes((BasicRecipeHandler)QMDRecipes.irradiator));
        }
    }

    @ZenClass(value="mods.qmd.ore_leacher")
    @ZenRegister
    public static class OreLeacherHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient input3, IIngredient input4, IIngredient output1, IIngredient output2, IIngredient output3, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe((BasicRecipeHandler)QMDRecipes.ore_leacher, (List)Lists.newArrayList((Object[])new Object[]{input1, input2, input3, input4, output1, output2, output3, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2, IIngredient input3, IIngredient input4) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.ore_leacher, IngredientSorption.INPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{input1, input2, input3, input4})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe((BasicRecipeHandler)QMDRecipes.ore_leacher, IngredientSorption.OUTPUT, (List)Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes((BasicRecipeHandler)QMDRecipes.ore_leacher));
        }
    }
}

