/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.fluid;

import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.QMD;
import lach_01298.qmd.fluid.BlockFluidExotic;
import lach_01298.qmd.fluid.QMDFluidType;
import nc.block.fluid.NCBlockFluid;
import nc.block.item.NCItemBlock;
import nc.enumm.FluidType;
import nc.util.ColorHelper;
import nc.util.NCUtil;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class QMDFluids {
    public static List<Pair<Fluid, NCBlockFluid>> fluidPairList = new ArrayList<Pair<Fluid, NCBlockFluid>>();

    public static void init() {
        try {
            QMDFluids.addFluidPair(FluidType.ACID, "hydrochloric_acid", 0x99FFEE);
            QMDFluids.addFluidPair(FluidType.ACID, "nitric_acid", 5218047);
            QMDFluids.addFluidPair(FluidType.SALT_SOLUTION, "sodium_chloride_solution", QMDFluids.waterBlend(22522));
            QMDFluids.addFluidPair(FluidType.SALT_SOLUTION, "sodium_nitrate_solution", QMDFluids.waterBlend(0xFFFFFF));
            QMDFluids.addFluidPair(FluidType.SALT_SOLUTION, "lead_nitrate_solution", QMDFluids.waterBlend(0xD5D5D5));
            QMDFluids.addFluidPair(FluidType.SALT_SOLUTION, "sodium_tungstate_solution", QMDFluids.waterBlend(16776867));
            QMDFluids.addFluidPair(FluidType.SALT_SOLUTION, "lead_tungstate_solution", QMDFluids.waterBlend(13993749));
            QMDFluids.addFluidPair(FluidType.LIQUID, "liquid_hydrogen", false, 11762372, 71, 20, 170, 0);
            QMDFluids.addFluidPair(FluidType.LIQUID, "liquid_argon", false, 16741853, 1395, 87, 170, 0);
            QMDFluids.addFluidPair(FluidType.LIQUID, "liquid_neon", false, 16752506, 1207, 27, 170, 0);
            QMDFluids.addFluidPair(FluidType.LIQUID, "liquid_oxygen", false, 8293576, 1141, 90, 170, 0);
            QMDFluids.addFluidPair(FluidType.LIQUID, "mercury", true, 0xC6C6C6, 13540, 300, 1000, 0);
            QMDFluids.addFluidPair(FluidType.LIQUID, "hot_mercury", true, 0xAAAAAA, 13540, 630, 1000, 0);
            QMDFluids.addFluidPair(FluidType.LIQUID, "iodine", false, 7602355, 3960, 387, 1000, 0);
            QMDFluids.addFluidPair(FluidType.GAS, "argon", 16741853);
            QMDFluids.addFluidPair(FluidType.GAS, "neon", 16752506);
            QMDFluids.addFluidPair(FluidType.GAS, "chlorine", 0xFFFF8F);
            QMDFluids.addFluidPair(FluidType.GAS, "nitric_oxide", 13233919);
            QMDFluids.addFluidPair(FluidType.GAS, "nitrogen_dioxide", 7875088);
            QMDFluids.addFluidPair(FluidType.GAS, "compressed_air", 0xD4D4D4);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "silicon", 0x676767);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "yag", 0xFFFDDB);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "nd_yag", 14990581);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "tungsten", 5133903);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "niobium", 0xCCCCC0);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "chromium", 0xC9C9C9);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "titanium", 9338509);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "cobalt", 3559280);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "nickel", 10725784);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "hafnium", 0x948484);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "zinc", 0xE0E0E0);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "osmium", 7309737);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "iridium", 0xDDD5DD);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "platinum", 7447721);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "calcium", 16053226);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "strontium", 12897175);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "yttrium", 13747061);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "neodymium", 8489623);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "samarium", 10803551);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "terbium", 6006420);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "erbium", 5929541);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "ytterbium", 8013138);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "bismuth", 8552051);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "polonium", 6061176);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "radium", 7233659);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "carbon", 0x343434);
            QMDFluids.addFluidPair(FluidType.MOLTEN, "sodium_chloride", 0xD4CCCC);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "antihydrogen", 11762372);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "antideuterium", 10383343);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "antitritium", 6142934);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "antihelium3", 13351783);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "antihelium", 12942209);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "positronium", 0xC9C9C9);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "muonium", 10195967);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "tauonium", 13132544);
            QMDFluids.addFluidPair(QMDFluidType.EXOTIC, "glueballs", 10940914);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends Fluid, V extends NCBlockFluid> void addFluidPair(FluidType fluidType, Object ... fluidArgs) {
        try {
            Fluid fluid = (Fluid)NCUtil.newInstance((Class)fluidType.getFluidClass(), (Object[])fluidArgs);
            NCBlockFluid block = (NCBlockFluid)NCUtil.newInstance((Class)fluidType.getBlockClass(), (Object[])new Object[]{fluid});
            fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)fluid, (Object)block));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends Fluid, V extends NCBlockFluid> void addFluidPair(QMDFluidType fluidType, Object ... fluidArgs) {
        try {
            Fluid fluid = (Fluid)NCUtil.newInstance(fluidType.getFluidClass(), (Object[])fluidArgs);
            NCBlockFluid block = (NCBlockFluid)NCUtil.newInstance(fluidType.getBlockClass(), (Object[])new Object[]{fluid});
            fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)fluid, (Object)block));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register() {
        for (Pair<Fluid, NCBlockFluid> fluidPair : fluidPairList) {
            Fluid fluid = (Fluid)fluidPair.getLeft();
            boolean defaultFluid = FluidRegistry.registerFluid((Fluid)fluid);
            if (!defaultFluid) {
                fluid = FluidRegistry.getFluid((String)fluid.getName());
            }
            if (!(fluidPair.getRight() instanceof BlockFluidExotic)) {
                FluidRegistry.addBucketForFluid((Fluid)fluid);
            }
            QMDFluids.registerBlock((NCBlockFluid)fluidPair.getRight());
        }
    }

    public static void registerBlock(NCBlockFluid block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)QMDFluids.withName(block));
        ForgeRegistries.ITEMS.register(new NCItemBlock((Block)block, TextFormatting.AQUA, new String[0]).setRegistryName(block.getRegistryName()));
        QMD.proxy.registerFluidBlockRendering((Block)block, block.name);
    }

    public static <T extends NCBlockFluid> Block withName(T block) {
        return (Block)block.func_149663_c("qmd." + block.name).setRegistryName(new ResourceLocation("qmd", block.name));
    }

    private static int waterBlend(int soluteColor, float blendRatio) {
        return ColorHelper.blend((int)3097588, (int)soluteColor, (float)blendRatio);
    }

    private static int waterBlend(int soluteColor) {
        return QMDFluids.waterBlend(soluteColor, 0.5f);
    }
}

