/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface IItemParticleAmount {
    public int getItemCapacity(ItemStack var1);

    public static int getCapacity(ItemStack stack) {
        NBTTagCompound nbt = IItemParticleAmount.getStorageNBT(stack);
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74762_e("particle_capacity");
    }

    default public int getAmountStored(ItemStack stack) {
        NBTTagCompound nbt = IItemParticleAmount.getStorageNBT(stack);
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74762_e("particle_amount");
    }

    default public void setAmountStored(ItemStack stack, int amount) {
        NBTTagCompound nbt;
        if (stack.func_77973_b() instanceof IItemParticleAmount && (nbt = IItemParticleAmount.getStorageNBT(stack)) != null) {
            if (amount < IItemParticleAmount.getCapacity(stack)) {
                nbt.func_74768_a("particle_amount", amount);
            } else {
                nbt.func_74768_a("particle_amount", IItemParticleAmount.getCapacity(stack));
            }
        }
    }

    default public ItemStack fill(ItemStack stack, int amount, String type) {
        if (this.getAmountStored(stack) + amount <= IItemParticleAmount.getCapacity(stack)) {
            this.setAmountStored(stack, this.getAmountStored(stack) + amount);
        }
        return stack;
    }

    default public ItemStack use(ItemStack stack, int amount) {
        if (this.getAmountStored(stack) > amount) {
            this.setAmountStored(stack, this.getAmountStored(stack) - amount);
        } else if (this.getAmountStored(stack) == amount) {
            return this.getEmptyItem();
        }
        return stack;
    }

    default public ItemStack getEmptyItem() {
        return ItemStack.field_190927_a;
    }

    default public boolean isEmptyItem(ItemStack stack) {
        return stack == this.getEmptyItem() || this.getAmountStored(stack) <= 0;
    }

    public static ItemStack cleanNBT(ItemStack stack) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_77982_d(null);
        return newStack;
    }

    public static ItemStack fullItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemParticleAmount) {
            IItemParticleAmount.setStorageNBT(stack);
            IItemParticleAmount item = (IItemParticleAmount)stack.func_77973_b();
            item.setAmountStored(stack, item.getItemCapacity(stack));
        }
        return stack;
    }

    public static NBTTagCompound getStorageNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("particle_storage")) {
            return null;
        }
        return nbt.func_74775_l("particle_storage");
    }

    public static void setStorageNBT(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IItemParticleAmount)) {
            return;
        }
        IItemParticleAmount item = (IItemParticleAmount)stack.func_77973_b();
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (!nbt.func_74764_b("particle_storage")) {
            NBTTagCompound storage = new NBTTagCompound();
            storage.func_74768_a("particle_amount", 0);
            storage.func_74768_a("particle_capacity", item.getItemCapacity(stack));
            nbt.func_74782_a("particle_storage", (NBTBase)storage);
            stack.func_77982_d(nbt);
        } else if (!nbt.func_74775_l("particle_storage").func_74764_b("particle_capacity")) {
            nbt.func_74775_l("particle_storage").func_74768_a("particle_capacity", item.getItemCapacity(stack));
            stack.func_77982_d(nbt);
        }
    }
}

