/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityAntimatterProjectile;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.ItemCell;
import lach_01298.qmd.item.ItemGun;
import lach_01298.qmd.item.QMDItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemAntimatterLauncher
extends ItemGun {
    public ItemAntimatterLauncher(String ... tooltip) {
        super(tooltip);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.findCell(player) >= 0) {
            ItemStack cell = player.field_71071_by.func_70301_a(this.findCell(player));
            float damage = 0.0f;
            Integer color = 0;
            if (cell.func_77960_j() == MaterialTypes.CellType.ANTIHYDROGEN.getID()) {
                damage = 1.0f;
                color = 11762372;
            } else if (cell.func_77960_j() == MaterialTypes.CellType.ANTIDEUTERIUM.getID()) {
                damage = 2.0f;
                color = 10383343;
            } else if (cell.func_77960_j() == MaterialTypes.CellType.ANTITRITIUM.getID()) {
                damage = 3.0f;
                color = 6142934;
            } else if (cell.func_77960_j() == MaterialTypes.CellType.ANTIHELIUM3.getID()) {
                damage = 3.0f;
                color = 13351783;
            } else if (cell.func_77960_j() == MaterialTypes.CellType.ANTIHELIUM.getID()) {
                damage = 4.0f;
                color = 12942209;
            }
            ItemCell itemCell = (ItemCell)cell.func_77973_b();
            if (itemCell.getAmountStored(cell) < QMDConfig.antimatter_launcher_particle_usage) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70299_a(this.findCell(player), itemCell.use(cell, QMDConfig.antimatter_launcher_particle_usage));
            }
            player.func_184811_cZ().func_185145_a((Item)this, QMDConfig.antimatter_launcher_cool_down);
            if (!world.field_72995_K) {
                EntityAntimatterProjectile projectile = new EntityAntimatterProjectile(world, (EntityLivingBase)player, (double)damage, color);
                float velocity = 3.0f;
                projectile.shoot((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
                world.func_72838_d((Entity)projectile);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    private int findCell(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isCell(itemstack)) continue;
            return i;
        }
        return -1;
    }

    private boolean isCell(ItemStack stack) {
        if (stack.func_77973_b() == QMDItems.cell) {
            return stack.func_77960_j() == MaterialTypes.CellType.ANTIHYDROGEN.getID() || stack.func_77960_j() == MaterialTypes.CellType.ANTIDEUTERIUM.getID() || stack.func_77960_j() == MaterialTypes.CellType.ANTITRITIUM.getID() || stack.func_77960_j() == MaterialTypes.CellType.ANTIHELIUM3.getID() || stack.func_77960_j() == MaterialTypes.CellType.ANTIHELIUM.getID();
        }
        return false;
    }
}

