/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import java.text.DecimalFormat;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.ITileParticleStorage;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particleChamber.CollisionChamberLogic;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeamPort;
import lach_01298.qmd.pipe.Pipe;
import lach_01298.qmd.pipe.TileBeamline;
import lach_01298.qmd.util.Equations;
import lach_01298.qmd.util.Units;
import nc.item.NCItem;
import nc.util.Lang;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemBeamMeter
extends NCItem {
    public ItemBeamMeter(String ... tooltip) {
        super(tooltip);
        this.field_77777_bU = 1;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null) {
            if (player.func_70093_af()) {
                ITileParticleStorage port;
                if (tile instanceof TileParticleChamberBeamPort && ((TileParticleChamberBeamPort)(port = (TileParticleChamberBeamPort)tile)).getIOType() == EnumTypes.IOType.OUTPUT) {
                    int inputNumberOffset = 0;
                    if (((ParticleChamber)port.getMultiblock()).getLogic() instanceof CollisionChamberLogic) {
                        inputNumberOffset = 1;
                    }
                    TextComponentString message = new TextComponentString(Lang.localise((String)"qmd.block.particle_chamber_port_setting", (Object[])new Object[]{TextFormatting.LIGHT_PURPLE + " " + (((TileParticleChamberBeamPort)port).getIONumber() - inputNumberOffset)}));
                    player.func_145747_a((ITextComponent)message);
                    return EnumActionResult.SUCCESS;
                }
                if (tile instanceof TileAcceleratorBeamPort) {
                    TextFormatting colour;
                    port = (TileAcceleratorBeamPort)tile;
                    switch (((TileAcceleratorBeamPort)port).getSetting()) {
                        case INPUT: {
                            colour = TextFormatting.DARK_AQUA;
                            break;
                        }
                        case OUTPUT: {
                            colour = TextFormatting.RED;
                            break;
                        }
                        default: {
                            colour = TextFormatting.GRAY;
                        }
                    }
                    TextComponentString message = new TextComponentString(Lang.localise((String)"qmd.block.accelerator_port_setting", (Object[])new Object[]{colour + Lang.localise((String)("qmd.block.port_mode." + ((TileAcceleratorBeamPort)port).getSetting().name()))}));
                    player.func_145747_a((ITextComponent)message);
                    return EnumActionResult.SUCCESS;
                }
            } else {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if (!tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face)) continue;
                    IParticleStackHandler particleStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face);
                    ParticleStack particle = particleStorage.getParticle();
                    if (particle != null) {
                        TileBeamline beam;
                        if (tile instanceof TileBeamline && (beam = (TileBeamline)tile).getMultiblock() != null) {
                            particle.addFocus(-Equations.focusLoss(((Pipe)beam.getMultiblock()).length(), particle));
                        }
                        DecimalFormat df = new DecimalFormat("#.####");
                        DecimalFormat df2 = new DecimalFormat("#.#");
                        TextComponentString message = new TextComponentString(TextFormatting.AQUA + Lang.localise((String)"gui.qmd.particlestack.name", (Object[])new Object[]{TextFormatting.WHITE + Lang.localise((String)("qmd.particle." + particle.getParticle().getName() + ".name"))}) + " " + TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.particlestack.amount", (Object[])new Object[]{TextFormatting.WHITE + Units.getSIFormat(particle.getAmount(), "pu")}) + " " + TextFormatting.GREEN + Lang.localise((String)"gui.qmd.particlestack.mean_energy", (Object[])new Object[]{TextFormatting.WHITE + Units.getSIFormat(particle.getMeanEnergy(), 3, "eV")}) + " " + TextFormatting.DARK_AQUA + Lang.localise((String)"gui.qmd.particlestack.focus", (Object[])new Object[]{TextFormatting.WHITE + df.format(particle.getFocus())}));
                        player.func_145747_a((ITextComponent)message);
                        TextComponentString lossMessage = new TextComponentString(TextFormatting.DARK_AQUA + Lang.localise((String)"gui.qmd.particlestack.focus_loss", (Object[])new Object[]{TextFormatting.WHITE + df.format(Equations.focusLoss(1.0, particle))}) + " " + TextFormatting.GREEN + Lang.localise((String)"gui.qmd.particlestack.travel_distance", (Object[])new Object[]{TextFormatting.WHITE + df2.format(Equations.travelDistance(particle))}));
                        player.func_145747_a((ITextComponent)lossMessage);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"gui.qmd.particlestack.empty")));
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }
}

