/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityGammaFlash;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.util.Units;
import nc.capability.radiation.entity.IEntityRads;
import nc.item.NCItem;
import nc.radiation.RadiationHelper;
import nc.util.DamageSources;
import nc.util.InfoHelper;
import nc.util.Lang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCustomParticleSource
extends NCItem
implements IItemParticleAmount {
    private final int capacity;
    private ItemStack emptyItem;
    private boolean explode;
    private double size;
    private double radiation;

    public ItemCustomParticleSource(int capacity, int stackSize) {
        super(new String[0]);
        this.capacity = capacity;
        this.func_77625_d(stackSize);
        this.emptyItem = ItemStack.field_190927_a;
        this.explode = false;
        this.size = 0.0;
        this.radiation = 0.0;
    }

    public ItemCustomParticleSource(int capacity, int stackSize, double size, double radiation) {
        super(new String[0]);
        this.capacity = capacity;
        this.func_77625_d(stackSize);
        this.emptyItem = ItemStack.field_190927_a;
        this.explode = true;
        this.size = size;
        this.radiation = radiation;
    }

    @Override
    public int getItemCapacity(ItemStack stack) {
        return this.capacity;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            IItemParticleAmount.fullItem(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public ItemStack getEmptyItem() {
        return new ItemStack(this.emptyItem.func_77973_b(), 1, this.emptyItem.func_77960_j());
    }

    public void setEmptyItem(ItemStack stack) {
        this.emptyItem = stack;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getAmountStored(stack) / (double)this.getItemCapacity(stack)), (double)0.0, (double)1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getAmountStored(stack) > 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.DARK_GREEN, (String)Lang.localise((String)"info.qmd.item.amount", (Object[])new Object[]{Units.getSIFormat(this.getAmountStored(stack), "pu"), Units.getSIFormat(this.getItemCapacity(stack), "pu")}));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (this.explode) {
            ItemStack stack = entityItem.func_92059_d();
            if (entityItem.field_70173_aa > QMDConfig.cell_lifetime || entityItem.func_180799_ab() || entityItem.func_70027_ad() || entityItem.field_70128_L) {
                this.explode(entityItem.field_70170_p, entityItem.func_180425_c(), stack);
                stack.func_190918_g(stack.func_190916_E());
            }
        }
        return false;
    }

    public void explode(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K) {
            double s = this.size;
            double r = this.radiation;
            if (IItemParticleAmount.getCapacity(stack) > 0) {
                s *= (double)(stack.func_190916_E() * this.getAmountStored(stack)) / (double)IItemParticleAmount.getCapacity(stack);
                r *= (double)(stack.func_190916_E() * this.getAmountStored(stack)) / (double)IItemParticleAmount.getCapacity(stack);
            }
            world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)s, true);
            world.func_72838_d((Entity)new EntityGammaFlash(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), s));
            HashSet entitylist = new HashSet();
            double radius = 128.0 * Math.sqrt(s);
            entitylist.addAll(world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)pos.func_177958_n() - radius, (double)pos.func_177956_o() - radius, (double)pos.func_177952_p() - radius, (double)pos.func_177958_n() + radius, (double)pos.func_177956_o() + radius, (double)pos.func_177952_p() + radius)));
            for (EntityLivingBase entity : entitylist) {
                IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)entity);
                if (entityRads == null) continue;
                double rads = Math.min(r, r / pos.func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)entity, (double)rads, (boolean)false, (boolean)false, (int)1));
                if (!(rads >= entityRads.getMaxRads())) continue;
                entity.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
            }
        }
    }
}

