/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.QMDDamageSources;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityGluonBeam;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.IItemMode;
import lach_01298.qmd.item.ItemCell;
import lach_01298.qmd.item.ItemGun;
import lach_01298.qmd.item.QMDItems;
import lach_01298.qmd.util.Util;
import nc.capability.radiation.entity.IEntityRads;
import nc.radiation.RadiationHelper;
import nc.util.InfoHelper;
import nc.util.Lang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemGluonGun
extends ItemGun
implements IItemMode {
    private EntityGluonBeam beam;

    public ItemGluonGun(String ... tooltip) {
        super(tooltip);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                if (this.getMode(itemstack).equals("breaking")) {
                    this.setMode(itemstack, "silk_touch");
                    player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"info.qmd.item.mode.switch") + TextFormatting.DARK_GREEN + Lang.localise((String)"info.qmd.item.mode.silk_touch")));
                } else {
                    this.setMode(itemstack, "breaking");
                    player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"info.qmd.item.mode.switch") + TextFormatting.DARK_GREEN + Lang.localise((String)"info.qmd.item.mode.breaking")));
                }
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (this.findCell(player) >= 0) {
            ItemStack cell = player.field_71071_by.func_70301_a(this.findCell(player));
            ItemCell itemCell = (ItemCell)cell.func_77973_b();
            if (itemCell.getAmountStored(cell) < QMDConfig.gluon_particle_usage) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
            player.func_184598_c(hand);
            RayTraceResult lookingAt = this.rayTrace((EntityLivingBase)player, QMDConfig.gluon_range, 1.0f, true, true);
            if (!world.field_72995_K) {
                if (lookingAt != null) {
                    double length = lookingAt.field_72307_f.func_72438_d(player.func_174791_d().func_72441_c(0.0, (double)player.eyeHeight, 0.0));
                    if (length > QMDConfig.gluon_range) {
                        length = QMDConfig.gluon_range;
                    }
                    this.beam = new EntityGluonBeam(world, player, length, hand);
                } else {
                    this.beam = new EntityGluonBeam(world, player, QMDConfig.gluon_range, hand);
                }
                world.func_72838_d((Entity)this.beam);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            if (this.findCell(player) >= 0) {
                ItemStack cell = player.field_71071_by.func_70301_a(this.findCell(player));
                ItemCell itemCell = (ItemCell)cell.func_77973_b();
                if (itemCell.getAmountStored(cell) < QMDConfig.gluon_particle_usage) {
                    user.func_184597_cx();
                    return;
                }
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_70299_a(this.findCell(player), itemCell.use(cell, QMDConfig.gluon_particle_usage));
                }
                World world = user.func_130014_f_();
                RayTraceResult lookingAt = this.rayTrace(user, QMDConfig.gluon_range, 1.0f, true, true);
                if (!world.field_72995_K) {
                    if (lookingAt != null && lookingAt.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos pos = lookingAt.func_178782_a();
                        String mode = this.getMode(stack);
                        if (mode.equals("breaking")) {
                            Util.mineBlock(world, pos, player, 4, false, true);
                        } else if (mode.equals("silk_touch")) {
                            Util.mineBlock(world, pos, player, 0, true, true);
                        }
                    } else if (lookingAt != null && lookingAt.field_72313_a == RayTraceResult.Type.ENTITY) {
                        Entity entity = lookingAt.field_72308_g;
                        if (entity instanceof EntityLivingBase) {
                            IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)((EntityLivingBase)entity));
                            entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)((EntityLivingBase)entity), (double)QMDConfig.gluon_radiation, (boolean)false, (boolean)false, (int)1));
                        }
                        entity.func_70097_a(QMDDamageSources.causeGluonGunDamage(this.beam, (Entity)player), (float)QMDConfig.gluon_damage);
                    }
                    if (lookingAt != null) {
                        this.beam.setLength(lookingAt.field_72307_f.func_72438_d(user.func_174791_d().func_72441_c(0.0, (double)user.func_70047_e(), 0.0)));
                    }
                }
            } else {
                user.func_184597_cx();
            }
        }
    }

    private int findCell(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isCell(itemstack)) continue;
            return i;
        }
        return -1;
    }

    private boolean isCell(ItemStack stack) {
        if (stack.func_77973_b() == QMDItems.cell) {
            return stack.func_77960_j() == MaterialTypes.CellType.GLUEBALLS.getID();
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.DARK_GREEN, (String)Lang.localise((String)"info.qmd.item.mode", (Object[])new Object[]{Lang.localise((String)("info.qmd.item.mode." + this.getMode(stack)))}));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public String getDefaultMode() {
        return "breaking";
    }

    @Override
    public List<String> getModes() {
        ArrayList<String> modes = new ArrayList<String>();
        modes.add("breaking");
        modes.add("silk_touch");
        return modes;
    }
}

