/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import lach_01298.qmd.QMDDamageSources;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityLeptonBeam;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.ItemCell;
import lach_01298.qmd.item.ItemGun;
import lach_01298.qmd.item.QMDItems;
import lach_01298.qmd.sound.QMDSounds;
import nc.capability.radiation.entity.IEntityRads;
import nc.radiation.RadiationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemLeptonCannon
extends ItemGun {
    public ItemLeptonCannon(String ... tooltip) {
        super(tooltip);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.findCell(player) >= 0) {
            ItemStack cell = player.field_71071_by.func_70301_a(this.findCell(player));
            float damage = 0.0f;
            double radiation = 0.0;
            double range = 0.0;
            Integer color = 0;
            if (cell.func_77960_j() == MaterialTypes.CellType.POSITRONIUM.getID()) {
                damage = (float)QMDConfig.lepton_damage[0];
                radiation = QMDConfig.lepton_radiation[0];
                range = QMDConfig.lepton_range[0];
                color = 0xABABAB;
            } else if (cell.func_77960_j() == MaterialTypes.CellType.MUONIUM.getID()) {
                damage = (float)QMDConfig.lepton_damage[1];
                radiation = QMDConfig.lepton_radiation[1];
                range = QMDConfig.lepton_range[1];
                color = 6510591;
            } else if (cell.func_77960_j() == MaterialTypes.CellType.TAUONIUM.getID()) {
                damage = (float)QMDConfig.lepton_damage[2];
                radiation = QMDConfig.lepton_radiation[2];
                range = QMDConfig.lepton_range[2];
                color = 16743936;
            }
            ItemCell itemCell = (ItemCell)cell.func_77973_b();
            if (itemCell.getAmountStored(cell) < QMDConfig.lepton_particle_usage) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70299_a(this.findCell(player), itemCell.use(cell, QMDConfig.lepton_particle_usage));
            }
            player.func_184811_cZ().func_185145_a((Item)this, QMDConfig.lepton_cool_down);
            RayTraceResult lookingAt = this.rayTrace((EntityLivingBase)player, range, 1.0f, false, true);
            if (!world.field_72995_K) {
                EntityLeptonBeam entityBeam;
                if (lookingAt != null) {
                    double length = lookingAt.field_72307_f.func_72438_d(player.func_174791_d().func_72441_c(0.0, (double)player.eyeHeight, 0.0));
                    if (length > range) {
                        length = range;
                    }
                    entityBeam = new EntityLeptonBeam(world, player, length, hand, color);
                } else {
                    entityBeam = new EntityLeptonBeam(world, player, range, hand, color);
                }
                world.func_72838_d((Entity)new EntityLeptonBeam(world, player, range, hand, color));
                if (lookingAt != null && lookingAt.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity entity = lookingAt.field_72308_g;
                    if (entity instanceof EntityLivingBase) {
                        IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)((EntityLivingBase)entity));
                        entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)((EntityLivingBase)entity), (double)radiation, (boolean)false, (boolean)false, (int)1));
                    }
                    entity.func_70097_a(QMDDamageSources.causeLeptonCannonDamage(entityBeam, (Entity)player), damage);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, QMDSounds.lepton_cannon, SoundCategory.NEUTRAL, 0.2f, 1.0f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    private int findCell(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isCell(itemstack)) continue;
            return i;
        }
        return -1;
    }

    private boolean isCell(ItemStack stack) {
        if (stack.func_77973_b() == QMDItems.cell) {
            return stack.func_77960_j() == MaterialTypes.CellType.POSITRONIUM.getID() || stack.func_77960_j() == MaterialTypes.CellType.MUONIUM.getID() || stack.func_77960_j() == MaterialTypes.CellType.TAUONIUM.getID();
        }
        return false;
    }
}

