/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.gui;

import com.google.common.collect.Lists;
import java.util.List;
import nc.gui.NCGui;
import nc.gui.element.GuiItemRenderer;
import nc.init.NCItems;
import nc.tile.energy.ITileEnergy;
import nc.tile.processor.TileItemFluidProcessor;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiItemFluidMachine
extends NCGui {
    protected final EntityPlayer player;
    protected final TileItemFluidProcessor tile;
    protected final ResourceLocation gui_textures;
    protected GuiItemRenderer speedUpgradeRender = null;
    protected GuiItemRenderer energyUpgradeRender = null;

    public GuiItemFluidMachine(String name, EntityPlayer player, TileItemFluidProcessor tile, Container inventory) {
        super(inventory);
        this.player = player;
        this.tile = tile;
        this.gui_textures = new ResourceLocation("qmd:textures/gui/" + name + ".png");
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected int getCookProgressScaled(double pixels) {
        double i = this.tile.time;
        double j = this.tile.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * pixels / j) : 0;
    }

    protected void func_146284_a(GuiButton guiButton) {
    }

    public void drawEnergyTooltip(ITileEnergy tile, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (this.tile.defaultProcessPower != 0.0) {
            super.drawEnergyTooltip(tile, mouseX, mouseY, x, y, width, height);
        } else {
            this.drawNoEnergyTooltip(mouseX, mouseY, x, y, width, height);
        }
    }

    public List<String> energyInfo(ITileEnergy tile) {
        String energy = UnitHelper.prefix((long)tile.getEnergyStorage().getEnergyStored(), (long)tile.getEnergyStorage().getMaxEnergyStored(), (int)5, (String)"RF");
        String power = UnitHelper.prefix((long)this.tile.getProcessPower(), (int)5, (String)"RF/t");
        String speedMultiplier = "x" + NCMath.decimalPlaces((double)this.tile.getSpeedMultiplier(), (int)2);
        String powerMultiplier = "x" + NCMath.decimalPlaces((double)this.tile.getPowerMultiplier(), (int)2);
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise((String)"gui.nc.container.energy_stored") + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + Lang.localise((String)"gui.nc.container.process_power") + TextFormatting.WHITE + " " + power, TextFormatting.AQUA + Lang.localise((String)"gui.nc.container.speed_multiplier") + TextFormatting.WHITE + " " + speedMultiplier, TextFormatting.AQUA + Lang.localise((String)"gui.nc.container.power_multiplier") + TextFormatting.WHITE + " " + powerMultiplier});
    }

    protected void drawUpgradeRenderers() {
        if (this.speedUpgradeRender == null) {
            this.speedUpgradeRender = new GuiItemRenderer(NCItems.upgrade, 0, this.field_147003_i + 132, this.field_147009_r + this.field_147000_g - 102, 0.5f);
        }
        if (this.energyUpgradeRender == null) {
            this.energyUpgradeRender = new GuiItemRenderer(NCItems.upgrade, 1, this.field_147003_i + 152, this.field_147009_r + this.field_147000_g - 102, 0.5f);
        }
        this.speedUpgradeRender.draw();
        this.energyUpgradeRender.draw();
    }
}

