/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.ParticleStorageSource;
import lach_01298.qmd.tile.TileCreativeParticleSource;
import lach_01298.qmd.util.ByteUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CreativeParticleSourceGuiPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    public List<ParticleStorageSource> beams;

    public CreativeParticleSourceGuiPacket() {
        this.messageValid = false;
        this.beams = new ArrayList<ParticleStorageSource>();
    }

    public CreativeParticleSourceGuiPacket(TileCreativeParticleSource tile) {
        this.pos = tile.getTilePos();
        this.beams = tile.getParticleBeams();
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                ParticleStorage storage = ByteUtil.readBufBeam(buf);
                ParticleStorageSource beam = new ParticleStorageSource();
                beam.setParticleStack(storage.getParticleStack());
                this.beams.add(beam);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.beams.size());
        for (ParticleStorageSource beam : this.beams) {
            ByteUtil.writeBufBeam(beam, buf);
        }
    }

    public static class Handler
    implements IMessageHandler<CreativeParticleSourceGuiPacket, IMessage> {
        public IMessage onMessage(CreativeParticleSourceGuiPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CreativeParticleSourceGuiPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity tile = player.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof TileCreativeParticleSource) {
                TileCreativeParticleSource source = (TileCreativeParticleSource)tile;
                source.setParticleBeams(message.beams);
                source.markDirtyAndNotify(true);
            }
        }
    }
}

