/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.tile;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import lach_01298.qmd.item.IItemParticleAmount;
import nc.config.NCConfig;
import nc.network.tile.ProcessorUpdatePacket;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.inventory.TileSidedInventory;
import nc.tile.processor.IItemProcessor;
import nc.tile.processor.ITileSideConfigGui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class TileItemAmountFuelProcessor
extends TileSidedInventory
implements IItemProcessor,
ITileSideConfigGui<ProcessorUpdatePacket> {
    public final int defaultProcessTime;
    public double baseProcessTime;
    public double baseProcessRadiation;
    public final int itemInputSize;
    public final int itemFuelSize;
    public final int itemOutputSize;
    public double time;
    public int fuelUseRate;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public final boolean shouldLoseProgress;
    public final int processorID;
    public final int sideConfigYOffset;
    public final BasicRecipeHandler fuelHandler;
    public final BasicRecipeHandler recipeHandler;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected RecipeInfo<BasicRecipe> fuelInfo;
    protected Set<EntityPlayer> playersToUpdate;
    public Random rand = new Random();

    public TileItemAmountFuelProcessor(String name, int itemInSize, int itemFuelSize, int itemOutSize, @Nonnull List<ItemSorption> itemSorptions, int time, int fuelUsage, boolean shouldLoseProgress, @Nonnull BasicRecipeHandler recipeHandler, @Nonnull BasicRecipeHandler fuelHandler, int processorID, int sideConfigYOffset) {
        super(name, itemInSize + itemFuelSize + itemOutSize, ITileInventory.inventoryConnectionAll(itemSorptions));
        this.itemInputSize = itemInSize;
        this.itemFuelSize = itemFuelSize;
        this.itemOutputSize = itemOutSize;
        this.defaultProcessTime = time;
        this.baseProcessTime = time;
        this.fuelUseRate = fuelUsage;
        this.shouldLoseProgress = shouldLoseProgress;
        this.processorID = processorID;
        this.sideConfigYOffset = sideConfigYOffset;
        this.recipeHandler = recipeHandler;
        this.fuelHandler = fuelHandler;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    public static List<ItemSorption> defaultItemSorptions(int inSize, int fuelSize, int outSize) {
        int i;
        ArrayList<ItemSorption> itemSorptions = new ArrayList<ItemSorption>();
        for (i = 0; i < inSize + fuelSize; ++i) {
            itemSorptions.add(ItemSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            itemSorptions.add(ItemSorption.OUT);
        }
        return itemSorptions;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshFuel();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
                if (this.time > 0.0 && !this.isHaltedByRedstone() && (this.shouldLoseProgress || !this.canProcessInputs)) {
                    this.loseProgress();
                }
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
                this.setActivity(this.isProcessing);
                this.sendTileUpdatePacketToAll();
            }
            this.sendTileUpdatePacketToListeners();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void refreshRecipe() {
        this.recipeInfo = this.recipeHandler.getRecipeInfoFromInputs(this.getItemInputs(), new ArrayList());
    }

    public void refreshFuel() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getItemFuels()) {
            stacks.add(IItemParticleAmount.cleanNBT(stack));
        }
        this.fuelInfo = this.fuelHandler.getRecipeInfoFromInputs(stacks, new ArrayList());
    }

    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
        this.refreshFuel();
    }

    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
        this.refreshFuel();
    }

    public int getProcessTime() {
        if (this.fuelInfo == null) {
            return 0;
        }
        return Math.max(1, (int)Math.round(Math.ceil(this.baseProcessTime / ((BasicRecipe)this.fuelInfo.getRecipe()).getBaseProcessTime(1.0))));
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = ((BasicRecipe)this.recipeInfo.getRecipe()).getBaseProcessTime((double)this.defaultProcessTime);
        this.baseProcessRadiation = ((BasicRecipe)this.recipeInfo.getRecipe()).getBaseProcessRadiation();
        return true;
    }

    public boolean isProcessing() {
        return this.readyToProcess() && !this.isHaltedByRedstone();
    }

    public boolean isHaltedByRedstone() {
        return this.getRedstoneControl() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.fuelInfo != null;
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            return false;
        }
        if (!justProduced && this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < this.itemOutputSize; ++j) {
            if (this.getItemOutputSetting(j + this.itemInputSize + this.itemFuelSize) == ItemOutputSetting.VOID) {
                this.getInventoryStacks().set(j + this.itemInputSize + this.itemFuelSize, (Object)ItemStack.field_190927_a);
                continue;
            }
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (itemProduct.getStack() == null || ((ItemStack)itemProduct.getStack()).func_190926_b()) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_190926_b()) continue;
            if (!((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_77969_a((ItemStack)itemProduct.getStack())) {
                return false;
            }
            if (this.getItemOutputSetting(j + this.itemInputSize + this.itemFuelSize) != ItemOutputSetting.DEFAULT || ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_190916_E() + itemProduct.getMaxStackSize(0) <= ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time += ((BasicRecipe)this.fuelInfo.getRecipe()).getBaseProcessTime(1.0);
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * ((BasicRecipe)this.fuelInfo.getRecipe()).getBaseProcessTime(1.0));
        for (int i = 0; i < this.itemFuelSize; ++i) {
            this.useFuel(this.itemInputSize + i);
        }
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    private void useFuel(int slot) {
        if (((ItemStack)this.getInventoryStacks().get(slot)).func_77973_b() instanceof IItemParticleAmount) {
            IItemParticleAmount item = (IItemParticleAmount)((ItemStack)this.getInventoryStacks().get(slot)).func_77973_b();
            this.getInventoryStacks().set(slot, (Object)item.use((ItemStack)this.getInventoryStacks().get(slot), (int)((BasicRecipe)this.fuelInfo.getRecipe()).getBaseProcessTime((double)this.fuelUseRate)));
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.refreshFuel();
        this.time = !this.setRecipeStats() ? 0.0 : MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        if (this.recipeInfo == null) {
            return;
        }
        IntList itemInputOrder = this.recipeInfo.getItemInputOrder();
        if (itemInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (int i = 0; i < this.itemInputSize; ++i) {
            int itemIngredientStackSize = this.getItemIngredients().get((Integer)itemInputOrder.get(i)).getMaxStackSize(((Integer)this.recipeInfo.getItemIngredientNumbers().get(i)).intValue());
            if (itemIngredientStackSize > 0) {
                ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(itemIngredientStackSize);
            }
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
        for (int j = 0; j < this.itemOutputSize; ++j) {
            if (this.getItemOutputSetting(j + this.itemInputSize + this.itemFuelSize) == ItemOutputSetting.VOID) {
                this.getInventoryStacks().set(j + this.itemInputSize + this.itemFuelSize, (Object)ItemStack.field_190927_a);
                continue;
            }
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_190926_b()) {
                this.getInventoryStacks().set(j + this.itemInputSize + this.itemFuelSize, (Object)itemProduct.getNextStack(0));
                continue;
            }
            if (!((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_77969_a((ItemStack)itemProduct.getStack())) continue;
            int count = Math.min(this.func_70297_j_(), ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_190916_E() + itemProduct.getNextStackSize(0));
            ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize + this.itemFuelSize)).func_190920_e(count);
        }
    }

    public void loseProgress() {
        this.time = MathHelper.func_151237_a((double)(this.time - 150.0), (double)0.0, (double)this.baseProcessTime);
    }

    public List<ItemStack> getItemInputs() {
        return this.getInventoryStacks().subList(0, this.itemInputSize);
    }

    public List<ItemStack> getItemFuels() {
        return this.getInventoryStacks().subList(this.itemInputSize, this.itemInputSize + this.itemFuelSize);
    }

    public List<IItemIngredient> getItemIngredients() {
        return ((BasicRecipe)this.recipeInfo.getRecipe()).getItemIngredients();
    }

    public List<IItemIngredient> getItemProducts() {
        return ((BasicRecipe)this.recipeInfo.getRecipe()).getItemProducts();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshFuel();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            }
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshFuel();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            }
        }
    }

    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshFuel();
        this.refreshActivity();
        super.func_70296_d();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot >= this.itemInputSize + this.itemFuelSize) {
            return false;
        }
        if (slot >= this.itemInputSize) {
            if (((ItemStack)this.getInventoryStacks().get(slot)).func_190916_E() >= 1) {
                return false;
            }
            return NCConfig.smart_processor_input ? this.fuelHandler.isValidItemInput(slot - this.itemInputSize, IItemParticleAmount.cleanNBT(stack), this.recipeInfo, this.getItemFuels(), this.fuelItemStacksExcludingSlot(slot - this.itemInputSize)) : this.fuelHandler.isValidItemInput(IItemParticleAmount.cleanNBT(stack));
        }
        return NCConfig.smart_processor_input ? this.recipeHandler.isValidItemInput(slot, stack, this.recipeInfo, this.getItemInputs(), this.inputItemStacksExcludingSlot(slot)) : this.recipeHandler.isValidItemInput(stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemInputs());
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    public List<ItemStack> fuelItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> fuelItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemFuels());
        fuelItemsExcludingSlot.remove(slot);
        return fuelItemsExcludingSlot;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    public boolean hasConfigurableInventoryConnections() {
        return true;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        if (nbt.func_74764_b("redstoneControl")) {
            this.setRedstoneControl(nbt.func_74767_n("redstoneControl"));
        } else {
            this.setRedstoneControl(true);
        }
    }

    public int getGuiID() {
        return this.processorID;
    }

    public Set<EntityPlayer> getTileUpdatePacketListeners() {
        return this.playersToUpdate;
    }

    public ProcessorUpdatePacket getTileUpdatePacket() {
        return new ProcessorUpdatePacket(this.field_174879_c, this.isProcessing, this.time, 0, this.baseProcessTime, 0.0, new ArrayList());
    }

    public void onTileUpdatePacket(ProcessorUpdatePacket message) {
        this.time = message.time;
        this.baseProcessTime = message.baseProcessTime;
    }

    public int getSideConfigXOffset() {
        return 0;
    }

    public int getSideConfigYOffset() {
        return this.sideConfigYOffset;
    }

    public int getItemInputSize() {
        return this.itemInputSize;
    }

    public int getItemOutputSize() {
        return this.itemOutputSize;
    }
}

