/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock.gui;

import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.LinearAcceleratorLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileLinearAcceleratorController;
import lach_01298.qmd.gui.GuiParticle;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.util.Units;
import nc.multiblock.gui.GuiLogicMultiblock;
import nc.multiblock.gui.element.MultiblockButton;
import nc.multiblock.tile.IMultiblockGuiPart;
import nc.network.PacketHandler;
import nc.network.multiblock.ClearAllMaterialPacket;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLinearAcceleratorController
extends GuiLogicMultiblock<Accelerator, AcceleratorLogic, IAcceleratorPart, AcceleratorUpdatePacket, TileLinearAcceleratorController, LinearAcceleratorLogic> {
    protected final ResourceLocation gui_texture = new ResourceLocation("qmd:textures/gui/accelerator_controller.png");
    private final GuiParticle guiParticle;

    public GuiLinearAcceleratorController(EntityPlayer player, TileLinearAcceleratorController controller) {
        super(player, (IMultiblockGuiPart)controller);
        this.field_146999_f = 196;
        this.field_147000_g = 109;
        this.guiParticle = new GuiParticle((GuiContainer)this);
    }

    protected ResourceLocation getGuiTexture() {
        return this.gui_texture;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.renderTooltips(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offset = 40;
        int fontColor = ((Accelerator)this.multiblock).isControllorOn ? -1 : 0xEEAA00;
        String title = Lang.localise((String)"gui.qmd.container.linear_accelerator_controller.name");
        this.field_146289_q.func_78276_b(title, offset, 5, fontColor);
        String length = Lang.localise((String)"gui.qmd.container.accelerator.length", (Object[])new Object[]{((AcceleratorLogic)this.logic).getBeamLength()});
        this.field_146289_q.func_78276_b(length, offset + 25, 25, fontColor);
        String cavitys = Lang.localise((String)"gui.qmd.container.accelerator.cavitys", (Object[])new Object[]{((Accelerator)this.multiblock).RFCavityNumber, Units.getSIFormat(((Accelerator)this.multiblock).acceleratingVoltage, 3, "V")});
        this.field_146289_q.func_78276_b(cavitys, offset, 50, fontColor);
        String quadrupoles = Lang.localise((String)"gui.qmd.container.accelerator.quadrupoles", (Object[])new Object[]{((Accelerator)this.multiblock).quadrupoleNumber, Units.getSIFormat(((Accelerator)this.multiblock).quadrupoleStrength, "T")});
        this.field_146289_q.func_78276_b(quadrupoles, offset, 60, fontColor);
        String temperature = Lang.localise((String)"gui.qmd.container.temperature", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).getTemperature(), "K")});
        this.field_146289_q.func_78276_b(temperature, offset, 70, fontColor);
        String maxTemperature = Lang.localise((String)"gui.qmd.container.max_temperature", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).maxOperatingTemp, "K")});
        this.field_146289_q.func_78276_b(maxTemperature, offset, 80, fontColor);
        if (((Accelerator)this.multiblock).errorCode != 0) {
            String error = Lang.localise((String)("gui.qmd.container.accelerator.error." + ((Accelerator)this.multiblock).errorCode));
            this.field_146289_q.func_78276_b(error, offset, 90, 0xFF0000);
        }
        if (!NCUtil.isModifierKeyDown()) {
            // empty if block
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int power = (int)Math.round((double)((Accelerator)this.multiblock).energyStorage.getEnergyStored() / (double)((Accelerator)this.multiblock).energyStorage.getMaxEnergyStored() * 95.0);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 101 - power, 196, 95 - power, 6, power);
        int heat = (int)Math.round((double)((Accelerator)this.multiblock).heatBuffer.getHeatStored() / (double)((Accelerator)this.multiblock).heatBuffer.getHeatCapacity() * 95.0);
        this.func_73729_b(this.field_147003_i + 18, this.field_147009_r + 101 - heat, 202, 95 - heat, 6, heat);
        int coolant = (int)Math.round((double)((Accelerator)this.multiblock).tanks.get(0).getFluidAmount() / (double)((Accelerator)this.multiblock).tanks.get(0).getCapacity() * 95.0);
        this.func_73729_b(this.field_147003_i + 28, this.field_147009_r + 101 - coolant, 208, 95 - coolant, 6, coolant);
        this.guiParticle.drawParticleStack(((Accelerator)this.multiblock).beams.get(1).getParticleStack(), this.field_147003_i + 40, this.field_147009_r + 21);
    }

    public void renderTooltips(int mouseX, int mouseY) {
        if (NCUtil.isModifierKeyDown()) {
            this.drawTooltip(this.clearAllInfo(), mouseX, mouseY, 150, 20, 18, 18);
        }
        this.drawTooltip(this.energyInfo(), mouseX, mouseY, 8, 5, 8, 96);
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, 18, 5, 8, 96);
        this.drawTooltip(this.coolantInfo(), mouseX, mouseY, 28, 5, 8, 96);
        this.guiParticle.drawToolTipBoxwithFocus(((Accelerator)this.multiblock).beams.get(1).getParticleStack(), this.field_147003_i + 40, this.field_147009_r + 21, mouseX, mouseY);
    }

    public List<String> heatInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.container.heat_stored", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).heatBuffer.getHeatStored(), "H"), Units.getSIFormat(((Accelerator)this.multiblock).heatBuffer.getHeatCapacity(), "H")}));
        info.add(TextFormatting.BLUE + Lang.localise((String)"gui.qmd.container.cooling", (Object[])new Object[]{Units.getSIFormat(-((Accelerator)this.multiblock).cooling, "H/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.heating", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).currentHeating, "H/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.max_heating", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).rawHeating + ((Accelerator)this.multiblock).getMaxExternalHeating(), "H/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.external_heating", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).getMaxExternalHeating(), "H/t")}));
        return info;
    }

    public List<String> energyInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.container.energy_stored", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).energyStorage.getEnergyStored(), "RF"), Units.getSIFormat(((Accelerator)this.multiblock).energyStorage.getMaxEnergyStored(), "RF")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.required_energy", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).requiredEnergy, "RF/t")}) + Lang.localise((String)"gui.qmd.container.accelerator.efficiency", (Object[])new Object[]{String.format("%.2f", 1.0 / ((Accelerator)this.multiblock).efficiency * 100.0)}));
        return info;
    }

    public List<String> coolantInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.container.coolant_stored", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).tanks.get(0).getFluidAmount(), -3, "B"), Units.getSIFormat(((Accelerator)this.multiblock).tanks.get(0).getCapacity(), -3, "B")}));
        info.add(TextFormatting.BLUE + Lang.localise((String)"gui.qmd.container.max_coolant_in", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).maxCoolantIn, -6, "B/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.max_coolant_out", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).maxCoolantOut, -6, "B/t")}));
        return info;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new MultiblockButton.ClearAllMaterial(0, this.field_147003_i + 150, this.field_147009_r + 20));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (((Accelerator)this.multiblock).WORLD.field_72995_K && guiButton.field_146127_k == 0 && NCUtil.isModifierKeyDown()) {
            PacketHandler.instance.sendToServer((IMessage)new ClearAllMaterialPacket(((TileLinearAcceleratorController)this.tile).getTilePos()));
        }
    }
}

