/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock.gui;

import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.MassSpectrometerLogic;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileMassSpectrometerController;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.ClearTankPacket;
import lach_01298.qmd.network.QMDPacketHandler;
import lach_01298.qmd.util.Units;
import nc.gui.element.GuiFluidRenderer;
import nc.gui.element.NCButton;
import nc.multiblock.gui.GuiLogicMultiblock;
import nc.multiblock.gui.element.MultiblockButton;
import nc.multiblock.tile.IMultiblockGuiPart;
import nc.network.PacketHandler;
import nc.network.multiblock.ClearAllMaterialPacket;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiMassSpectrometerController
extends GuiLogicMultiblock<Accelerator, AcceleratorLogic, IAcceleratorPart, AcceleratorUpdatePacket, TileMassSpectrometerController, MassSpectrometerLogic> {
    protected final ResourceLocation gui_texture = new ResourceLocation("qmd:textures/gui/mass_spectrometer_controller.png");

    public GuiMassSpectrometerController(EntityPlayer player, TileMassSpectrometerController controller) {
        super(player, (IMultiblockGuiPart)controller);
        this.field_146999_f = 176;
        this.field_147000_g = 201;
    }

    protected ResourceLocation getGuiTexture() {
        return this.gui_texture;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offset = 8;
        int fontColor = ((Accelerator)this.multiblock).isControllorOn ? -1 : 0xEEAA00;
        String title = Lang.localise((String)"gui.qmd.container.mass_spectrometer_controller.name");
        this.field_146289_q.func_78276_b(title, offset + 40, 4, fontColor);
        String speedMultiplier = Lang.localise((String)"gui.qmd.container.speed", (Object[])new Object[]{String.format("%.2f", ((MassSpectrometerLogic)this.getLogic()).speed)});
        this.field_146289_q.func_78276_b(speedMultiplier, offset, 108, fontColor);
        if (!NCUtil.isModifierKeyDown()) {
            // empty if block
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int power = (int)Math.round((double)((Accelerator)this.multiblock).energyStorage.getEnergyStored() / (double)((Accelerator)this.multiblock).energyStorage.getMaxEnergyStored() * 92.0);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 105 - power, 176, 92 - power, 4, power);
        int heat = (int)Math.round((double)((Accelerator)this.multiblock).heatBuffer.getHeatStored() / (double)((Accelerator)this.multiblock).heatBuffer.getHeatCapacity() * 92.0);
        this.func_73729_b(this.field_147003_i + 15, this.field_147009_r + 105 - heat, 180, 92 - heat, 4, heat);
        int coolant = (int)Math.round((double)((Accelerator)this.multiblock).tanks.get(0).getFluidAmount() / (double)((Accelerator)this.multiblock).tanks.get(0).getCapacity() * 92.0);
        this.func_73729_b(this.field_147003_i + 22, this.field_147009_r + 105 - coolant, 184, 92 - coolant, 4, coolant);
        int progress = Math.min((int)Math.round(((MassSpectrometerLogic)this.getLogic()).workDone / ((MassSpectrometerLogic)this.getLogic()).recipeWork * 101.0), 101);
        this.func_73729_b(this.field_147003_i + 52, this.field_147009_r + 51, 0, 201, progress, 55);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)((Accelerator)this.multiblock).tanks.get(2)), (double)(this.field_147003_i + 46), (double)(this.field_147009_r + 33), (double)this.field_73735_i, (double)16.0, (double)16.0);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)((Accelerator)this.multiblock).tanks.get(3)), (double)(this.field_147003_i + 82), (double)(this.field_147009_r + 33), (double)this.field_73735_i, (double)16.0, (double)16.0);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)((Accelerator)this.multiblock).tanks.get(4)), (double)(this.field_147003_i + 101), (double)(this.field_147009_r + 33), (double)this.field_73735_i, (double)16.0, (double)16.0);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)((Accelerator)this.multiblock).tanks.get(5)), (double)(this.field_147003_i + 120), (double)(this.field_147009_r + 33), (double)this.field_73735_i, (double)16.0, (double)16.0);
        GuiFluidRenderer.renderGuiTank((FluidTank)((FluidTank)((Accelerator)this.multiblock).tanks.get(6)), (double)(this.field_147003_i + 139), (double)(this.field_147009_r + 33), (double)this.field_73735_i, (double)16.0, (double)16.0);
    }

    public void renderTooltips(int mouseX, int mouseY) {
        if (NCUtil.isModifierKeyDown()) {
            this.drawTooltip(this.clearAllInfo(), mouseX, mouseY, 30, 80, 18, 18);
        }
        this.drawFluidTooltip(((Accelerator)this.multiblock).tanks.get(2), mouseX, mouseY, 46, 33, 16, 16);
        this.drawFluidTooltip(((Accelerator)this.multiblock).tanks.get(3), mouseX, mouseY, 82, 33, 16, 16);
        this.drawFluidTooltip(((Accelerator)this.multiblock).tanks.get(4), mouseX, mouseY, 101, 33, 16, 16);
        this.drawFluidTooltip(((Accelerator)this.multiblock).tanks.get(5), mouseX, mouseY, 120, 33, 16, 16);
        this.drawFluidTooltip(((Accelerator)this.multiblock).tanks.get(6), mouseX, mouseY, 139, 33, 16, 16);
        this.drawTooltip(this.energyInfo(), mouseX, mouseY, 7, 12, 6, 94);
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, 14, 12, 6, 94);
        this.drawTooltip(this.coolantInfo(), mouseX, mouseY, 21, 12, 6, 94);
    }

    public List<String> energyInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.container.energy_stored", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).energyStorage.getEnergyStored(), "RF"), Units.getSIFormat(((Accelerator)this.multiblock).energyStorage.getMaxEnergyStored(), "RF")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.required_energy", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).requiredEnergy, "RF/t")}));
        return info;
    }

    public List<String> heatInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.container.heat_stored", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).heatBuffer.getHeatStored(), "H"), Units.getSIFormat(((Accelerator)this.multiblock).heatBuffer.getHeatCapacity(), "H")}));
        info.add(Lang.localise((String)"gui.qmd.container.temperature", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).getTemperature(), "K")}));
        info.add(Lang.localise((String)"gui.qmd.container.max_temperature", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).maxOperatingTemp, "K")}));
        info.add(TextFormatting.BLUE + Lang.localise((String)"gui.qmd.container.cooling", (Object[])new Object[]{Units.getSIFormat(-((Accelerator)this.multiblock).cooling, "H/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.heating", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).currentHeating, "H/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.max_heating", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).rawHeating + ((Accelerator)this.multiblock).getMaxExternalHeating(), "H/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.external_heating", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).getMaxExternalHeating(), "H/t")}));
        return info;
    }

    public List<String> coolantInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.container.coolant_stored", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).tanks.get(0).getFluidAmount(), -3, "B"), Units.getSIFormat(((Accelerator)this.multiblock).tanks.get(0).getCapacity(), -3, "B")}));
        info.add(TextFormatting.BLUE + Lang.localise((String)"gui.qmd.container.max_coolant_in", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).maxCoolantIn, -6, "B/t")}));
        info.add(TextFormatting.RED + Lang.localise((String)"gui.qmd.container.max_coolant_out", (Object[])new Object[]{Units.getSIFormat(((Accelerator)this.multiblock).maxCoolantOut, -6, "B/t")}));
        return info;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.renderTooltips(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new MultiblockButton.ClearAllMaterial(0, this.field_147003_i + 30, this.field_147009_r + 80));
        this.field_146292_n.add(new NCButton.EmptyTank(1, this.field_147003_i + 46, this.field_147009_r + 33, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(2, this.field_147003_i + 82, this.field_147009_r + 33, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(3, this.field_147003_i + 101, this.field_147009_r + 33, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(4, this.field_147003_i + 120, this.field_147009_r + 33, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(5, this.field_147003_i + 139, this.field_147009_r + 33, 16, 16));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (((Accelerator)this.multiblock).WORLD.field_72995_K && NCUtil.isModifierKeyDown()) {
            switch (guiButton.field_146127_k) {
                case 0: {
                    PacketHandler.instance.sendToServer((IMessage)new ClearAllMaterialPacket(((TileMassSpectrometerController)this.tile).getTilePos()));
                    break;
                }
                case 1: {
                    QMDPacketHandler.instance.sendToServer((IMessage)new ClearTankPacket(((TileMassSpectrometerController)this.tile).getTilePos(), 2));
                    break;
                }
                case 2: {
                    QMDPacketHandler.instance.sendToServer((IMessage)new ClearTankPacket(((TileMassSpectrometerController)this.tile).getTilePos(), 3));
                    break;
                }
                case 3: {
                    QMDPacketHandler.instance.sendToServer((IMessage)new ClearTankPacket(((TileMassSpectrometerController)this.tile).getTilePos(), 4));
                    break;
                }
                case 4: {
                    QMDPacketHandler.instance.sendToServer((IMessage)new ClearTankPacket(((TileMassSpectrometerController)this.tile).getTilePos(), 5));
                    break;
                }
                case 5: {
                    QMDPacketHandler.instance.sendToServer((IMessage)new ClearTankPacket(((TileMassSpectrometerController)this.tile).getTilePos(), 6));
                }
            }
        }
    }
}

