/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.util.ByteUtil;
import nc.network.multiblock.MultiblockUpdatePacket;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import net.minecraft.util.math.BlockPos;

public abstract class AcceleratorUpdatePacket
extends MultiblockUpdatePacket {
    public boolean isAcceleratorOn;
    public long cooling;
    public long rawHeating;
    public long currentHeating;
    public int maxCoolantIn;
    public int maxCoolantOut;
    public int maxOperatingTemp;
    public int requiredEnergy;
    public double efficiency;
    public double quadrupoleStrength;
    public double dipoleStrength;
    public int quadrupoleNumber;
    public int RFCavityNumber;
    public int acceleratingVoltage;
    public int dipoleNumber;
    public HeatBuffer heatBuffer;
    public EnergyStorage energyStorage;
    public byte numberOfTanks;
    public List<Tank.TankInfo> tanksInfo;
    public List<ParticleStorageAccelerator> beams;
    public int errorCode;

    public AcceleratorUpdatePacket() {
        this.beams = new ArrayList<ParticleStorageAccelerator>();
    }

    public AcceleratorUpdatePacket(BlockPos pos, boolean isAcceleratorOn, long cooling, long rawHeating, long currentHeating, int maxCoolantIn, int maxCoolantOut, int maxOperatingTemp, int requiredEnergy, double efficiency, int acceleratingVoltage, int RFCavityNumber, int quadrupoleNumber, double quadrupoleStrength, int dipoleNumber, double dipoleStrength, int errorCode, HeatBuffer heatBuffer, EnergyStorage energyStorage, List<Tank> tanks, List<ParticleStorageAccelerator> beams) {
        this.pos = pos;
        this.isAcceleratorOn = isAcceleratorOn;
        this.cooling = cooling;
        this.rawHeating = rawHeating;
        this.currentHeating = currentHeating;
        this.maxCoolantIn = maxCoolantIn;
        this.maxCoolantOut = maxCoolantOut;
        this.maxOperatingTemp = maxOperatingTemp;
        this.requiredEnergy = requiredEnergy;
        this.efficiency = efficiency;
        this.acceleratingVoltage = acceleratingVoltage;
        this.RFCavityNumber = RFCavityNumber;
        this.quadrupoleNumber = quadrupoleNumber;
        this.quadrupoleStrength = quadrupoleStrength;
        this.dipoleNumber = dipoleNumber;
        this.dipoleStrength = dipoleStrength;
        this.errorCode = errorCode;
        this.heatBuffer = heatBuffer;
        this.energyStorage = energyStorage;
        this.numberOfTanks = (byte)tanks.size();
        this.tanksInfo = Tank.TankInfo.infoList(tanks);
        this.beams = beams;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isAcceleratorOn = buf.readBoolean();
        this.cooling = buf.readLong();
        this.rawHeating = buf.readLong();
        this.currentHeating = buf.readLong();
        this.maxCoolantIn = buf.readInt();
        this.maxCoolantOut = buf.readInt();
        this.maxOperatingTemp = buf.readInt();
        this.requiredEnergy = buf.readInt();
        this.efficiency = buf.readDouble();
        this.acceleratingVoltage = buf.readInt();
        this.RFCavityNumber = buf.readInt();
        this.quadrupoleNumber = buf.readInt();
        this.quadrupoleStrength = buf.readDouble();
        this.dipoleNumber = buf.readInt();
        this.dipoleStrength = buf.readDouble();
        this.errorCode = buf.readInt();
        this.heatBuffer = ByteUtil.readBufHeat(buf);
        this.energyStorage = ByteUtil.readBufEnergy(buf);
        this.numberOfTanks = buf.readByte();
        this.tanksInfo = Tank.TankInfo.readBuf((ByteBuf)buf, (byte)this.numberOfTanks);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ParticleStorage storage = ByteUtil.readBufBeam(buf);
            ParticleStorageAccelerator beam = new ParticleStorageAccelerator();
            beam.setParticleStack(storage.getParticleStack());
            beam.setMaxEnergy(storage.getMaxEnergy());
            beam.setMinEnergy(storage.getMinEnergy());
            beam.setCapacity(storage.getCapacity());
            this.beams.add(beam);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isAcceleratorOn);
        buf.writeLong(this.cooling);
        buf.writeLong(this.rawHeating);
        buf.writeLong(this.currentHeating);
        buf.writeInt(this.maxCoolantIn);
        buf.writeInt(this.maxCoolantOut);
        buf.writeInt(this.maxOperatingTemp);
        buf.writeInt(this.requiredEnergy);
        buf.writeDouble(this.efficiency);
        buf.writeInt(this.acceleratingVoltage);
        buf.writeInt(this.RFCavityNumber);
        buf.writeInt(this.quadrupoleNumber);
        buf.writeDouble(this.quadrupoleStrength);
        buf.writeInt(this.dipoleNumber);
        buf.writeDouble(this.dipoleStrength);
        buf.writeInt(this.errorCode);
        ByteUtil.writeBufHeat(this.heatBuffer, buf);
        ByteUtil.writeBufEnergy(this.energyStorage, buf);
        buf.writeByte((int)this.numberOfTanks);
        for (Tank.TankInfo info : this.tanksInfo) {
            info.writeBuf(buf);
        }
        buf.writeInt(this.beams.size());
        for (ParticleStorageAccelerator beam : this.beams) {
            ByteUtil.writeBufBeam(beam, buf);
        }
    }
}

