/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import lach_01298.qmd.multiblock.network.VacuumChamberUpdatePacket;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.util.ByteUtil;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileNucleosynthesisChamberController;
import nc.network.multiblock.MultiblockUpdatePacket;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import net.minecraft.util.math.BlockPos;

public class NucleosynthesisChamberUpdatePacket
extends VacuumChamberUpdatePacket {
    public long particleWorkDone;
    public long recipeParticleWork;
    public double casingHeating;
    public long casingCooling;
    public int maxCasingCoolantIn;
    public int maxCasingCoolantOut;
    public HeatBuffer casingHeatBuffer;

    public NucleosynthesisChamberUpdatePacket() {
    }

    public NucleosynthesisChamberUpdatePacket(BlockPos pos, boolean isContainmentOn, long heating, long currentHeating, int maxCoolantIn, int maxCoolantOut, int maxOperatingTemp, int requiredEnergy, HeatBuffer heatBuffer, EnergyStorage energyStorage, List<Tank> tanks, List<ParticleStorageAccelerator> beams, long particleWorkDone, long recipeParticleWork, double casingHeating, long casingCooling, int maxCasingCoolantIn, int maxCasingCoolantOut, HeatBuffer casingHeatBuffer) {
        super(pos, isContainmentOn, heating, currentHeating, maxCoolantIn, maxCoolantOut, maxOperatingTemp, requiredEnergy, heatBuffer, energyStorage, tanks, beams);
        this.particleWorkDone = particleWorkDone;
        this.recipeParticleWork = recipeParticleWork;
        this.casingHeating = casingHeating;
        this.casingCooling = casingCooling;
        this.maxCasingCoolantIn = maxCasingCoolantIn;
        this.maxCasingCoolantOut = maxCasingCoolantOut;
        this.casingHeatBuffer = casingHeatBuffer;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.particleWorkDone = buf.readLong();
        this.recipeParticleWork = buf.readLong();
        this.casingHeating = buf.readDouble();
        this.casingCooling = buf.readLong();
        this.maxCasingCoolantIn = buf.readInt();
        this.maxCasingCoolantOut = buf.readInt();
        this.casingHeatBuffer = ByteUtil.readBufHeat(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeLong(this.particleWorkDone);
        buf.writeLong(this.recipeParticleWork);
        buf.writeDouble(this.casingHeating);
        buf.writeLong(this.casingCooling);
        buf.writeInt(this.maxCasingCoolantIn);
        buf.writeInt(this.maxCasingCoolantOut);
        ByteUtil.writeBufHeat(this.casingHeatBuffer, buf);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<VacuumChamber, IVacuumChamberPart, VacuumChamberUpdatePacket, TileNucleosynthesisChamberController, NucleosynthesisChamberUpdatePacket> {
        public Handler() {
            super(TileNucleosynthesisChamberController.class);
        }

        protected void onPacket(NucleosynthesisChamberUpdatePacket message, VacuumChamber multiblock) {
            multiblock.onMultiblockUpdatePacket(message);
        }
    }
}

