/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.network;

import io.netty.buffer.ByteBuf;
import lach_01298.qmd.QMD;
import lach_01298.qmd.entity.EntityBeamProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BeamProjectileUpdatePacket
implements IMessage {
    public int entityId;
    public int ownerEntityId;
    public double length;
    public boolean mainHand;
    public boolean validMessage;

    public BeamProjectileUpdatePacket() {
        this.validMessage = false;
    }

    public BeamProjectileUpdatePacket(EntityBeamProjectile projectile) {
        this.entityId = projectile.func_145782_y();
        if (projectile.getOwner() != null) {
            this.ownerEntityId = projectile.getOwner().func_145782_y();
            this.length = projectile.getLength();
            this.mainHand = projectile.getHand() == EnumHand.MAIN_HAND;
            this.validMessage = true;
        } else {
            this.validMessage = false;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.ownerEntityId = buf.readInt();
        this.length = buf.readDouble();
        this.mainHand = buf.readBoolean();
        this.validMessage = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.ownerEntityId);
        buf.writeDouble(this.length);
        buf.writeBoolean(this.mainHand);
        buf.writeBoolean(this.validMessage);
    }

    public static class Handler
    implements IMessageHandler<BeamProjectileUpdatePacket, IMessage> {
        public IMessage onMessage(BeamProjectileUpdatePacket message, MessageContext ctx) {
            if (ctx.side.isClient() && message.validMessage) {
                EntityPlayer player = QMD.proxy.getPlayerClient();
                if (player.field_70170_p.func_73045_a(message.entityId) instanceof EntityBeamProjectile) {
                    EntityBeamProjectile beam = (EntityBeamProjectile)player.field_70170_p.func_73045_a(message.entityId);
                    if (player.field_70170_p.func_73045_a(message.ownerEntityId) instanceof EntityPlayer) {
                        beam.setOwner((EntityPlayer)player.field_70170_p.func_73045_a(message.ownerEntityId));
                        beam.setLength(message.length);
                        if (message.mainHand) {
                            beam.setHand(EnumHand.MAIN_HAND);
                        } else {
                            beam.setHand(EnumHand.OFF_HAND);
                        }
                    }
                }
            }
            return null;
        }
    }
}

