/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particle;

import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.Particles;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;

public class ParticleStack {
    private Particle particle;
    private int amount;
    private long meanEnergy;
    private double focus;

    public ParticleStack() {
        this.particle = null;
        this.amount = 0;
        this.meanEnergy = 0L;
        this.focus = 0.0;
    }

    public ParticleStack(Particle particle, int amount, long meanEnergy, double focus) {
        this.particle = particle;
        this.amount = (int)NCMath.clamp((long)amount, (long)0L, (long)Integer.MAX_VALUE);
        this.meanEnergy = NCMath.clamp((long)meanEnergy, (long)0L, (long)Long.MAX_VALUE);
        this.focus = focus;
    }

    public ParticleStack(Particle particle, int amount, long meanEnergy) {
        this.particle = particle;
        this.meanEnergy = NCMath.clamp((long)meanEnergy, (long)0L, (long)Long.MAX_VALUE);
        this.amount = (int)NCMath.clamp((long)amount, (long)0L, (long)Integer.MAX_VALUE);
        this.focus = 0.0;
    }

    public ParticleStack(Particle particle, int amount) {
        this.particle = particle;
        this.amount = (int)NCMath.clamp((long)amount, (long)0L, (long)Integer.MAX_VALUE);
        this.meanEnergy = 0L;
        this.focus = 0.0;
    }

    public ParticleStack(Particle particle) {
        this.particle = particle;
        this.amount = 1;
        this.meanEnergy = 0L;
        this.focus = 0.0;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public long getMeanEnergy() {
        return this.meanEnergy;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getFocus() {
        return this.focus;
    }

    public void setParticle(Particle newParticle) {
        this.particle = newParticle;
    }

    public void setMeanEnergy(long newMeanEnergy) {
        this.meanEnergy = newMeanEnergy;
    }

    public void addMeanEnergy(long add) {
        this.meanEnergy += add;
    }

    public void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public void addAmount(long add) {
        this.amount = (int)((long)this.amount + add);
    }

    public void removeAmount(long remove) {
        this.amount = (int)((long)this.amount - remove);
        if (this.amount < 0) {
            this.amount = 0;
            this.particle = null;
        }
    }

    public void setFocus(double newFocus) {
        this.focus = newFocus;
    }

    public void addFocus(double add) {
        this.focus += add;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.particle != null) {
            nbt.func_74778_a("particle", this.particle.getName());
        }
        nbt.func_74768_a("amount", this.amount);
        nbt.func_74772_a("meanEnergy", this.meanEnergy);
        nbt.func_74780_a("focus", this.focus);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.particle = nbt.func_74764_b("particle") ? Particles.getParticleFromName(nbt.func_74779_i("particle")) : null;
        this.amount = nbt.func_74762_e("amount");
        this.meanEnergy = nbt.func_74763_f("meanEnergy");
        this.focus = nbt.func_74769_h("focus");
    }

    public ParticleStack copy() {
        return new ParticleStack(this.particle, this.amount, this.meanEnergy, this.focus);
    }

    public static ParticleStack loadParticleStackFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.func_150297_b("particle", 8)) {
            return null;
        }
        String particleName = nbt.func_74779_i("particle");
        int amount = nbt.func_74762_e("amount");
        long energy = nbt.func_74763_f("meanEnergy");
        double focus = nbt.func_74769_h("focus");
        ParticleStack beam = new ParticleStack(Particles.getParticleFromName(particleName), amount, energy, focus);
        return beam;
    }

    public static ParticleStack getParticleStack(String particleName, int amount, long meanEnergy, double focus) {
        return new ParticleStack(Particles.getParticleFromName(particleName), amount, meanEnergy, focus);
    }

    public boolean matchesType(ParticleStack particleStack) {
        return particleStack != null && particleStack.getParticle() == this.particle;
    }

    public boolean isInRange(ParticleStack particleStack, long maxEnergy) {
        return particleStack != null && particleStack.getParticle() == this.particle && particleStack.getFocus() >= this.focus - QMDConfig.beamAttenuationRate / 10.0 && particleStack.getMeanEnergy() >= this.meanEnergy && particleStack.getMeanEnergy() <= maxEnergy;
    }
}

