/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.InventoryHelper;
import lach_01298.qmd.multiblock.network.ParticleChamberUpdatePacket;
import lach_01298.qmd.multiblock.network.TargetChamberUpdatePacket;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.ParticleChamberLogic;
import lach_01298.qmd.particleChamber.tile.IParticleChamberPart;
import lach_01298.qmd.particleChamber.tile.TileParticleChamber;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeam;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeamPort;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberDetector;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberEnergyPort;
import lach_01298.qmd.particleChamber.tile.TileTargetChamberController;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.util.Equations;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.ITile;
import nc.tile.internal.fluid.Tank;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TargetChamberLogic
extends ParticleChamberLogic {
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public QMDRecipeInfo<QMDRecipe> rememberedRecipeInfo;
    protected TileParticleChamber mainChamber;
    public long particleWorkDone = 0L;
    public long recipeParticleWork = 100L;
    public boolean outputSwitched = false;
    public static final List<Pair<Class<? extends IParticleChamberPart>, String>> PART_BLACKLIST = new ArrayList<Pair<Class<? extends IParticleChamberPart>, String>>();

    public TargetChamberLogic(ParticleChamberLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "target_chamber";
    }

    @Override
    public boolean isMachineWhole() {
        if (this.getMultiblock().getExteriorLengthX() != this.getMultiblock().getExteriorLengthZ()) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_square", null, new Object[0]);
            return false;
        }
        if (this.getMultiblock().getExteriorLengthX() % 2 != 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_odd", null, new Object[0]);
            return false;
        }
        BlockPos middle = this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(this.getMultiblock().getExteriorLengthX() / 2, this.getMultiblock().getExteriorLengthY() / 2, this.getMultiblock().getExteriorLengthZ() / 2);
        if (!(this.getMultiblock().WORLD.func_175625_s(middle) instanceof TileParticleChamber)) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_have_target", middle, new Object[0]);
            return false;
        }
        TileParticleChamber target = (TileParticleChamber)this.getMultiblock().WORLD.func_175625_s(middle);
        int ports = 0;
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (!(this.getMultiblock().WORLD.func_175625_s(middle.func_177967_a(face, this.getMultiblock().getExteriorLengthX() / 2)) instanceof TileParticleChamberBeamPort)) continue;
            ++ports;
            for (int i = 1; i <= this.getMultiblock().getExteriorLengthX() / 2 - 1; ++i) {
                if (this.getMultiblock().WORLD.func_175625_s(middle.func_177967_a(face, i)) instanceof TileParticleChamberBeam) continue;
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_beam", middle.func_177967_a(face, i), new Object[0]);
                return false;
            }
        }
        if (ports != this.getPartMap(TileParticleChamberBeamPort.class).size()) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.beam_port_wrong_spot", null, new Object[0]);
            return false;
        }
        int inputs = 0;
        for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            if (tile.getIOType() != EnumTypes.IOType.INPUT) continue;
            ++inputs;
        }
        if (inputs != 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_have_input_beam", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileParticleChamberEnergyPort.class).size() < 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return !this.containsBlacklistedPart();
    }

    @Override
    public int getMinimumInteriorLength() {
        return 1;
    }

    @Override
    public List<Pair<Class<? extends IParticleChamberPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }

    @Override
    public void onChamberFormed() {
        this.onResetStats();
        this.getMultiblock().tanks.get(0).setCapacity(QMDConfig.particle_chamber_input_tank_capacity);
        this.getMultiblock().tanks.get(1).setCapacity(QMDConfig.particle_chamber_output_tank_capacity * this.getCapacityMultiplier());
        if (!this.getWorld().field_72995_K) {
            TileParticleChamberBeamPort port;
            ObjectIterator objectIterator = this.getPartMap(TileParticleChamber.class).values().iterator();
            while (objectIterator.hasNext()) {
                TileParticleChamber target;
                this.mainChamber = target = (TileParticleChamber)objectIterator.next();
            }
            for (TileParticleChamberDetector detector : this.getPartMap(TileParticleChamberDetector.class).values()) {
                this.getMultiblock().requiredEnergy += detector.basePower;
                if (!detector.isInvalidPostion(this.mainChamber.func_174877_v())) continue;
                this.getMultiblock().efficiency += detector.efficiency;
            }
            BlockPos input = null;
            for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
                if (tile.getIOType() != EnumTypes.IOType.INPUT) continue;
                tile.setIONumber(0);
                input = tile.func_174877_v();
            }
            int distance = this.getMultiblock().getExteriorLengthX() / 2;
            EnumFacing facing = null;
            if (this.mainChamber.func_174877_v().func_177958_n() == input.func_177958_n()) {
                facing = input.func_177952_p() > this.mainChamber.func_174877_v().func_177952_p() ? EnumFacing.SOUTH : EnumFacing.NORTH;
            } else if (this.mainChamber.func_174877_v().func_177952_p() == input.func_177952_p()) {
                facing = input.func_177958_n() > this.mainChamber.func_174877_v().func_177958_n() ? EnumFacing.EAST : EnumFacing.WEST;
            }
            if (this.getWorld().func_175625_s(this.mainChamber.func_174877_v().func_177967_a(facing.func_176746_e(), distance)) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getWorld().func_175625_s(this.mainChamber.func_174877_v().func_177967_a(facing.func_176746_e(), distance));
                if (this.outputSwitched) {
                    port.setIONumber(3);
                } else {
                    port.setIONumber(1);
                }
            }
            if (this.getWorld().func_175625_s(this.mainChamber.func_174877_v().func_177967_a(facing.func_176746_e().func_176746_e(), distance)) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getWorld().func_175625_s(this.mainChamber.func_174877_v().func_177967_a(facing.func_176746_e().func_176746_e(), distance));
                port.setIONumber(2);
            }
            if (this.getWorld().func_175625_s(this.mainChamber.func_174877_v().func_177967_a(facing.func_176746_e().func_176746_e().func_176746_e(), distance)) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getWorld().func_175625_s(this.mainChamber.func_174877_v().func_177967_a(facing.func_176746_e().func_176746_e().func_176746_e(), distance));
                if (this.outputSwitched) {
                    port.setIONumber(1);
                } else {
                    port.setIONumber(3);
                }
            }
        }
        super.onChamberFormed();
    }

    @Override
    public void onMachineDisassembled() {
        this.mainChamber = null;
        for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            tile.setIONumber(0);
        }
        super.onMachineDisassembled();
    }

    @Override
    public boolean onUpdateServer() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.pull();
        if (this.isChamberOn()) {
            if (this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
                this.refreshRecipe();
                if (this.recipeInfo != null) {
                    if (this.rememberedRecipeInfo != null && this.rememberedRecipeInfo.getRecipe() != this.recipeInfo.getRecipe()) {
                        this.particleWorkDone = 0L;
                    }
                    this.rememberedRecipeInfo = this.recipeInfo;
                    if (this.canProduceProduct()) {
                        this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
                        this.particleWorkDone += (long)this.getMultiblock().beams.get(0).getParticleStack().getAmount();
                        this.produceProduct();
                        this.produceBeams();
                    } else {
                        this.resetBeams();
                    }
                } else {
                    this.resetBeams();
                }
            } else {
                this.resetBeams();
            }
        } else {
            this.resetBeams();
        }
        this.push();
        return super.onUpdateServer();
    }

    @Override
    public boolean toggleSetting(BlockPos pos, int ioNumber) {
        if (ioNumber == 0 || ioNumber == 2) {
            return false;
        }
        if (this.getWorld().func_175625_s(pos) instanceof TileParticleChamberBeamPort) {
            this.outputSwitched = !this.outputSwitched;
            TileParticleChamberBeamPort port = (TileParticleChamberBeamPort)this.getWorld().func_175625_s(pos);
            if (port.getIONumber() == 1) {
                port.setIONumber(3);
            } else if (port.getIONumber() == 3) {
                port.setIONumber(1);
            }
            EnumFacing facing = null;
            if (this.mainChamber.func_174877_v().func_177958_n() == port.func_174877_v().func_177958_n()) {
                facing = port.func_174877_v().func_177952_p() > this.mainChamber.func_174877_v().func_177952_p() ? EnumFacing.NORTH : EnumFacing.SOUTH;
            } else if (this.mainChamber.func_174877_v().func_177952_p() == port.func_174877_v().func_177952_p()) {
                facing = port.func_174877_v().func_177958_n() > this.mainChamber.func_174877_v().func_177958_n() ? EnumFacing.WEST : EnumFacing.EAST;
            }
            if (this.getWorld().func_175625_s(port.func_174877_v().func_177967_a(facing, this.getMultiblock().getExteriorLengthX() - 1)) instanceof TileParticleChamberBeamPort) {
                TileParticleChamberBeamPort port2 = (TileParticleChamberBeamPort)this.getWorld().func_175625_s(port.func_174877_v().func_177967_a(facing, this.getMultiblock().getExteriorLengthX() - 1));
                if (port2.getIONumber() == 1) {
                    port2.setIONumber(3);
                } else if (port2.getIONumber() == 3) {
                    port2.setIONumber(1);
                }
            }
            return true;
        }
        return false;
    }

    private boolean canProduceProduct() {
        TileTargetChamberController inv = (TileTargetChamberController)this.getMultiblock().controller;
        ItemStack productItem = (ItemStack)this.recipeInfo.getRecipe().getItemProducts().get(0).getStack();
        FluidStack productFluid = (FluidStack)this.recipeInfo.getRecipe().getFluidProducts().get(0).getStack();
        if (((ItemStack)inv.getInventoryStacks().get(1)).func_190916_E() <= 0) {
            inv.getInventoryStacks().set(1, (Object)ItemStack.field_190927_a);
        }
        if (productItem != null) {
            if (!((ItemStack)inv.getInventoryStacks().get(1)).func_77969_a(productItem) && inv.getInventoryStacks().get(1) != ItemStack.field_190927_a) {
                return false;
            }
            if (((ItemStack)inv.getInventoryStacks().get(1)).func_190916_E() + productItem.func_190916_E() > productItem.func_77976_d()) {
                return false;
            }
        }
        return productFluid == null || this.getMultiblock().tanks.get(1).fill(productFluid, false) == productFluid.amount;
    }

    private void produceProduct() {
        this.recipeParticleWork = (long)Math.max(this.recipeInfo.getRecipe().getCrossSection() * (double)((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getAmount(), (double)((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getAmount() / this.getMultiblock().efficiency);
        this.particleWorkDone = Math.min(this.particleWorkDone, this.recipeParticleWork * 64L);
        while (this.particleWorkDone >= this.recipeParticleWork && this.canProduceProduct()) {
            TileTargetChamberController inv = (TileTargetChamberController)this.getMultiblock().controller;
            ItemStack productItem = (ItemStack)this.recipeInfo.getRecipe().getItemProducts().get(0).getStack();
            if (productItem == null) {
                productItem = ItemStack.field_190927_a;
            } else {
                productItem.func_190920_e(this.recipeInfo.getRecipe().getItemProducts().get(0).getNextStackSize(0));
            }
            InventoryHelper.addItem(1, productItem, inv.getInventoryStacks(), (ITile)inv);
            InventoryHelper.removeItem(0, this.recipeInfo.getRecipe().getItemIngredients().get(0).getMaxStackSize(0), inv.getInventoryStacks(), (ITile)inv);
            FluidStack productFluid = (FluidStack)this.recipeInfo.getRecipe().getFluidProducts().get(0).getStack();
            FluidStack ingredientFluid = (FluidStack)this.recipeInfo.getRecipe().getFluidIngredients().get(0).getStack();
            if (productFluid != null) {
                productFluid.amount = this.recipeInfo.getRecipe().getFluidProducts().get(0).getNextStackSize(0);
                this.getMultiblock().tanks.get(1).fill(productFluid, true);
            }
            if (ingredientFluid != null) {
                this.getMultiblock().tanks.get(0).drain(ingredientFluid, true);
            }
            this.particleWorkDone = Math.max(0L, this.particleWorkDone - this.recipeParticleWork);
        }
    }

    public void onResetStats() {
        this.getMultiblock().efficiency = 1.0;
        this.getMultiblock().requiredEnergy = QMDConfig.target_chamber_power;
    }

    private void produceBeams() {
        ParticleStack input = this.getMultiblock().beams.get(0).getParticleStack();
        ParticleStack outputPlus = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(0).getStack();
        ParticleStack outputNeutral = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(1).getStack();
        ParticleStack outputMinus = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(2).getStack();
        long energyReleased = this.recipeInfo.getRecipe().getEnergyReleased();
        double crossSection = this.recipeInfo.getRecipe().getCrossSection();
        double outputFactor = crossSection * this.getMultiblock().efficiency;
        if (outputFactor >= 1.0) {
            outputFactor = 1.0;
        }
        int particlesOut = 0;
        if (outputPlus != null) {
            particlesOut += outputPlus.getAmount();
        }
        if (outputNeutral != null) {
            particlesOut += outputNeutral.getAmount();
        }
        if (outputMinus != null) {
            particlesOut += outputMinus.getAmount();
        }
        this.getMultiblock().beams.get(1).setParticleStack(outputPlus);
        if (outputPlus != null) {
            this.getMultiblock().beams.get(1).getParticleStack().setMeanEnergy(Math.round((double)(input.getMeanEnergy() + energyReleased) / (double)particlesOut));
            this.getMultiblock().beams.get(1).getParticleStack().setAmount((int)Math.round((double)outputPlus.getAmount() * outputFactor * (double)input.getAmount()));
            this.getMultiblock().beams.get(1).getParticleStack().setFocus(input.getFocus() - Equations.focusLoss((double)this.getBeamLength() / 2.0, input) - Equations.focusLoss((double)this.getBeamLength() / 2.0, this.getMultiblock().beams.get(1).getParticleStack()));
        }
        this.getMultiblock().beams.get(2).setParticleStack(outputNeutral);
        if (outputNeutral != null) {
            this.getMultiblock().beams.get(2).getParticleStack().setMeanEnergy(Math.round((double)(input.getMeanEnergy() + energyReleased) / (double)particlesOut));
            this.getMultiblock().beams.get(2).getParticleStack().setAmount((int)Math.round((double)outputNeutral.getAmount() * outputFactor * (double)input.getAmount()));
            this.getMultiblock().beams.get(2).getParticleStack().setFocus(input.getFocus() - Equations.focusLoss((double)this.getBeamLength() / 2.0, input) - Equations.focusLoss((double)this.getBeamLength() / 2.0, this.getMultiblock().beams.get(2).getParticleStack()));
        }
        this.getMultiblock().beams.get(3).setParticleStack(outputMinus);
        if (outputMinus != null) {
            this.getMultiblock().beams.get(3).getParticleStack().setMeanEnergy(Math.round((double)(input.getMeanEnergy() + energyReleased) / (double)particlesOut));
            this.getMultiblock().beams.get(3).getParticleStack().setAmount((int)Math.round((double)outputMinus.getAmount() * outputFactor * (double)input.getAmount()));
            this.getMultiblock().beams.get(3).getParticleStack().setFocus(input.getFocus() - Equations.focusLoss((double)this.getBeamLength() / 2.0, input) - Equations.focusLoss((double)this.getBeamLength() / 2.0, this.getMultiblock().beams.get(3).getParticleStack()));
        }
    }

    private void resetBeams() {
        this.getMultiblock().beams.get(1).setParticleStack(null);
        this.getMultiblock().beams.get(2).setParticleStack(null);
        this.getMultiblock().beams.get(3).setParticleStack(null);
    }

    protected void refreshRecipe() {
        TileTargetChamberController cont = (TileTargetChamberController)this.getMultiblock().controller;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack item = ((ItemStack)cont.getInventoryStacks().get(0)).func_77946_l();
        items.add(item);
        ArrayList<Tank> tanks = new ArrayList<Tank>();
        tanks.add(this.getMultiblock().tanks.get(0));
        ArrayList<ParticleStack> particles = new ArrayList<ParticleStack>();
        particles.add(this.getMultiblock().beams.get(0).getParticleStack());
        this.recipeInfo = QMDRecipes.target_chamber.getRecipeInfoFromInputs(items, tanks, particles);
    }

    @Override
    public ParticleChamberUpdatePacket getMultiblockUpdatePacket() {
        return new TargetChamberUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isChamberOn, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().energyStorage, this.particleWorkDone, this.recipeParticleWork, this.getMultiblock().tanks, this.getMultiblock().beams);
    }

    @Override
    public void onMultiblockUpdatePacket(ParticleChamberUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof TargetChamberUpdatePacket) {
            TargetChamberUpdatePacket packet = (TargetChamberUpdatePacket)message;
            this.getMultiblock().beams = packet.beams;
            for (int i = 0; i < this.getMultiblock().tanks.size(); ++i) {
                this.getMultiblock().tanks.get(i).readInfo(message.tanksInfo.get(i));
            }
            this.particleWorkDone = packet.particleCount;
            this.recipeParticleWork = packet.recipeParticleCount;
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        logicTag.func_74772_a("particleCount", this.particleWorkDone);
        logicTag.func_74772_a("recipeParticleCount", this.recipeParticleWork);
        logicTag.func_74757_a("outputSwitched", this.outputSwitched);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.particleWorkDone = logicTag.func_74763_f("particleCount");
        this.recipeParticleWork = logicTag.func_74763_f("recipeParticleCount");
        this.outputSwitched = logicTag.func_74767_n("outputSwitched");
    }
}

