/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber.tile;

import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.BlockTypes;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberPart;
import lach_01298.qmd.util.Util;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TileParticleChamberDetector
extends TileParticleChamberPart {
    public final double efficiency;
    public final int basePower;
    public final String name;
    public int taxiDistance;
    public boolean within;
    public boolean isFunctional = false;

    public TileParticleChamberDetector(double efficiency, int basePower, String name) {
        super(CuboidalPartPositionType.INTERIOR);
        this.efficiency = efficiency;
        this.basePower = basePower;
        this.name = name;
    }

    public TileParticleChamberDetector(double efficiency, int basePower, String name, int taxiDistance, boolean within) {
        super(CuboidalPartPositionType.INTERIOR);
        this.efficiency = efficiency;
        this.basePower = basePower;
        this.name = name;
        this.taxiDistance = taxiDistance;
        this.within = within;
    }

    public void onMachineAssembled(ParticleChamber controller) {
        super.onMachineAssembled((CuboidalMultiblock)controller);
    }

    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
    }

    public boolean isInvalidPostion(BlockPos target) {
        return this.within ? Util.getTaxiDistance(target, this.func_174877_v()) <= this.taxiDistance : Util.getTaxiDistance(target, this.func_174877_v()) >= this.taxiDistance;
    }

    public static class HadronCalorimeter
    extends TileParticleChamberDetector {
        public HadronCalorimeter() {
            super(QMDConfig.detector_efficiency[4], QMDConfig.detector_base_power[4], BlockTypes.DetectorType.HADRON_CALORIMETER.func_176610_l());
        }

        @Override
        public boolean isInvalidPostion(BlockPos target) {
            return Util.getTaxiDistance(target, this.func_174877_v()) <= 5;
        }
    }

    public static class EMCalorimeter
    extends TileParticleChamberDetector {
        public EMCalorimeter() {
            super(QMDConfig.detector_efficiency[3], QMDConfig.detector_base_power[3], BlockTypes.DetectorType.EM_CALORIMETER.func_176610_l());
        }

        @Override
        public boolean isInvalidPostion(BlockPos target) {
            return Util.getTaxiDistance(target, this.func_174877_v()) <= 3;
        }
    }

    public static class WireChamber
    extends TileParticleChamberDetector {
        public WireChamber() {
            super(QMDConfig.detector_efficiency[2], QMDConfig.detector_base_power[2], BlockTypes.DetectorType.WIRE_CHAMBER.func_176610_l());
        }

        @Override
        public boolean isInvalidPostion(BlockPos target) {
            return Util.getTaxiDistance(target, this.func_174877_v()) <= 2;
        }
    }

    public static class SiliconTracker
    extends TileParticleChamberDetector {
        public SiliconTracker() {
            super(QMDConfig.detector_efficiency[1], QMDConfig.detector_base_power[1], BlockTypes.DetectorType.SILLICON_TRACKER.func_176610_l());
        }

        @Override
        public boolean isInvalidPostion(BlockPos target) {
            return Util.getTaxiDistance(target, this.func_174877_v()) <= 1;
        }
    }

    public static class BubbleChamber
    extends TileParticleChamberDetector {
        public BubbleChamber() {
            super(QMDConfig.detector_efficiency[0], QMDConfig.detector_base_power[0], BlockTypes.DetectorType.BUBBLE_CHAMBER.func_176610_l());
        }

        @Override
        public boolean isInvalidPostion(BlockPos target) {
            return Util.getTaxiDistance(target, this.func_174877_v()) <= 2;
        }
    }
}

