/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.block.QMDBlocks;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.BlockTypes;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.item.QMDItems;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import lach_01298.qmd.recipes.AcceleratorCoolingRecipes;
import lach_01298.qmd.recipes.AcceleratorSourceRecipes;
import lach_01298.qmd.recipes.AtmosphereCollectorRecipes;
import lach_01298.qmd.recipes.BeamDumpRecipes;
import lach_01298.qmd.recipes.CellFillingRecipes;
import lach_01298.qmd.recipes.CollisionChamberRecipes;
import lach_01298.qmd.recipes.DecayChamberRecipes;
import lach_01298.qmd.recipes.IrradiatorFuel;
import lach_01298.qmd.recipes.IrradiatorRecipes;
import lach_01298.qmd.recipes.MassSpectrometerRecipes;
import lach_01298.qmd.recipes.NeutralContainmentRecipes;
import lach_01298.qmd.recipes.NucleosynthesisChamberRecipes;
import lach_01298.qmd.recipes.OreLeacherRecipes;
import lach_01298.qmd.recipes.QMDCraftingRecipeHandler;
import lach_01298.qmd.recipes.TargetChamberRecipes;
import lach_01298.qmd.recipes.VacuumChamberHeaterRecipes;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCItems;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.FluidRegHelper;
import nc.util.NCMath;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class QMDRecipes {
    private static boolean initialized = false;
    public static AcceleratorSourceRecipes accelerator_source;
    public static AcceleratorCoolingRecipes accelerator_cooling;
    public static MassSpectrometerRecipes mass_spectrometer;
    public static TargetChamberRecipes target_chamber;
    public static DecayChamberRecipes decay_chamber;
    public static BeamDumpRecipes beam_dump;
    public static CollisionChamberRecipes collision_chamber;
    public static OreLeacherRecipes ore_leacher;
    public static IrradiatorRecipes irradiator;
    public static IrradiatorFuel irradiator_fuel;
    public static NeutralContainmentRecipes neutral_containment;
    public static CellFillingRecipes cell_filling;
    public static NucleosynthesisChamberRecipes nucleosynthesis_chamber;
    public static VacuumChamberHeaterRecipes vacuum_chamber_heating;
    public static List<List<String>> accelerator_cooling_valid_fluids;
    public static List<List<String>> accelerator_ion_source_valid_fluids;
    public static List<List<String>> ore_leacher_valid_fluids;
    public static List<List<String>> mass_spectrometer_valid_fluids;
    public static List<List<String>> target_chamber_valid_fluids;
    public static List<List<String>> cell_filling_valid_fluids;
    public static List<List<String>> nucleosynthesis_valid_fluids;
    public static List<List<String>> vacuum_chamber_heater_valid_fluids;
    public static final List<String> PLASTIC_TYPES;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (initialized) {
            return;
        }
        accelerator_source = new AcceleratorSourceRecipes();
        accelerator_cooling = new AcceleratorCoolingRecipes();
        mass_spectrometer = new MassSpectrometerRecipes();
        target_chamber = new TargetChamberRecipes();
        decay_chamber = new DecayChamberRecipes();
        beam_dump = new BeamDumpRecipes();
        collision_chamber = new CollisionChamberRecipes();
        ore_leacher = new OreLeacherRecipes();
        irradiator = new IrradiatorRecipes();
        irradiator_fuel = new IrradiatorFuel();
        neutral_containment = new NeutralContainmentRecipes();
        cell_filling = new CellFillingRecipes();
        vacuum_chamber_heating = new VacuumChamberHeaterRecipes();
        nucleosynthesis_chamber = new NucleosynthesisChamberRecipes();
        QMDRecipes.addRecipes();
        initialized = true;
    }

    public static void init() {
        accelerator_cooling_valid_fluids = RecipeHelper.validFluids((BasicRecipeHandler)accelerator_cooling);
        accelerator_ion_source_valid_fluids = QMDRecipeHelper.validFluids(accelerator_source);
        mass_spectrometer_valid_fluids = RecipeHelper.validFluids((BasicRecipeHandler)mass_spectrometer);
        ore_leacher_valid_fluids = RecipeHelper.validFluids((BasicRecipeHandler)ore_leacher);
        target_chamber_valid_fluids = QMDRecipeHelper.validFluids(target_chamber);
        cell_filling_valid_fluids = RecipeHelper.validFluids((BasicRecipeHandler)cell_filling);
        nucleosynthesis_valid_fluids = QMDRecipeHelper.validFluids(nucleosynthesis_chamber);
        vacuum_chamber_heater_valid_fluids = RecipeHelper.validFluids((BasicRecipeHandler)vacuum_chamber_heating);
    }

    public static void refreshRecipeCaches() {
        accelerator_source.refreshCache();
        accelerator_cooling.refreshCache();
        mass_spectrometer.refreshCache();
        target_chamber.refreshCache();
        decay_chamber.refreshCache();
        beam_dump.refreshCache();
        collision_chamber.refreshCache();
        ore_leacher.refreshCache();
        irradiator.refreshCache();
        irradiator_fuel.refreshCache();
        neutral_containment.refreshCache();
        cell_filling.refreshCache();
        nucleosynthesis_chamber.refreshCache();
        vacuum_chamber_heating.refreshCache();
    }

    public static void addRecipes() {
        String type;
        int i;
        ArrayList<OreIngredient> itemIngredients;
        ArrayList<FluidIngredient> fluidIngredients;
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Steel", 5, "Chromium", 1, "StainlessSteel", 6, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Niobium", 3, "Tin", 1, "NiobiumTin", 4, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Niobium", 1, "Titanium", 1, "NiobiumTitanium", 2, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Tungsten", 1, "Graphite", 1, "TungstenCarbide", 2, 2.0, 2.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Osmium", 1, "Iridium", 1, "Osmiridium", 2, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Nickel", 1, "Chromium", 1, "Nichrome", 2, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Nichrome", 2, "NiobiumTitanium", 1, "SuperAlloy", 3, 1.0, 1.0);
        NCRecipes.alloy_furnace.addRecipe(new Object[]{"dustZinc", "dustSulfur", "dustZincSulfide", 1.0, 1.0});
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Uranium238", 9, "Uranium235", 1, "Uranium", 10, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Boron11", 9, "Boron10", 3, "Boron", 12, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Lithium7", 9, "Lithium6", 1, "Lithium", 10, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Magnesium24", 8, "Magnesium26", 1, "Magnesium", 9, 1.0, 1.0);
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.DETECTOR_CASING.getID()), QMDRecipes.fluidStack("liquid_hydrogen", 1000), new ItemStack(QMDBlocks.particleChamberDetector, 1, BlockTypes.DetectorType.BUBBLE_CHAMBER.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.WIRE_CHAMBER_CASING.getID()), QMDRecipes.fluidStack("argon", 1000), new ItemStack(QMDBlocks.particleChamberDetector, 1, BlockTypes.DetectorType.WIRE_CHAMBER.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.EMPTY_COOLER.getID()), QMDRecipes.fluidStack("water", 1000), new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.WATER.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.EMPTY_COOLER.getID()), QMDRecipes.fluidStack("liquid_helium", 1000), new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.LIQUID_HELIUM.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.EMPTY_COOLER.getID()), QMDRecipes.fluidStack("liquid_nitrogen", 1000), new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.LIQUID_NITROGEN.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.EMPTY_COOLER.getID()), QMDRecipes.fluidStack("cryotheum", 1000), new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.CRYOTHEUM.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.EMPTY_COOLER.getID()), QMDRecipes.fluidStack("enderium", 576), new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.ENDERIUM.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.EMPTY.getID()), QMDRecipes.fluidStack("hydrogen", 250), new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.HYDROGEN.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.EMPTY.getID()), QMDRecipes.fluidStack("helium", 250), new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.HELIUM.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.EMPTY.getID()), QMDRecipes.fluidStack("nitrogen", 250), new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.NITROGEN.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.EMPTY.getID()), QMDRecipes.fluidStack("oxygen", 250), new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.OXYGEN.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.EMPTY.getID()), QMDRecipes.fluidStack("neon", 250), new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.NEON.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.EMPTY.getID()), QMDRecipes.fluidStack("argon", 250), new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.ARGON.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.ARGON.getID()), QMDRecipes.fluidStack("sodium", 144), new ItemStack(QMDBlocks.dischargeLamp2, 1, BlockTypes.LampType2.SODIUM.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{new ItemStack(QMDBlocks.dischargeLamp, 1, BlockTypes.LampType.ARGON.getID()), QMDRecipes.fluidStack("mercury", 144), new ItemStack(QMDBlocks.dischargeLamp2, 1, BlockTypes.LampType2.MERCURY.getID()), 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{"dustStrontium", QMDRecipes.fluidStack("hydrochloric_acid", 2000), "dustStrontiumChloride", 1.0, 1.0});
        NCRecipes.infuser.addOxidizingRecipe("dustCopper", 1000);
        NCRecipes.infuser.addOxidizingRecipe("dustTungsten", 1000);
        NCRecipes.infuser.addOxidizingRecipe("dustHafnium", 1000);
        NCRecipes.enricher.addRecipe(new Object[]{"dustTungstenOxide", QMDRecipes.fluidStack("sodium_hydroxide_solution", 1332), QMDRecipes.fluidStack("sodium_tungstate_solution", 666), 1.0, 1.0});
        NCRecipes.enricher.addRecipe(new Object[]{"dustLead", QMDRecipes.fluidStack("nitric_acid", 1332), QMDRecipes.fluidStack("lead_nitrate_solution", 666), 1.0, 1.0});
        NCRecipes.enricher.addRecipe(new Object[]{"ingotYttrium", QMDRecipes.fluidStack("alumina", 120), QMDRecipes.fluidStack("yag", 48), 2.0, 2.0});
        NCRecipes.enricher.addRecipe(new Object[]{"ingotNeodymium", QMDRecipes.fluidStack("yag", 1296), QMDRecipes.fluidStack("nd_yag", 1296), 2.0, 2.0});
        NCRecipes.enricher.addRecipe(new Object[]{"dustSalt", QMDRecipes.fluidStack("water", 1000), QMDRecipes.fluidStack("sodium_chloride_solution", 666), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("sodium_tungstate_solution", 666), QMDRecipes.fluidStack("lead_nitrate_solution", 666), QMDRecipes.fluidStack("lead_tungstate_solution", 666), QMDRecipes.fluidStack("sodium_nitrate_solution", 666), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("hydrogen", 1000), QMDRecipes.fluidStack("chlorine", 1000), QMDRecipes.fluidStack("hydrochloric_acid", 2000), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("liquidhydrogenchloride", 1000), QMDRecipes.fluidStack("water", 1000), QMDRecipes.fluidStack("hydrochloric_acid", 1000), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("nitrogen", 1000), QMDRecipes.fluidStack("oxygen", 1000), QMDRecipes.fluidStack("nitric_oxide", 2000), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("nitric_oxide", 2000), QMDRecipes.fluidStack("oxygen", 1000), QMDRecipes.fluidStack("nitrogen_dioxide", 2000), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("nitrogen_dioxide", 3000), QMDRecipes.fluidStack("water", 1000), QMDRecipes.fluidStack("nitric_acid", 2000), QMDRecipes.fluidStack("nitric_oxide", 1000), 1.0, 1.0});
        NCRecipes.chemical_reactor.addRecipe(new Object[]{QMDRecipes.fluidStack("sodium_hydroxide_solution", 666), QMDRecipes.fluidStack("nitric_acid", 1000), QMDRecipes.fluidStack("sodium_nitrate_solution", 666), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.separator.addRecipe(new Object[]{AbstractRecipeHandler.oreStackList((List)Lists.newArrayList((Object[])new String[]{"ingotMagnesium", "dustMagnesium"}), (int)9), AbstractRecipeHandler.oreStack((String)"ingotMagnesium24", (int)8), AbstractRecipeHandler.oreStack((String)"ingotMagnesium26", (int)1), 6.0, 1.0});
        NCRecipes.separator.addRecipe(new Object[]{AbstractRecipeHandler.oreStackList((List)Lists.newArrayList((Object[])new String[]{"ingotCalcium", "dustCalcium"}), (int)8), AbstractRecipeHandler.oreStack((String)"ingotCalcium48", (int)1), new EmptyItemIngredient(), 6.0, 1.0});
        NCRecipes.centrifuge.addRecipe(new Object[]{QMDRecipes.fluidStack("compressed_air", 10000), QMDRecipes.fluidStack("nitrogen", 7000), QMDRecipes.fluidStack("oxygen", 2000), QMDRecipes.fluidStack("argon", 750), QMDRecipes.fluidStack("neon", 200), QMDRecipes.fluidStack("helium", 50), new EmptyFluidIngredient(), 0.1, 1.0});
        NCRecipes.centrifuge.addRecipe(new Object[]{QMDRecipes.fluidStack("water", 10000), QMDRecipes.fluidStack("heavy_water", 100), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), 1.0, 4.0});
        NCRecipes.centrifuge.addRecipe(new Object[]{QMDRecipes.fluidStack("redstone", 100), QMDRecipes.fluidStack("mercury", 144), QMDRecipes.fluidStack("sulfur", 666), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.centrifuge.addRecipe(new Object[]{QMDRecipes.fluidStack("coal", 100), QMDRecipes.fluidStack("carbon", 100), QMDRecipes.fluidStack("sulfur", 111), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.salt_mixer.addRecipe(new Object[]{QMDRecipes.fluidStack("mercury", 144), QMDRecipes.fluidStack("sulfur", 666), QMDRecipes.fluidStack("redstone", 100), 1.0, 1.0});
        NCRecipes.electrolyzer.addRecipe(new Object[]{QMDRecipes.fluidStack("sodium_chloride", 666), QMDRecipes.fluidStack("sodium", 144), QMDRecipes.fluidStack("chlorine", 500), new EmptyFluidIngredient(), new EmptyFluidIngredient(), 1.0, 1.0});
        NCRecipes.electrolyzer.addRecipe(new Object[]{QMDRecipes.fluidStack("sodium_chloride_solution", 1332), QMDRecipes.fluidStack("hydrogen", 1000), QMDRecipes.fluidStack("chlorine", 1000), QMDRecipes.fluidStack("sodium_hydroxide_solution", 1332), new EmptyFluidIngredient(), 0.5, 1.0});
        NCRecipes.manufactory.addRecipe(new Object[]{"bouleSilicon", AbstractRecipeHandler.oreStack((String)"waferSilicon", (int)4), 1.0, 1.0});
        NCRecipes.melter.addRecipe(new Object[]{new ItemStack(QMDItems.ingot2, 1, MaterialTypes.IngotType2.MERCURY.getID()), QMDRecipes.fluidStack("mercury", 144), 0.5, 0.0});
        NCRecipes.melter.addRecipe(new Object[]{"dustIodine", QMDRecipes.fluidStack("iodine", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustSamarium", QMDRecipes.fluidStack("samarium", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustTerbium", QMDRecipes.fluidStack("terbium", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustErbium", QMDRecipes.fluidStack("erbium", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustYtterbium", QMDRecipes.fluidStack("ytterbium", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustMolybdenum", QMDRecipes.fluidStack("molybdenum", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustBismuth", QMDRecipes.fluidStack("bismuth", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustPolonium", QMDRecipes.fluidStack("polonium", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustRadium", QMDRecipes.fluidStack("radium", 144)});
        NCRecipes.melter.addRecipe(new Object[]{"dustSalt", QMDRecipes.fluidStack("sodium_chloride", 666)});
        if (QMDConfig.override_nc_recipes) {
            fluidIngredients = new ArrayList<FluidIngredient>();
            itemIngredients = new ArrayList<OreIngredient>();
            itemIngredients.add(AbstractRecipeHandler.oreStack((String)"dustGraphite", (int)1));
            NCRecipes.melter.removeRecipe(NCRecipes.melter.getRecipeFromIngredients(itemIngredients, fluidIngredients));
            itemIngredients = new ArrayList();
            itemIngredients.add(AbstractRecipeHandler.oreStack((String)"dustGraphite", (int)1));
            NCRecipes.melter.removeRecipe(NCRecipes.melter.getRecipeFromIngredients(itemIngredients, fluidIngredients));
            NCRecipes.melter.addRecipe(new Object[]{AbstractRecipeHandler.oreStackList((List)Lists.newArrayList((Object[])new String[]{"dustGraphite", "ingotGraphite"}), (int)1), QMDRecipes.fluidStack("carbon", 100)});
            itemIngredients = new ArrayList();
            itemIngredients.add(AbstractRecipeHandler.oreStack((String)"blockGraphite", (int)1));
            NCRecipes.melter.removeRecipe(NCRecipes.melter.getRecipeFromIngredients(itemIngredients, fluidIngredients));
            NCRecipes.melter.addRecipe(new Object[]{"blockGraphite", QMDRecipes.fluidStack("carbon", 900)});
        }
        NCRecipes.melter.addRecipe(new Object[]{AbstractRecipeHandler.oreStackList((List)Lists.newArrayList((Object[])new String[]{"dustCharcoal", "charcoal"}), (int)1), QMDRecipes.fluidStack("carbon", 100)});
        NCRecipes.ingot_former.addRecipe(new Object[]{QMDRecipes.fluidStack("carbon", 100), "ingotGraphite"});
        if (QMDConfig.override_nc_recipes) {
            fluidIngredients = new ArrayList();
            itemIngredients = new ArrayList();
            fluidIngredients.add(QMDRecipes.fluidStack("coal", 100));
            NCRecipes.ingot_former.removeRecipe(NCRecipes.ingot_former.getRecipeFromIngredients(itemIngredients, fluidIngredients));
            NCRecipes.ingot_former.addRecipe(new Object[]{QMDRecipes.fluidStack("coal", 100), "coal", 0.5, 1.0});
        }
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("silicon", 1296), "bouleSilicon", 2.0, 2.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("lead_tungstate_solution", 666), new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.SCINTILLATOR_PWO.getID()), 1.0, 1.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("sodium_nitrate_solution", 666), "dustSodiumNitrate", 1.0, 1.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("sodium_chloride_solution", 666), "dustSalt", 1.0, 1.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("nd_yag", 432), "rodNdYAG", 2.0, 2.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("water", 10000), "dustSalt", 1.0, 4.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("iodine", 144), "dustIodine", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("samarium", 144), "dustSamarium", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("terbium", 144), "dustTerbium", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("erbium", 144), "dustErbium", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("ytterbium", 144), "dustYtterbium", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("molybdenum", 144), "dustMolybdenum", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("bismuth", 144), "dustbismuth", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("radium", 144), "dustRadium", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("polonium", 144), "dustPolonium", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("europium_155", 144), "dustEuropium155", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("ruthenium_106", 144), "dustRuthenium106", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("strontium_90", 144), "dustStrontium90", 0.25, 0.0});
        NCRecipes.crystallizer.addRecipe(new Object[]{QMDRecipes.fluidStack("promethium_147", 144), "dustPromethium147", 0.25, 0.0});
        NCRecipes.pressurizer.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"dustStrontium90", (int)9), "blockStrontium90", 1.0, 2.0});
        if (QMDConfig.override_nc_recipes) {
            ArrayList emptyitems = new ArrayList();
            ArrayList<FluidIngredient> helium = new ArrayList<FluidIngredient>();
            helium.add(QMDRecipes.fluidStack("helium", 8000));
            ArrayList<FluidIngredient> nitrogen = new ArrayList<FluidIngredient>();
            nitrogen.add(QMDRecipes.fluidStack("nitrogen", 8000));
            NCRecipes.supercooler.removeRecipe(NCRecipes.supercooler.getRecipeFromIngredients(emptyitems, helium));
            NCRecipes.supercooler.removeRecipe(NCRecipes.supercooler.getRecipeFromIngredients(emptyitems, nitrogen));
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("helium", 64), QMDRecipes.fluidStack("liquid_helium", 1), 0.006666666666666667, 5.0});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("nitrogen", 64), QMDRecipes.fluidStack("liquid_nitrogen", 1), 0.006666666666666667, 2.5});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("hydrogen", 64), QMDRecipes.fluidStack("liquid_hydrogen", 1), 0.006666666666666667, 3.75});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("neon", 64), QMDRecipes.fluidStack("liquid_neon", 1), 0.006666666666666667, 3.75});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("argon", 64), QMDRecipes.fluidStack("liquid_argon", 1), 0.006666666666666667, 2.5});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("oxygen", 64), QMDRecipes.fluidStack("liquid_oxygen", 1), 0.006666666666666667, 2.5});
        } else {
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("hydrogen", 8000), QMDRecipes.fluidStack("liquid_hydrogen", 25), 1.0, 1.0});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("neon", 8000), QMDRecipes.fluidStack("liquid_neon", 25), 1.0, 1.0});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("argon", 8000), QMDRecipes.fluidStack("liquid_argon", 25), 0.5, 0.5});
            NCRecipes.supercooler.addRecipe(new Object[]{QMDRecipes.fluidStack("oxygen", 8000), QMDRecipes.fluidStack("liquid_oxygen", 25), 0.5, 0.5});
        }
        if (QMDConfig.override_nc_recipes) {
            ArrayList<ItemIngredient> itemIngredients2 = new ArrayList<ItemIngredient>();
            itemIngredients2.add(new ItemIngredient(new ItemStack(NCItems.plutonium, 1, MetaEnums.PlutoniumType._238.getID())));
            ArrayList fluidIngredients2 = new ArrayList();
            NCRecipes.decay_hastener.removeRecipe(NCRecipes.decay_hastener.getRecipeFromIngredients(itemIngredients2, fluidIngredients2));
            NCRecipes.decay_hastener.addDecayRecipes("Plutonium238", "Uranium234", 0.0115);
        }
        NCRecipes.decay_hastener.addDecayRecipes("Beryllium7", "Lithium7", 6.89);
        NCRecipes.decay_hastener.addDecayRecipes("Protactinium231", "Lead", 3.05E-5);
        NCRecipes.decay_hastener.addDecayRecipes("Uranium234", "Radium", 4.07E-6);
        NCRecipes.decay_hastener.addRecipe(new Object[]{"ingotCobalt60", "dustNickel", QMDRecipes.getDecayHasenerTimeMultipler(0.19), 1.0, 0.19});
        NCRecipes.decay_hastener.addRecipe(new Object[]{"ingotIridium192", "dustPlatinum", QMDRecipes.getDecayHasenerTimeMultipler(4.94), 1.0, 4.94});
        double timeMult = NCMath.roundTo((double)RecipeHelper.getDecayTimeMultiplier((double)1.0E-6, (double)0.007986111111111112, (double)3.16E-7), (double)(5.0 / (double)NCConfig.processor_time[2]));
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"dustBSCCO", (int)3), AbstractRecipeHandler.oreStack((String)"ingotSilver", (int)6), new EmptyItemIngredient(), new EmptyItemIngredient(), AbstractRecipeHandler.oreStack((String)"wireBSCCO", (int)6), 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"ingotTungsten", (int)4), AbstractRecipeHandler.oreStack((String)"ingotGold", (int)2), new EmptyItemIngredient(), new EmptyItemIngredient(), AbstractRecipeHandler.oreStack((String)"wireGoldTungsten", (int)6), 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"dustBismuth", (int)2), AbstractRecipeHandler.oreStack((String)"dustStrontium", (int)2), AbstractRecipeHandler.oreStack((String)"dustCalcium", (int)2), AbstractRecipeHandler.oreStack((String)"dustCopperOxide", (int)3), AbstractRecipeHandler.oreStack((String)"dustBSCCO", (int)3), 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStackList(PLASTIC_TYPES, (int)2), AbstractRecipeHandler.oreStack((String)"dyeBlue", (int)1), new EmptyItemIngredient(), new EmptyItemIngredient(), new ItemStack(QMDItems.part, 1, MaterialTypes.PartType.SCINTILLATOR_PLASTIC.getID()), 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{"siliconNDoped", AbstractRecipeHandler.oreStack((String)"dustRedstone", (int)4), "ingotGold", "ingotSilver", "processorBasic", 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{"processorBasic", AbstractRecipeHandler.oreStack((String)"dustRedstone", (int)4), "dustHafniumOxide", "siliconPDoped", "processorAdvanced", 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{"processorAdvanced", AbstractRecipeHandler.oreStack((String)"wireBSCCO", (int)4), "dustHafniumOxide", "ingotPlatinum", "processorElite", 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"ingotTungsten", (int)2), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient(), IItemParticleAmount.fullItem(new ItemStack(QMDItems.source, 1, MaterialTypes.SourceType.TUNGSTEN_FILAMENT.getID())), 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"ingotFerroboron", (int)2), "ingotNeodymium", new EmptyItemIngredient(), new EmptyItemIngredient(), "magnetNeodymium", 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{"dustPotassium", "dustIodine", new ItemStack(Items.field_151102_aT, 4), "bioplastic", new ItemStack(QMDItems.potassiumIodineTablet, 4), 1.0, 1.0});
        NCRecipes.fission_irradiator.addRecipe(new Object[]{"waferSilicon", "siliconNDoped", 120000, 0.0, 0});
        NCRecipes.fission_irradiator.addRecipe(new Object[]{"ingotUranium234", "ingotUranium235", 1920000, 0.0, 4.07E-6});
        NCRecipes.fission_irradiator.addRecipe(new Object[]{"dustProtactinium231", "dustProtactinium233", 3840000, 0.0, 3.05E-5});
        NCRecipes.fission_irradiator.addRecipe(new Object[]{"ingotCobalt", "ingotCobalt60", 1920000, 0.0, 0});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteFissionLight", AbstractRecipeHandler.chanceOreStack((String)"dustStrontium", (int)1, (int)20), AbstractRecipeHandler.chanceOreStack((String)"dustStrontium90", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustYttrium", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustZirconium", (int)1, (int)20), AbstractRecipeHandler.chanceOreStack((String)"dustNiobium", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustMolybdenum", (int)1, (int)30), AbstractRecipeHandler.chanceOreStack((String)"dustRuthenium106", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustSilver", (int)1, (int)10)});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteFissionHeavy", AbstractRecipeHandler.chanceOreStack((String)"dustNiobium", (int)1, (int)4), AbstractRecipeHandler.chanceOreStack((String)"dustMolybdenum", (int)1, (int)21), AbstractRecipeHandler.chanceOreStack((String)"dustRuthenium106", (int)1, (int)4), AbstractRecipeHandler.chanceOreStack((String)"dustSilver", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustTin", (int)1, (int)35), AbstractRecipeHandler.chanceOreStack((String)"dustIodine", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustCaesium137", (int)1, (int)4), AbstractRecipeHandler.chanceOreStack((String)"dustNeodymium", (int)1, (int)18)});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationCalifornium", AbstractRecipeHandler.chanceOreStack((String)"dustThorium", (int)1, (int)26), AbstractRecipeHandler.chanceOreStack((String)"dustProtactinium231", (int)1, (int)13), AbstractRecipeHandler.chanceOreStack((String)"dustRadium", (int)1, (int)12), AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)9), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)20), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)20), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationBerkelium", AbstractRecipeHandler.chanceOreStack((String)"dustRadium", (int)1, (int)9), AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)15), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)40), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)35), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)1), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationCurium", AbstractRecipeHandler.chanceOreStack((String)"dustRadium", (int)1, (int)13), AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)17), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)16), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)50), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)4), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationAmericium", AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)22), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)15), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)55), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)1), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)2), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationPlutonium", AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)22), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)14), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)55), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)1), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)3), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationNeptunium", AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)36), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)17), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)34), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)2), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)4), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationUranium", AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)21), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)12), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)55), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)1), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)4), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationThorium", AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)10), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)62), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)11), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)2), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)8), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationProtactinium", AbstractRecipeHandler.chanceOreStack((String)"dustPolonium", (int)1, (int)36), AbstractRecipeHandler.chanceOreStack((String)"dustBismuth", (int)1, (int)6), AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)39), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)10), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)2), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)7), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationRadium", AbstractRecipeHandler.chanceOreStack((String)"dustLead", (int)1, (int)58), AbstractRecipeHandler.chanceOreStack((String)"ingotMercury", (int)1, (int)18), AbstractRecipeHandler.chanceOreStack((String)"dustGold", (int)1, (int)3), AbstractRecipeHandler.chanceOreStack((String)"dustPlatinum", (int)1, (int)10), AbstractRecipeHandler.chanceOreStack((String)"dustIridium", (int)1, (int)6), AbstractRecipeHandler.chanceOreStack((String)"dustOsmium", (int)1, (int)5), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationPolonium", AbstractRecipeHandler.chanceOreStack((String)"dustIridium", (int)1, (int)52), AbstractRecipeHandler.chanceOreStack((String)"dustOsmium", (int)1, (int)21), AbstractRecipeHandler.chanceOreStack((String)"dustTungsten", (int)1, (int)12), AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)10), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)5), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationBismuth", AbstractRecipeHandler.chanceOreStack((String)"dustIridium", (int)1, (int)42), AbstractRecipeHandler.chanceOreStack((String)"dustOsmium", (int)1, (int)27), AbstractRecipeHandler.chanceOreStack((String)"dustTungsten", (int)1, (int)14), AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)11), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)6), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationLead", AbstractRecipeHandler.chanceOreStack((String)"dustIridium", (int)1, (int)27), AbstractRecipeHandler.chanceOreStack((String)"dustOsmium", (int)1, (int)35), AbstractRecipeHandler.chanceOreStack((String)"dustTungsten", (int)1, (int)15), AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)12), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)8), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)3), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationMercury", AbstractRecipeHandler.chanceOreStack((String)"dustOsmium", (int)1, (int)42), AbstractRecipeHandler.chanceOreStack((String)"dustTungsten", (int)1, (int)27), AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)16), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)10), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)3), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationGold", AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)72), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)20), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)8), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationPlatinum", AbstractRecipeHandler.chanceOreStack((String)"dustTungsten", (int)1, (int)30), AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)44), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)17), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustTerbium", (int)1, (int)2), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationIridium", AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)59), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)29), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)10), AbstractRecipeHandler.chanceOreStack((String)"dustTerbium", (int)1, (int)2), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationOsmium", AbstractRecipeHandler.chanceOreStack((String)"dustHafnium", (int)1, (int)48), AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)35), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)11), AbstractRecipeHandler.chanceOreStack((String)"dustTerbium", (int)1, (int)3), AbstractRecipeHandler.chanceOreStack((String)"dustEuropium155", (int)1, (int)3), new EmptyItemIngredient(), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationTungsten", AbstractRecipeHandler.chanceOreStack((String)"dustYtterbium", (int)1, (int)50), AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)26), AbstractRecipeHandler.chanceOreStack((String)"dustTerbium", (int)1, (int)6), AbstractRecipeHandler.chanceOreStack((String)"dustEuropium155", (int)1, (int)5), AbstractRecipeHandler.chanceOreStack((String)"dustSamarium", (int)1, (int)7), AbstractRecipeHandler.chanceOreStack((String)"dustNeodymium", (int)1, (int)6), new EmptyItemIngredient(), new EmptyItemIngredient()});
        NCRecipes.fuel_reprocessor.addRecipe(new Object[]{"wasteSpallationHafnium", AbstractRecipeHandler.chanceOreStack((String)"dustErbium", (int)1, (int)32), AbstractRecipeHandler.chanceOreStack((String)"dustTerbium", (int)1, (int)16), AbstractRecipeHandler.chanceOreStack((String)"dustEuropium155", (int)1, (int)11), AbstractRecipeHandler.chanceOreStack((String)"dustSamarium", (int)1, (int)13), AbstractRecipeHandler.chanceOreStack((String)"dustNeodymium", (int)1, (int)23), AbstractRecipeHandler.chanceOreStack((String)"dustPromethium147", (int)1, (int)5), new EmptyItemIngredient(), new EmptyItemIngredient()});
        AtmosphereCollectorRecipes.registerRecipes();
        for (i = 0; i < BlockTypes.NeutronReflectorType.values().length; ++i) {
            NCRecipes.fission_reflector.addRecipe(new Object[]{new ItemStack(QMDBlocks.fissionReflector, 1, i), QMDConfig.fission_reflector_efficiency[i], QMDConfig.fission_reflector_reflectivity[i]});
        }
        QMDRecipes.addFissionFuelRecipes();
        NCRecipes.turbine.addRecipe(new Object[]{QMDRecipes.fluidStack("hot_mercury", 1), QMDRecipes.fluidStack("mercury", 1), NCConfig.turbine_power_per_mb[0] * 64.0, NCConfig.turbine_expansion_level[0], NCConfig.turbine_spin_up_multiplier[0]});
        QMDCraftingRecipeHandler.registerCraftingRecipes();
        for (i = 0; i < MaterialTypes.IngotType.values().length; ++i) {
            type = StringHelper.capitalize((String)MaterialTypes.IngotType.values()[i].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(QMDItems.dust, 1, i), (ItemStack)OreDictHelper.getPrioritisedCraftingStack((ItemStack)new ItemStack(QMDItems.ingot, 1, i), (String)("ingot" + type)), (float)0.0f);
                continue;
            }
            for (ItemStack dust : OreDictionary.getOres((String)("dust" + type))) {
                GameRegistry.addSmelting((ItemStack)dust, (ItemStack)OreDictHelper.getPrioritisedCraftingStack((ItemStack)new ItemStack(QMDItems.ingot, 1, i), (String)("ingot" + type)), (float)0.0f);
            }
        }
        for (i = 0; i < MaterialTypes.IngotType2.values().length; ++i) {
            if (i == MaterialTypes.IngotType2.MERCURY.getID()) continue;
            type = StringHelper.capitalize((String)MaterialTypes.IngotType2.values()[i].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(QMDItems.dust2, 1, i), (ItemStack)OreDictHelper.getPrioritisedCraftingStack((ItemStack)new ItemStack(QMDItems.ingot2, 1, i), (String)("ingot" + type)), (float)0.0f);
                continue;
            }
            for (ItemStack dust : OreDictionary.getOres((String)("dust" + type))) {
                GameRegistry.addSmelting((ItemStack)dust, (ItemStack)OreDictHelper.getPrioritisedCraftingStack((ItemStack)new ItemStack(QMDItems.ingot2, 1, i), (String)("ingot" + type)), (float)0.0f);
            }
        }
    }

    private static void addFissionFuelRecipes() {
        NCRecipes.solid_fission.addFuelDepleteRecipes(QMDConfig.copernicium_fuel_time, QMDConfig.copernicium_heat_generation, QMDConfig.copernicium_efficiency, QMDConfig.copernicium_criticality, QMDConfig.copernicium_decay_factor, QMDConfig.copernicium_self_priming, QMDConfig.copernicium_radiation, new String[]{"MIX291"});
        NCRecipes.pebble_fission.addFuelDepleteRecipes(QMDConfig.copernicium_fuel_time, QMDConfig.copernicium_heat_generation, QMDConfig.copernicium_efficiency, QMDConfig.copernicium_criticality, QMDConfig.copernicium_decay_factor, QMDConfig.copernicium_self_priming, QMDConfig.copernicium_radiation, new String[]{"MIX291"});
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Copernicium291", 1, "Zirconium", 1, "Copernicium291ZA", 1, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("Copernicium291", 1, "Graphite", 1, "Copernicium291Carbide", 1, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("MIX291", 1, "Zirconium", 1, "MIX291ZA", 1, 1.0, 1.0);
        NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes("MIX291", 1, "Graphite", 1, "MIX291Carbide", 1, 1.0, 1.0);
        NCRecipes.infuser.addRecipe(new Object[]{"ingotCopernicium291", QMDRecipes.fluidStack("oxygen", 1000), "ingotCopernicium291Oxide", 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{"ingotCopernicium291", QMDRecipes.fluidStack("nitrogen", 1000), "ingotCopernicium291Nitride", 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{"ingotMIX291", QMDRecipes.fluidStack("oxygen", 1000), "ingotMIX291Oxide", 1.0, 1.0});
        NCRecipes.infuser.addRecipe(new Object[]{"ingotMIX291", QMDRecipes.fluidStack("nitrogen", 1000), "ingotMIX291Nitride", 1.0, 1.0});
        NCRecipes.assembler.addRecipe(new Object[]{AbstractRecipeHandler.oreStack((String)"ingotMIX291Carbide", (int)9), "dustGraphite", "ingotPyrolyticCarbon", "ingotSiliconCarbide", AbstractRecipeHandler.oreStack((String)"ingotMIX291TRISO", (int)9), 1.0, 1.0});
        NCRecipes.fuel_reprocessor.addReprocessingRecipes("MIX291", "Americium243", 4, "Curium243", 2, "Curium245", 1, "Berkelium247", 1, "Ruthenium106", "Europium155", 0.5, 60);
        NCRecipes.separator.addRecipe(new Object[]{"ingotCopernicium291Carbide", "ingotCopernicium291", "dustGraphite"});
        NCRecipes.separator.addRecipe(new Object[]{"ingotCopernicium291ZA", "ingotCopernicium291", "dustZirconium"});
        NCRecipes.separator.addRecipe(new Object[]{"ingotMIX291Carbide", "ingotMIX291", "dustGraphite"});
        NCRecipes.separator.addRecipe(new Object[]{"ingotMIX291ZA", "ingotMIX291", "dustZirconium"});
        NCRecipes.separator.addRecipe(new Object[]{"ingotMIX291", "ingotCopernicium291", AbstractRecipeHandler.oreStack((String)"ingotUranium238", (int)8)});
        QMDRecipes.reductionIsotopeRecipes(QMDItems.copernicium, 1);
        QMDRecipes.reductionFissionFuelRecipes(QMDItems.pellet_copernicium, QMDItems.fuel_copernicium, 1);
    }

    public static void reductionIsotopeRecipes(Item isotope, int noTypes) {
        for (int i = 0; i < noTypes; ++i) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(isotope, 1, 5 * i + 2), (ItemStack)new ItemStack(isotope, 1, 5 * i), (float)0.0f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(isotope, 1, 5 * i + 3), (ItemStack)new ItemStack(isotope, 1, 5 * i), (float)0.0f);
        }
    }

    public static void reductionFissionFuelRecipes(Item pellet, Item fuel, int noTypes) {
        for (int i = 0; i < noTypes; ++i) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(fuel, 1, 4 * i + 1), (ItemStack)new ItemStack(pellet, 1, 2 * i), (float)0.0f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(fuel, 1, 4 * i + 2), (ItemStack)new ItemStack(pellet, 1, 2 * i), (float)0.0f);
        }
    }

    public static double getDecayHasenerTimeMultipler(double radiation) {
        double F = Math.log1p(Math.log(2.0));
        double Z = 0.1674477985420331;
        return NCMath.roundTo((double)(Z * (radiation >= 1.0 ? F / Math.log1p(Math.log1p(radiation)) : Math.log1p(Math.log1p(1.0 / radiation)) / F)), (double)(5.0 / (double)NCConfig.processor_time[2]));
    }

    public static FluidIngredient fluidStack(String fluidName, int stackSize) {
        if (!FluidRegHelper.fluidExists((String)fluidName)) {
            return null;
        }
        return new FluidIngredient(fluidName, stackSize);
    }

    static {
        PLASTIC_TYPES = Lists.newArrayList((Object[])new String[]{"bioplastic", "sheetPlastic"});
    }
}

