/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.machine.network.CreativeParticleSourceUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.ITileParticleStorage;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.ParticleStorageSource;
import nc.tile.ITileGui;
import nc.tile.NCTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;

public class TileCreativeParticleSource
extends NCTile
implements ITileParticleStorage,
ITickable,
ITileGui<CreativeParticleSourceUpdatePacket> {
    @Nonnull
    private final List<ParticleStorageSource> particleBeams;
    protected Set<EntityPlayer> playersToUpdate = new ObjectOpenHashSet();

    public TileCreativeParticleSource() {
        this.particleBeams = Lists.newArrayList((Object[])new ParticleStorageSource[]{new ParticleStorageSource()});
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeBeams(this.particleBeams, nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readBeams(this.particleBeams, nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            if (!this.getParticleBeams().isEmpty()) {
                return (T)this.getParticleBeams().get(0);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.getIsRedstonePowered()) {
            for (EnumFacing face : EnumFacing.values()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                otherStorage.reciveParticle(face.func_176734_d(), this.particleBeams.get(0).getParticleStack());
            }
        }
    }

    @Override
    public List<? extends ParticleStorage> getParticleBeams() {
        return this.particleBeams;
    }

    public String getParticleName() {
        if (this.particleBeams.get(0).getParticleStack() != null && this.particleBeams.get(0).getParticleStack().getParticle() != null) {
            return this.particleBeams.get(0).getParticleStack().getParticle().getName();
        }
        return "";
    }

    public int getParticleAmount() {
        if (this.particleBeams.get(0).getParticleStack() != null) {
            return this.particleBeams.get(0).getParticleStack().getAmount();
        }
        return 0;
    }

    public long getParticleEnergy() {
        if (this.particleBeams.get(0).getParticleStack() != null) {
            return this.particleBeams.get(0).getParticleStack().getMeanEnergy();
        }
        return 0L;
    }

    public double getParticleFocus() {
        if (this.particleBeams.get(0).getParticleStack() != null) {
            return this.particleBeams.get(0).getParticleStack().getFocus();
        }
        return 0.0;
    }

    public int getGuiID() {
        return 13;
    }

    public Set<EntityPlayer> getTileUpdatePacketListeners() {
        return this.playersToUpdate;
    }

    public CreativeParticleSourceUpdatePacket getTileUpdatePacket() {
        return new CreativeParticleSourceUpdatePacket(this.field_174879_c, this.particleBeams);
    }

    public void onTileUpdatePacket(CreativeParticleSourceUpdatePacket message) {
        if (message instanceof CreativeParticleSourceUpdatePacket) {
            CreativeParticleSourceUpdatePacket mess = message;
            for (int i = 0; i < mess.beams.size(); ++i) {
                this.particleBeams.set(i, mess.beams.get(i));
            }
        }
    }

    public NBTTagCompound writeBeams(List<ParticleStorageSource> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).writeToNBT(data, i);
        }
        return data;
    }

    public void readBeams(List<ParticleStorageSource> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).readFromNBT(data, i);
        }
    }

    public void setParticleBeams(List<ParticleStorageSource> beams) {
        for (int i = 0; i < beams.size(); ++i) {
            this.particleBeams.set(i, beams.get(i));
        }
    }
}

