/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InventoryStackList
extends NonNullList<ItemStack> {
    public InventoryStackList() {
    }

    public InventoryStackList(List<ItemStack> other) {
        super(other, null);
    }

    public List<ItemStack> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    protected class SubList<E>
    extends NonNullList<E> {
        private final AbstractList<E> internal;
        private final int offset;
        private int size;

        SubList(AbstractList<E> list, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.internal = list;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        public E set(int index, E element) {
            this.rangeCheck(index);
            this.checkForComodification();
            return this.internal.set(index + this.offset, element);
        }

        public E get(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            return this.internal.get(index + this.offset);
        }

        public int size() {
            this.checkForComodification();
            return this.size;
        }

        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.internal.add(index + this.offset, element);
            ++this.size;
        }

        public E remove(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            E result = this.internal.remove(index + this.offset);
            --this.size;
            return result;
        }

        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.internal.addAll(this.offset + index, c);
            this.size += cSize;
            return true;
        }

        public Iterator<E> iterator() {
            return this.listIterator();
        }

        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                private final ListIterator<E> internalIter;
                {
                    this.internalIter = SubList.this.internal.listIterator(index + SubList.this.offset);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex() < SubList.this.size;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        return this.internalIter.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                @Override
                public E previous() {
                    if (this.hasPrevious()) {
                        return this.internalIter.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return this.internalIter.nextIndex() - SubList.this.offset;
                }

                @Override
                public int previousIndex() {
                    return this.internalIter.previousIndex() - SubList.this.offset;
                }

                @Override
                public void remove() {
                    this.internalIter.remove();
                    --SubList.this.size;
                }

                @Override
                public void set(E e) {
                    this.internalIter.set(e);
                }

                @Override
                public void add(E e) {
                    this.internalIter.add(e);
                    ++SubList.this.size;
                }
            };
        }

        public List<E> subList(int fromIndex, int toIndex) {
            return new SubList<E>(this, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
        }
    }
}

