/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.util;

import java.util.ArrayList;
import java.util.HashSet;
import lach_01298.qmd.entity.EntityGammaFlash;
import nc.capability.radiation.entity.IEntityRads;
import nc.radiation.RadiationHelper;
import nc.util.DamageSources;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static Logger logger;

    public static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getFormatterLogger((String)"qmd");
        }
        return logger;
    }

    public static ResourceLocation appendPath(ResourceLocation location, String stringToAppend) {
        String domain = location.func_110624_b();
        String path = location.func_110623_a();
        ResourceLocation newLocation = new ResourceLocation(domain, path + stringToAppend);
        return newLocation;
    }

    public static EnumFacing getAxisFacing(EnumFacing.Axis axis, boolean positive) {
        if (axis == EnumFacing.Axis.X) {
            if (positive) {
                return EnumFacing.EAST;
            }
            return EnumFacing.WEST;
        }
        if (axis == EnumFacing.Axis.Y) {
            if (positive) {
                return EnumFacing.UP;
            }
            return EnumFacing.DOWN;
        }
        if (axis == EnumFacing.Axis.Z) {
            if (positive) {
                return EnumFacing.SOUTH;
            }
            return EnumFacing.NORTH;
        }
        return null;
    }

    public static int getTaxiDistance(BlockPos a, BlockPos b) {
        int x = Math.abs(a.func_177958_n() - b.func_177958_n());
        int y = Math.abs(a.func_177956_o() - b.func_177956_o());
        int z = Math.abs(a.func_177952_p() - b.func_177952_p());
        return x + y + z;
    }

    public static boolean mineBlock(World world, BlockPos pos, EntityPlayer player) {
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) > 0;
        return Util.mineBlock(world, pos, player, fortune, silkTouch, false);
    }

    public static boolean mineBlock(World world, BlockPos pos, EntityPlayer player, int fortune, boolean silkTouch, boolean ignoreHarvestLevels) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !ignoreHarvestLevels) {
            return false;
        }
        if (state.func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if (playerMP != null && ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos) == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
                player.func_71029_a(StatList.func_188055_a((Block)block));
                if (silkTouch && block.canSilkHarvest(world, pos, state, player) && !player.func_184812_l_()) {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    ItemStack itemstack = Util.getSilkTouchDrop(state);
                    if (!itemstack.func_190926_b()) {
                        items.add(itemstack);
                    }
                    ForgeEventFactory.fireBlockHarvesting(items, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
                    for (ItemStack item : items) {
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
                    }
                } else if (!player.func_184812_l_()) {
                    int xp = state.func_177230_c().getExpDrop(state, (IBlockAccess)world, pos, fortune);
                    block.func_180637_b(world, pos, xp);
                    block.func_176226_b(world, pos, state, fortune);
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static void createGammaFlash(World world, Vec3d pos, double size, float explosionSize, double radiation) {
        if (explosionSize > 0.0f) {
            world.func_72876_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, explosionSize, true);
        }
        world.func_72838_d((Entity)new EntityGammaFlash(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, size));
        HashSet entitylist = new HashSet();
        double radius = 128.0 * Math.sqrt(size);
        entitylist.addAll(world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos.field_72450_a - radius, pos.field_72448_b - radius, pos.field_72449_c - radius, pos.field_72450_a + radius, pos.field_72448_b + radius, pos.field_72449_c + radius)));
        for (EntityLivingBase entity : entitylist) {
            IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)entity);
            if (entityRads == null) continue;
            double rads = Math.min(radiation, radiation / pos.func_186679_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
            entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)entity, (double)rads, (boolean)false, (boolean)false, (int)1));
            if (!entityRads.isFatal() || entityRads.isImmune()) continue;
            entity.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
        }
    }
}

