/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.ContainmentRenderPacket;
import lach_01298.qmd.multiblock.network.VacuumChamberUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberComponent;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberController;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberBeamPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberEnergyPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberRedstonePort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberVent;
import nc.block.property.BlockProperties;
import nc.multiblock.IPacketMultiblockLogic;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import nc.util.MaterialHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class VacuumChamberLogic
extends MultiblockLogic<VacuumChamber, VacuumChamberLogic, IVacuumChamberPart>
implements IPacketMultiblockLogic<VacuumChamber, VacuumChamberLogic, IVacuumChamberPart, VacuumChamberUpdatePacket> {
    public static final int maxSize = 7;
    public static final int minSize = 5;
    private double excessCoolingRecipes = 0.0;
    private double excessHeat = 0.0;
    protected boolean operational = false;

    public VacuumChamberLogic(VacuumChamber multiblock) {
        super((Multiblock)multiblock);
    }

    public VacuumChamberLogic(VacuumChamberLogic oldLogic) {
        super((MultiblockLogic)oldLogic);
    }

    public String getID() {
        return "";
    }

    protected VacuumChamber getMultiblock() {
        return (VacuumChamber)this.multiblock;
    }

    public int getMinimumInteriorLength() {
        return 5;
    }

    public int getMaximumInteriorLength() {
        return 7;
    }

    public void onMachineAssembled() {
        this.onVacuumChamberFormed();
    }

    public void onMachineRestored() {
        this.onVacuumChamberFormed();
    }

    public void onVacuumChamberFormed() {
        ObjectIterator objectIterator = this.getPartMap(IVacuumChamberController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IVacuumChamberController contr;
            this.getMultiblock().controller = contr = (IVacuumChamberController)objectIterator.next();
        }
        this.getMultiblock().energyStorage.setStorageCapacity((long)(QMDConfig.vacuum_chamber_base_energy_capacity * this.getCapacityMultiplier()));
        this.getMultiblock().energyStorage.setMaxTransfer(QMDConfig.vacuum_chamber_base_energy_capacity * this.getCapacityMultiplier());
        this.getMultiblock().heatBuffer.setHeatCapacity((long)(QMDConfig.accelerator_base_heat_capacity * this.getCapacityMultiplier()));
        this.getMultiblock().ambientTemp = 273 + (int)(this.getWorld().func_180494_b(this.getMultiblock().getMiddleCoord()).func_180626_a(this.getMultiblock().getMiddleCoord()) * 20.0f);
        this.getMultiblock().tanks.get(0).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * this.getCapacityMultiplier());
        this.getMultiblock().tanks.get(1).setCapacity(QMDConfig.accelerator_base_output_tank_capacity * this.getCapacityMultiplier());
        if (!this.getMultiblock().cold) {
            HeatBuffer heatBuffer = this.getMultiblock().heatBuffer;
            long l = (long)this.getMultiblock().ambientTemp * this.getMultiblock().heatBuffer.getHeatCapacity();
            this.getMultiblock();
            heatBuffer.setHeatStored(l / 400L);
        }
        this.getMultiblock().cold = true;
        this.getMultiblock().currentHeating = 0L;
        if (!this.getWorld().field_72995_K) {
            int energy = 0;
            long heat = 0L;
            int maxTemp = 400;
            for (IVacuumChamberComponent part : this.getMultiblock().getPartMap(IVacuumChamberComponent.class).values()) {
                heat += (long)part.getHeating();
                energy += part.getPower();
                if (part.getMaxOperatingTemp() >= maxTemp) continue;
                maxTemp = part.getMaxOperatingTemp();
            }
            this.getMultiblock().requiredEnergy = energy;
            this.getMultiblock().heating = heat;
            this.getMultiblock().maxOperatingTemp = maxTemp;
            this.getMultiblock().updateActivity();
        }
    }

    public int getCapacityMultiplier() {
        return this.getMultiblock().getExteriorVolume();
    }

    public void onMachinePaused() {
        this.onContainmentBroken();
    }

    public void onMachineDisassembled() {
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            port.setRedstoneLevel(0);
        }
        this.operational = false;
        this.onContainmentBroken();
    }

    public void onContainmentBroken() {
        if (this.getMultiblock().controller != null) {
            this.getMultiblock().controller.setActivity(false);
        }
    }

    public boolean isMachineWhole() {
        boolean inlet = false;
        boolean outlet = false;
        for (TileVacuumChamberVent vent : this.getPartMap(TileVacuumChamberVent.class).values()) {
            if (!((Boolean)vent.getBlockState(vent.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                inlet = true;
                continue;
            }
            outlet = true;
        }
        if (!inlet) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.no_inlet", null, new Object[0]);
            return false;
        }
        if (!outlet) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.no_outlet", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileVacuumChamberEnergyPort.class).size() < 1) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return !this.containsBlacklistedPart();
    }

    public List<Pair<Class<? extends IVacuumChamberPart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends IVacuumChamberPart>, String>>();
    }

    public void onAssimilate(VacuumChamber assimilated) {
        if (assimilated instanceof VacuumChamber) {
            VacuumChamber assimilatedAccelerator = assimilated;
            this.getMultiblock().heatBuffer.mergeHeatBuffers(assimilatedAccelerator.heatBuffer);
            this.getMultiblock().energyStorage.mergeEnergyStorage(assimilatedAccelerator.energyStorage);
        }
        if (this.getMultiblock().isAssembled()) {
            this.onVacuumChamberFormed();
        } else {
            this.onContainmentBroken();
        }
    }

    public void onAssimilated(VacuumChamber assimilator) {
    }

    public boolean onUpdateServer() {
        this.getMultiblock().currentHeating = 0L;
        this.externalHeating();
        this.refreshFluidRecipe();
        if (this.canProcessFluidInputs()) {
            this.produceFluidProducts();
        }
        return true;
    }

    protected void pull() {
        for (TileVacuumChamberBeamPort port : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            if (port.getIOType() != EnumTypes.IOType.INPUT) continue;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                TileEntity tile = port.func_145831_w().func_175625_s(port.func_174877_v().func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                this.getMultiblock().beams.get(port.getIONumber()).setParticleStack(otherStorage.extractParticle(face.func_176734_d()));
            }
        }
    }

    protected void push() {
        for (TileVacuumChamberBeamPort port : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                TileEntity tile = port.func_145831_w().func_175625_s(port.func_174877_v().func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                otherStorage.reciveParticle(face.func_176734_d(), this.getMultiblock().beams.get(port.getIONumber()).getParticleStack());
            }
        }
    }

    @Nonnull
    public List<Tank> getVentTanks(List<Tank> backupTanks) {
        return this.getMultiblock().isAssembled() ? this.getMultiblock().tanks.subList(0, 2) : backupTanks;
    }

    protected void externalHeating() {
        this.getMultiblock().heatBuffer.addHeat(this.getMultiblock().getExternalHeating(), false);
        this.getMultiblock().currentHeating += this.getMultiblock().getExternalHeating();
    }

    protected void internalHeating() {
        this.getMultiblock().heatBuffer.addHeat(this.getMultiblock().heating, false);
        this.getMultiblock().currentHeating += this.getMultiblock().heating;
    }

    public boolean isMultiblockOn() {
        return this.operational;
    }

    protected void refreshFluidRecipe() {
        this.getMultiblock().coolingRecipeInfo = QMDRecipes.accelerator_cooling.getRecipeInfoFromInputs(new ArrayList(), this.getMultiblock().tanks.subList(0, 1));
        if (this.getMultiblock().coolingRecipeInfo != null) {
            this.getMultiblock().maxCoolantIn = (int)((double)(2L * this.getMultiblock().heating) / (double)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * 1000.0);
            this.getMultiblock().maxCoolantOut = (int)((double)((long)(((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0)).getMaxStackSize(0) * 2) * this.getMultiblock().heating) / (double)(((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * ((IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getMaxStackSize(0)) * 1000.0);
        }
    }

    protected boolean canProcessFluidInputs() {
        if (this.getMultiblock().coolingRecipeInfo == null) {
            return false;
        }
        IFluidIngredient fluidInput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0);
        IFluidIngredient fluidOutput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        Tank outputTank = this.getMultiblock().tanks.get(1);
        long maximumHeatChange = 2L * this.getMultiblock().heating;
        int heatPerMB = ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB();
        if (this.getMultiblock().getTemperature() <= ((FluidStack)fluidInput.getStack()).getFluid().getTemperature()) {
            return false;
        }
        if (fluidOutput.getMaxStackSize(0) <= 0 || fluidOutput.getStack() == null) {
            return false;
        }
        double recipesPerTick = (double)maximumHeatChange / (double)(fluidInput.getMaxStackSize(0) * heatPerMB);
        if (!outputTank.isEmpty()) {
            if (!outputTank.getFluid().isFluidEqual((FluidStack)fluidOutput.getStack())) {
                return false;
            }
            if ((double)outputTank.getFluidAmount() + (recipesPerTick + this.excessCoolingRecipes) * (double)fluidOutput.getMaxStackSize(0) > (double)outputTank.getCapacity()) {
                return false;
            }
        }
        return this.getMultiblock().heatBuffer.getHeatStored() >= (long)(fluidInput.getMaxStackSize(0) * heatPerMB);
    }

    private void produceFluidProducts() {
        IFluidIngredient fluidInput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0);
        IFluidIngredient fluidOutput = (IFluidIngredient)((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        Tank inputTank = this.getMultiblock().tanks.get(0);
        Tank outputTank = this.getMultiblock().tanks.get(1);
        long maximumHeatChange = 2L * this.getMultiblock().heating;
        int heatPerMB = ((BasicRecipe)this.getMultiblock().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB();
        double recipesPerTick = (double)maximumHeatChange / (double)(fluidInput.getMaxStackSize(0) * heatPerMB);
        if (recipesPerTick * (double)fluidInput.getMaxStackSize(0) > (double)inputTank.getFluidAmount()) {
            recipesPerTick = (double)inputTank.getFluidAmount() / (double)fluidInput.getMaxStackSize(0);
        }
        if (recipesPerTick * (double)fluidInput.getMaxStackSize(0) * (double)heatPerMB > (double)this.getMultiblock().heatBuffer.getHeatStored()) {
            recipesPerTick = this.getMultiblock().heatBuffer.getHeatStored() / (long)(fluidInput.getMaxStackSize(0) * heatPerMB);
        }
        int recipesThisTick = (int)Math.floor(recipesPerTick);
        this.excessCoolingRecipes += recipesPerTick - (double)recipesThisTick;
        if (this.excessCoolingRecipes >= 1.0) {
            recipesThisTick += (int)Math.floor(this.excessCoolingRecipes);
            this.excessCoolingRecipes -= Math.floor(this.excessCoolingRecipes);
        }
        inputTank.changeFluidAmount(-recipesThisTick * fluidInput.getMaxStackSize(0));
        if (inputTank.getFluidAmount() <= 0) {
            inputTank.setFluidStored(null);
        }
        if (outputTank.isEmpty()) {
            outputTank.changeFluidStored(fluidOutput.getNextStack(0).getFluid(), recipesThisTick * fluidOutput.getMaxStackSize(0));
        } else {
            outputTank.changeFluidAmount(recipesThisTick * fluidOutput.getMaxStackSize(0));
        }
        double heatChange = recipesThisTick * fluidInput.getMaxStackSize(0) * heatPerMB;
        this.excessHeat += heatChange;
        if (this.excessHeat > 1.0) {
            long thisTickHeatChange = (long)Math.floor(this.excessHeat);
            this.excessHeat -= (double)thisTickHeatChange;
            this.getMultiblock().heatBuffer.changeHeatStored(-thisTickHeatChange);
        }
    }

    protected boolean isRedstonePowered() {
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || !port.checkIsRedstonePowered(this.getWorld(), port.func_174877_v())) continue;
            return true;
        }
        return false;
    }

    protected int getRedstoneLevel() {
        int level = 0;
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || this.getWorld().func_175687_A(port.func_174877_v()) <= level) continue;
            level = this.getWorld().func_175687_A(port.func_174877_v());
        }
        return level;
    }

    protected void updateRedstone() {
    }

    public void onUpdateClient() {
    }

    public void writeToLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        data.func_74780_a("excessCoolingRecipes", this.excessCoolingRecipes);
        data.func_74780_a("excessHeat", this.excessHeat);
    }

    public void readFromLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.excessCoolingRecipes = data.func_74769_h("excessCoolingRecipes");
        this.excessHeat = data.func_74769_h("excessHeat");
    }

    public VacuumChamberUpdatePacket getMultiblockUpdatePacket() {
        return null;
    }

    public void onMultiblockUpdatePacket(VacuumChamberUpdatePacket message) {
    }

    public ContainmentRenderPacket getRenderPacket() {
        return null;
    }

    public void onRenderPacket(ContainmentRenderPacket message) {
    }

    public void clearAllMaterial() {
        for (Tank tank : this.getMultiblock().tanks) {
            tank.setFluidStored(null);
        }
    }

    public boolean isBlockGoodForInterior(World world, BlockPos pos) {
        if (MaterialHelper.isReplaceable((Material)world.func_180495_p(pos).func_185904_a()) || world.func_175625_s(pos) instanceof TileVacuumChamberPart) {
            return true;
        }
        return this.getMultiblock().standardLastError(pos);
    }
}

