/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.tile.ITileIONumber;
import lach_01298.qmd.vacuumChamber.NucleosynthesisChamberLogic;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.block.BlockVacuumChamberFluidPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import nc.block.property.BlockProperties;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.util.Lang;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileVacuumChamberFluidPort
extends TileVacuumChamberPart
implements ITileFluid,
ITileIONumber,
ITickable {
    @Nonnull
    private final List<Tank> backupTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1, new ArrayList())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll((List)Lists.newArrayList((Object[])new TankSorption[]{TankSorption.IN, TankSorption.NON}));
    @Nonnull
    private FluidTileWrapper[] fluidSides = ITileFluid.getDefaultFluidSides((ITileFluid)this);
    private int IONumber = 0;

    public TileVacuumChamberFluidPort() {
        super(CuboidalPartPositionType.WALL);
    }

    public void onMachineAssembled(VacuumChamber multiblock) {
        this.doStandardNullControllerResponse((Multiblock)multiblock);
        super.onMachineAssembled((CuboidalMultiblock)multiblock);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public void updateBlockState(boolean isActive) {
        if (this.func_145838_q() instanceof BlockVacuumChamberFluidPort) {
            ((BlockVacuumChamberFluidPort)this.func_145838_q()).setState(isActive, (TileEntity)this);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        EnumFacing facing = this.getPartPosition().getFacing();
        if (!this.field_145850_b.field_72995_K && !this.getTanks().get(0).isEmpty() && facing != null && this.getTankSorption(facing, 0).canDrain()) {
            this.pushFluidToSide(facing);
        }
    }

    @Nonnull
    public List<Tank> getTanks() {
        if (this.getMultiblock() != null && this.IONumber != 0 && this.getLogic() instanceof NucleosynthesisChamberLogic) {
            return ((VacuumChamber)this.getMultiblock()).isAssembled() ? ((VacuumChamber)this.getMultiblock()).tanks.subList(this.IONumber, this.IONumber + 1) : this.backupTanks;
        }
        return this.backupTanks;
    }

    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    public GasTileWrapper getGasWrapper() {
        return null;
    }

    public void pushFluidToSide(@Nonnull EnumFacing side) {
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof TileVacuumChamberFluidPort) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) continue;
            this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
        }
    }

    public boolean getInputTanksSeparated() {
        return false;
    }

    public void setInputTanksSeparated(boolean separated) {
    }

    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getMultiblock() != null) {
            if (this.getTankSorption(facing, 0) != TankSorption.IN) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setTankSorption(side, 0, TankSorption.IN);
                }
                this.updateBlockState(false);
                ((VacuumChamber)this.getMultiblock()).checkIfMachineIsWhole();
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"nc.block.vent_toggle") + " " + TextFormatting.DARK_AQUA + Lang.localise((String)"nc.block.fission_vent_mode.input") + " " + TextFormatting.WHITE + Lang.localise((String)"nc.block.vent_toggle.mode")));
            } else {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setTankSorption(side, 0, TankSorption.OUT);
                }
                this.updateBlockState(true);
                ((VacuumChamber)this.getMultiblock()).checkIfMachineIsWhole();
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"nc.block.vent_toggle") + " " + TextFormatting.RED + Lang.localise((String)"nc.block.fission_vent_mode.output") + " " + TextFormatting.WHITE + Lang.localise((String)"nc.block.vent_toggle.mode")));
            }
            this.markDirtyAndNotify();
            return true;
        }
        return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeFluidConnections(nbt);
        nbt.func_74768_a("IONumber", this.IONumber);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readFluidConnections(nbt);
        this.IONumber = nbt.func_74762_e("IONumber");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    @Override
    public void setIONumber(int number) {
        if (number >= 0 && number <= 7) {
            this.IONumber = number;
        }
    }

    @Override
    public int getIONumber() {
        return this.IONumber;
    }
}

