/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.PregenConfig;
import pregenerator.PregenProxy;
import pregenerator.base.PregenAPI;
import pregenerator.base.api.network.INetworkManager;
import pregenerator.config.config.ConfigHandler;
import pregenerator.config.config.FileSystemWatcher;
import pregenerator.config.impl.PerWorldProxy;
import pregenerator.config.impl.internal.ConfigLogger;
import pregenerator.config.impl.internal.EventHandler;
import pregenerator.config.networking.carbon.ConfigAnswerPacket;
import pregenerator.config.networking.carbon.ConfigRequestPacket;
import pregenerator.config.networking.carbon.SaveConfigPacket;
import pregenerator.config.networking.carbon.StateSyncPacket;
import pregenerator.config.networking.snyc.BulkSyncPacket;
import pregenerator.config.networking.snyc.SyncPacket;
import pregenerator.impl.client.info.IProcessorInfo;
import pregenerator.impl.client.utils.BiomeColors;
import pregenerator.impl.client.utils.StructureIcons;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.config.PermissionRule;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.network.ChunkPacket;
import pregenerator.impl.network.CommandPacket;
import pregenerator.impl.network.DiskPacket;
import pregenerator.impl.network.MemoryPacket;
import pregenerator.impl.network.OverlayPacket;
import pregenerator.impl.network.ProgressPacket;
import pregenerator.impl.network.RetrogenPacket;
import pregenerator.impl.network.StructurePacket;
import pregenerator.impl.network.TaskPacket;
import pregenerator.impl.network.TrackerPacket;
import pregenerator.impl.network.TypePacket;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.deleter.DeleteProcessor;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.retrogen.RetrogenManager;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTaskStorage;
import pregenerator.impl.storage.ProcessListener;
import pregenerator.impl.structure.StructureManager;
import pregenerator.impl.tracking.ServerTracker;

@Mod(modid="chunkpregenerator", version="4.4.0", name="Chunk Pregenerator", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12]")
public class ChunkPregenerator {
    public static Logger LOGGER = LogManager.getLogger((String)"Chunk Pregenerator");
    public static final ExecutorService CHUNK_PROCESS_QUEUE = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    public static final FileSystemWatcher CONFIGS = new FileSystemWatcher(new ConfigLogger(LOGGER), Loader.instance().getConfigDir().toPath(), EventHandler.INSTANCE);
    public static final PregenAPI BASE_API = new PregenAPI();
    @SidedProxy(clientSide="pregenerator.impl.client.PregenClientProxy", serverSide="pregenerator.PregenProxy")
    public static PregenProxy PROXY;
    public static final INetworkManager NETWORKING;
    public static final ExecutorService SERVICE;

    public ChunkPregenerator() {
        RetrogenManager.INSTANCE.fetchGenerators();
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        BASE_API.init();
        IBaseTask.init();
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        Path path = CONFIGS.getBasePath().resolve("pregen");
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(path.resolve("example.json"), new OpenOption[0]));){
                writer.setIndent("\t");
                Streams.write((JsonElement)this.createExample(), (JsonWriter)writer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BASE_API.registerTickEvent(ServerManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        StructureManager.INSTANCE.init();
        PregenConfig.INSTANCE.init();
        ServerTracker.INSTANCE.init();
        IProcessorInfo.init();
        try {
            EnumHelper.setFailsafeFieldValue((Field)RegionFileCache.class.getDeclaredFields()[0], null, new LinkedHashMap(256, 1.0f, true));
            LOGGER.info("Made the Pregenerator ThreadSave");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Loader.isModLoaded((String)"forgeessentials")) {
            LOGGER.fatal("Forge Essentials Detected. Chunk Pregen might not be useable because Forge Essentials claims the /pregen command. Please make sure you configured Forge Essentials Correctly or uninstall the Forge Essentials to make ChunkPregen useable");
        }
    }

    @Mod.EventHandler
    public void onLoad(FMLInitializationEvent event) {
        BASE_API.postInit();
        PROXY.init();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.onClientLoad();
        }
        NETWORKING.registerPacket(1, OverlayPacket.Request.class);
        NETWORKING.registerPacket(2, OverlayPacket.Answer.class);
        NETWORKING.registerPacket(3, RetrogenPacket.Request.class);
        NETWORKING.registerPacket(4, RetrogenPacket.Answer.class);
        NETWORKING.registerPacket(5, RetrogenPacket.Change.class);
        NETWORKING.registerPacket(6, RetrogenPacket.Sync.class);
        NETWORKING.registerPacket(7, MemoryPacket.RequestFree.class);
        NETWORKING.registerPacket(8, MemoryPacket.RequestUsed.class);
        NETWORKING.registerPacket(9, MemoryPacket.Answer.class);
        NETWORKING.registerPacket(10, ProgressPacket.Start.class);
        NETWORKING.registerPacket(11, ProgressPacket.Update.class);
        NETWORKING.registerPacket(12, ProgressPacket.Complete.class);
        NETWORKING.registerPacket(13, ProgressPacket.Cancel.class);
        NETWORKING.registerPacket(14, TaskPacket.RequestTasks.class);
        NETWORKING.registerPacket(15, TaskPacket.AnswerTasks.class);
        NETWORKING.registerPacket(16, TaskPacket.Action.class);
        NETWORKING.registerPacket(17, TaskPacket.RequestSpeeds.class);
        NETWORKING.registerPacket(18, TaskPacket.AnswerSpeeds.class);
        NETWORKING.registerPacket(19, CommandPacket.Request.class);
        NETWORKING.registerPacket(20, CommandPacket.Answer.class);
        NETWORKING.registerPacket(21, CommandPacket.Action.class);
        NETWORKING.registerPacket(22, CommandPacket.Task.class);
        NETWORKING.registerPacket(24, CommandPacket.RequestPerms.class);
        NETWORKING.registerPacket(25, CommandPacket.AnswerPerms.class);
        NETWORKING.registerPacket(26, TrackerPacket.Request.class);
        NETWORKING.registerPacket(27, TrackerPacket.Answer.class);
        NETWORKING.registerPacket(28, TypePacket.Request.class);
        NETWORKING.registerPacket(29, TypePacket.Answer.class);
        NETWORKING.registerPacket(30, TypePacket.DeleteAction.class);
        NETWORKING.registerPacket(31, ChunkPacket.Request.class);
        NETWORKING.registerPacket(32, ChunkPacket.Answer.class);
        NETWORKING.registerPacket(33, ChunkPacket.SingleAnswer.class);
        NETWORKING.registerPacket(34, ChunkPacket.RemoveAction.class);
        NETWORKING.registerPacket(35, ChunkPacket.TPAction.class);
        NETWORKING.registerPacket(36, DiskPacket.Request.class);
        NETWORKING.registerPacket(37, DiskPacket.Answer.class);
        NETWORKING.registerPacket(38, StructurePacket.Request.class);
        NETWORKING.registerPacket(39, StructurePacket.Answer.class);
        NETWORKING.registerPacket(40, StructurePacket.Delete.class);
        NETWORKING.registerPacket(100, SyncPacket.class);
        NETWORKING.registerPacket(101, BulkSyncPacket.class);
        NETWORKING.registerPacket(102, ConfigRequestPacket.class);
        NETWORKING.registerPacket(103, ConfigAnswerPacket.class);
        NETWORKING.registerPacket(104, SaveConfigPacket.class);
        NETWORKING.registerPacket(105, StateSyncPacket.class);
    }

    @Mod.EventHandler
    public void onCommonLoad(FMLPostInitializationEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.createDefaultConfig();
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        ChunkProcessor.INSTANCE.interruptTask(false, false);
        DeleteProcessor.INSTANCE.interruptTask(false);
        GlobalListeners.INSTANCE.clearListeners();
        StructureManager.INSTANCE.onServerStopped();
        ServerTracker.INSTANCE.onServerStopped();
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.unload();
        }
    }

    @Mod.EventHandler
    public void onServerLoaded(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new PregenCommands());
        PregenTaskStorage storage = PregenTaskStorage.getFromServer(event.getServer());
        if (event.getServer().func_71264_H()) {
            storage.add(null, true);
        }
        if (ChunkPregenerator.hasFile() && storage.runCommand("server")) {
            ChunkPregenerator.getCommands("server", ChunkPregenerator.parseCommands(), T -> event.getServer().func_71187_D().func_71556_a((ICommandSender)event.getServer(), T));
        }
        if (PregenConfig.INSTANCE.autoResume.get()) {
            GlobalListeners.INSTANCE.addListener(ProcessListener.create("server"));
            IBaseTask task = storage.getNextTask();
            if (task != null) {
                task.start();
            }
        }
    }

    public static void onClientJoinEvent() {
        if (PregenConfig.INSTANCE.pregenOverlay.isEnabled()) {
            NETWORKING.sendToServer(new CommandPacket.Action(6));
            NETWORKING.sendToServer(new CommandPacket.Action(9));
        }
    }

    @Mod.EventHandler
    public void load(FMLServerAboutToStartEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onClientLoad() {
        SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        StructureIcons.INSTANCE.init(Minecraft.func_71410_x().func_110434_K());
        manager.func_110542_a((IResourceManagerReloadListener)BiomeColors.INSTANCE);
        manager.func_110542_a((IResourceManagerReloadListener)StructureIcons.INSTANCE);
        EventHandler.INSTANCE.onConfigsLoaded();
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        if (ChunkPregenerator.isOpped(evt.player) && ChunkProcessor.INSTANCE.isRunning() && PregenTaskStorage.getFromServer(ChunkPregenerator.getServer()).isAutoListening(evt.player.func_110124_au())) {
            GlobalListeners.INSTANCE.addListener(ProcessListener.create(evt.player.func_110124_au()));
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        PregenTaskStorage storage;
        if (event.getWorld() instanceof WorldServer && ChunkPregenerator.hasFile() && (storage = PregenTaskStorage.getStorage()).runCommand(Integer.toString(event.getWorld().field_73011_w.getDimension()))) {
            String dimension = Integer.toString(event.getWorld().field_73011_w.getDimension());
            ArrayList commands = new ArrayList();
            JsonObject obj = ChunkPregenerator.parseCommands();
            ChunkPregenerator.getCommands("any", obj, T -> commands.add(String.format(T, dimension)));
            ChunkPregenerator.getCommands(dimension, obj, commands::add);
            MinecraftServer server = ChunkPregenerator.getServer();
            for (String entry : commands) {
                server.func_184102_h().func_71187_D().func_71556_a((ICommandSender)server, entry);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        GlobalListeners.INSTANCE.removeListener(ProcessListener.create(evt.player.func_110124_au()));
    }

    public static List<PregenAction> getValidActions(EntityPlayer player) {
        if (ChunkPregenerator.hasPermissions(player, 4)) {
            return ObjectArrayList.wrap((Object[])PregenAction.values());
        }
        PermissionRule rule = PregenConfig.INSTANCE.permissionRules.get(player.func_110124_au());
        return rule == null ? ObjectLists.emptyList() : new ObjectArrayList(rule.getActions());
    }

    public static boolean canDoAction(EntityPlayer player, PregenAction action) {
        if (ChunkPregenerator.hasPermissions(player, 4)) {
            return true;
        }
        PermissionRule rule = PregenConfig.INSTANCE.permissionRules.get(player.func_110124_au());
        return rule != null && rule.hasAction(action);
    }

    private static boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = ChunkPregenerator.getServer();
        if (server.func_71264_H() && Objects.equals(player.func_146103_bH().getName(), server.func_71214_G())) {
            return server.func_184103_al().func_152596_g(player.func_146103_bH());
        }
        UserListOpsEntry entry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return entry != null && entry.func_152644_a() >= value;
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    static boolean isOpped(EntityPlayer player) {
        return ChunkPregenerator.getServer().func_184103_al().func_152596_g(player.func_146103_bH());
    }

    private static boolean hasFile() {
        return Files.exists(CONFIGS.getBasePath().resolve("pregen").resolve("onDimensionCreation.json"), new LinkOption[0]);
    }

    private static JsonObject parseCommands() {
        Path path = CONFIGS.getBasePath().resolve("pregen").resolve("onDimensionCreation.json");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return new JsonParser().parse((Reader)Files.newBufferedReader(path)).getAsJsonObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JsonObject();
    }

    private static void getCommands(String tag, JsonObject obj, Consumer<String> commands) {
        ChunkPregenerator.iterate(obj.get(tag), T -> commands.accept(T.getAsString()));
    }

    private static void iterate(JsonElement element, Consumer<JsonPrimitive> result) {
        if (element == null) {
            return;
        }
        if (element.isJsonPrimitive()) {
            result.accept(element.getAsJsonPrimitive());
        } else if (element.isJsonArray()) {
            for (JsonElement entry : element.getAsJsonArray()) {
                ChunkPregenerator.iterate(entry, result);
            }
        }
    }

    private JsonObject createExample() {
        JsonObject obj = new JsonObject();
        obj.addProperty("fileheader", "Chunk Pregen Example file which executes all commands stored in it");
        obj.addProperty("filename", "This file is just the tutorial, the file that actually uses this feature is called: onDimensionCreation.json");
        obj.addProperty("filecontents", "The onDimensionCreation file is a Json File. All commands in there will be executed as a server");
        obj.addProperty("filecommands", "The commands inserted can be either an array or a value in json form, and the commands have to be written as if you would write them in a console");
        obj.addProperty("fileformat", "Everything in the example entry represents how the onDimensionCreation.json would look like. In other words it is the root of the file");
        JsonObject objects = new JsonObject();
        objects.addProperty("any", "executes these commands on any dimension that is created. Using %1$s will insert the dimensionId of the dimension that currently executes the commands, can be value or array");
        objects.addProperty("DimensionId", "executes these commands on this specific dimension alone. The dimensionId has to be the integer id of said dimension, can be value or array");
        objects.addProperty("server", "executes these commands upon the servers first startup, can be a value or array");
        objects.addProperty("0", "/msg hello world");
        objects.addProperty("any", "/pregen start gen radius TESTING%1$s SQUARE 0 0 100 %1$s");
        obj.add("example", (JsonElement)objects);
        return obj;
    }

    static {
        NETWORKING = BASE_API.createNetworking();
        SERVICE = Executors.newFixedThreadPool(1);
    }
}

