/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.Align;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.config.Config;
import pregenerator.config.config.ConfigEntry;
import pregenerator.config.config.ConfigHandler;
import pregenerator.config.config.ConfigSection;
import pregenerator.config.config.ConfigSettings;
import pregenerator.config.config.MappedConfig;
import pregenerator.config.gui.api.BackgroundTypes;
import pregenerator.config.impl.ReloadMode;
import pregenerator.impl.commands.BaseCommands;
import pregenerator.impl.config.DimensionSuggestion;
import pregenerator.impl.config.PermissionRule;
import pregenerator.impl.config.PregenOverlay;
import pregenerator.impl.config.SpeedEntry;
import pregenerator.impl.processor.generator.ChunkLogger;

public class PregenConfig {
    public static final PregenConfig INSTANCE = new PregenConfig();
    ConfigHandler handler;
    public ConfigEntry.IntValue timePerTick;
    public ConfigEntry.EnumValue<BaseCommands.Priority> priority;
    public ConfigEntry.BoolValue autoResume;
    public ConfigEntry.BoolValue memoryProtector;
    public ConfigEntry.IntValue memoryLimit;
    public ConfigEntry.IntValue playerLimit;
    public ConfigEntry.BoolValue tracker;
    public ConfigEntry.BoolValue forceServerTranslation;
    public ConfigEntry.EnumList<ChunkLogger> loggerOrder;
    public ConfigEntry.BoolValue clearMineshafts;
    public MappedConfig<UUID, PermissionRule> permissionRules;
    public ConfigEntry.ParsedArray<SpeedEntry> speedConfig;
    public MappedConfig<Integer, SpeedEntry> mappedSpeedConfig;
    public ConfigEntry.BoolValue userProtection;
    public ConfigEntry.ArrayValue activeRetrogenerators;
    public ConfigEntry.BoolValue disableAdvChat;
    public ConfigEntry.IntValue tooltipDelay;
    public PregenOverlay pregenOverlay = new PregenOverlay();
    public PregenOverlay trackerOverlay = new PregenOverlay();
    public ConfigEntry.IntValue detailDimension;
    public ConfigEntry.BoolValue ignoreScale;
    public ConfigEntry.BoolValue warnedForgeEssentials;
    public ConfigEntry.EnumValue<BackgroundTypes> background;
    public ConfigEntry.BoolValue ingameBackground;
    public ConfigEntry.BoolValue enableLoginWarning;

    public void init() {
        Config config = new Config("base");
        this.handler = ChunkPregenerator.CONFIGS.createConfig(config, ConfigSettings.withFolder("pregen"));
        ConfigSection common = config.add("common");
        ConfigSection gen = common.addSubSection("generator");
        this.timePerTick = (ConfigEntry.IntValue)gen.addInt("time-per-tick", 40, "Defines how many milliseconds per tick the pregenerator should take to generate chunks", "This config exists since the worldgenerator runs on gameplay thread", "Setting this number above 50 ms will cause gameplay lag while setting it lower will slow the pregenerator down", "If you want the fastest pregen speed but don't care about playability 250 is the best value, anything higher won't help unless you have edgecases").setRange(1, 1000).addSuggestionProvider(this::provideTimePerTickSuggestions);
        this.priority = gen.addEnum("priority", BaseCommands.Priority.GAME, BaseCommands.Priority.class, "Defines what task should be the Priority. Gameplay or Pregeneration.", "This is done by accounting the game lag in time-per-tick calculation", "When this is set to false it will prioritize a smooth gameplay over a faster pregeneration", "When it is set to true, the game lag will not be accounted for in the time-per-tick calculation");
        this.autoResume = gen.addBool("auto-resume", false, "Defines if the task queue should be automatically continued upon the startup of the game", "This is automatically set to true when you start a task so when a controlled shutdown happens you don't have manually resume tasks", "If you are in a crashloop due to the pregenerator simply set this to false and it should be solved");
        this.speedConfig = gen.addParsedArray("pregen-speeds", SpeedEntry.getDefaultValues(), SpeedEntry.getSerializer(), "This is a cache that stores last recorded pregen speeds.", "This is used to generate Estimate Predictions for ETA of how long a task should take.", "This isn't a config that sets how fast the pregenerator should run, but a config that keeps track of how fast they have been in the past", "Default values are 1 chunk a tick, because it is at the center of the possible ranges.");
        this.mappedSpeedConfig = this.speedConfig.createdMappedConfig(this.handler, SpeedEntry::getDimension, Function.identity());
        ConfigSection tweaks = common.addSubSection("tweaks");
        this.enableLoginWarning = tweaks.addBool("enable-login-warning", true, "Enables that the Server Preview Text in the Multiplayer Screen gets a Warning that if a Pregenerator is running", "With a ETA Included so players who want to know how long it will take.", "Once the Pregenerator is done or this is disabled the Original Text will be restored!");
        this.memoryProtector = tweaks.addBool("memory-protector", true, "Defines if the pregenerator automatically kills the game if it thinks the game is running out of ram to prevent world corruption", "NOTE: It will simply save the game and kill it. Since so many auto restart scripts exists it takes advantage of that to simply reset the ram usage");
        this.memoryLimit = tweaks.addInt("memory-limit", 384, "Defines how low the free ram has to be for 30 seconds straight before the pregenerator kills the game", "The number is defined in MB");
        this.playerLimit = tweaks.addInt("player-limit", -1, "Defines how many players have to be online for the pregenerator before the pregenerator automatically pauses", "-1 means it ignores players", "0 means the pregenerator is 24/7 paused", "> 0 means if the player count is reached said number the pregenerator will pause");
        this.clearMineshafts = tweaks.addBool("clear-mineshafts", true, "Defines if mineshaft references should be automatically be deleted to reduce the memory leak effect", "If this is enabled then the locate command doesn't work on Mineshafts");
        this.tracker = common.addBool("enable-profiler", true, "Defines if the Profiler should run in the Background or not");
        ConfigSection commands = common.addSubSection("commands");
        this.userProtection = commands.addBool("user-protection", true, "Defines if the User Protection should be enabled", "This is done due to people frequently generating with blocks in mind when everything is in chunks", "And this ususally leads to way bigger worlds and flodding harddrives");
        this.activeRetrogenerators = commands.addArray("active-retrogenerators", "The active list of retrogenerators");
        ConfigSection customization = common.addSubSection("customization");
        this.loggerOrder = customization.addEnumList("logger-order", new ArrayList<ChunkLogger>(Arrays.asList(ChunkLogger.values())), ChunkLogger.class, "Defines what is send in the chat Spam during the pregneration", "This entries can be removed/reordered/added as you wish");
        this.permissionRules = customization.addParsedArray("player-permissions", new ArrayList(), PermissionRule.createPermissions(), "Defines the Permissions clients can use", "Chunk Pregen comes with certain features that access server information, and sometimes you don't want to give OP rights since that will give access to everything", "The permission system is ment to give controlled access to features").createdMappedConfig(this.handler, PermissionRule::getPlayer, Function.identity());
        this.forceServerTranslation = customization.addBool("force-server-translation", false, "Defines if translations should be done serverside.", "This can address problems if the mod isn't installed on the client side.", "While this shouldn't happen it is nice to have a backup option", "Translation support should work 100% fine in singleplayer or if the mod is installed on the client when in a multiplayer session");
        ConfigSection client = config.add("client");
        this.tooltipDelay = client.addInt("tooltip-delay", 200, "Defines the delay when the Tooltip in guis shows up, number is in milliseconds", "This doesn't apply to the config itself!").setMin(0);
        this.disableAdvChat = (ConfigEntry.BoolValue)client.addBool("disable-advanced-commandline", false, "Disables the backport of the Command line from modern versions.", "Which makes writing commands much easier").setRequiredReload(ReloadMode.GAME);
        this.pregenOverlay.init(client.addSubSection("pregen-overlay"), true, Align.START, Align.START, 1.0);
        ConfigSection overlay = client.addSubSection("tracker-overlay");
        this.trackerOverlay.init(overlay, false, Align.END, Align.START, 1.0);
        this.detailDimension = (ConfigEntry.IntValue)overlay.addInt("detailed-dimension", 0, "Defines which dimension the Detailed info should be focusing on", "The Detail just shows additional stats that it tracks in the overlay").addSuggestionProvider(DimensionSuggestion.INSTANCE);
        this.ignoreScale = client.addBool("disable-preview-auto-scale", false, "Defines if the preview should automatically adjust the scale to always fit the entire gui or not");
        this.background = client.addEnum("custom-background", BackgroundTypes.PLANKS, BackgroundTypes.class, "Allows to pick for a Custom Background for Configs that use the default Background");
        this.ingameBackground = client.addBool("ingame-background", false, "Allows to set if the background is always visible or only if you are not in a active world");
        this.warnedForgeEssentials = client.addBool("warning-forge-essentials", false, "If the warning of Forge Essentials was shown. Config so it is only shown once");
        this.handler.register();
    }

    public ConfigHandler getHandler() {
        return this.handler;
    }

    public void save() {
        this.handler.save();
    }

    public void setAutoResume(boolean value) {
        this.autoResume.set(value);
        this.handler.save();
    }

    public void storeSpeed(int dimension, float data) {
        LinkedHashMap<Integer, SpeedEntry> entries = new LinkedHashMap<Integer, SpeedEntry>();
        for (SpeedEntry entry : (List)this.speedConfig.getValue()) {
            entries.put(entry.getDimension(), entry);
        }
        entries.put(dimension, new SpeedEntry(dimension, data));
        this.speedConfig.set((SpeedEntry)new ObjectArrayList(entries.values()));
        this.save();
    }

    private void provideTimePerTickSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
        String[] names = new String[]{"fastest", "fast", "unstable", "stable", "slow", "slowest"};
        String[] speeds = new String[]{"250", "100", "50", "40", "20", "10"};
        for (int i = 0; i < names.length; ++i) {
            ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedValue("suggestion.chunk_pregen.time_per_tick." + names[i], speeds[i]);
            if (!filter.test(suggestion)) continue;
            output.accept(suggestion);
        }
    }
}

