/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui.comp;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.impl.gui.SelectorScreen;
import pregenerator.base.impl.gui.comp.PregenButton;

public class CycleButton<T>
extends PregenButton {
    CycleState<T> state;
    Consumer<CycleButton<T>> onChange;
    boolean selectScreen = false;

    public CycleButton(int xPos, int yPos, int width, int height, List<T> values, T current, Function<T, ITextComponent> displayFunction, Consumer<CycleButton<T>> onChange) {
        this(xPos, yPos, width, height, new CycleState<T>(current, displayFunction, values), onChange);
    }

    public CycleButton(int xPos, int yPos, int width, int height, CycleState<T> state, Consumer<CycleButton<T>> onChange) {
        super(xPos, yPos, width, height, state.getCurrentText(), null);
        this.state = state;
        this.onChange = onChange;
        this.state.setOwner(this);
    }

    public CycleButton<T> withSelectScreen() {
        this.selectScreen = true;
        return this;
    }

    public CycleButton<T> setValues(List<T> newValues) {
        if (this.state.setValues(newValues)) {
            this.field_146126_j.charAt(0);
            this.setDisplayText(this.state.getCurrentText());
        }
        return this;
    }

    public CycleButton<T> selected(T value) {
        if (this.state.setValue(value)) {
            this.setDisplayText(this.state.getCurrentText());
        }
        return this;
    }

    @Override
    public void onPress(int button) {
        if (GuiScreen.func_146271_m()) {
            if (this.selectScreen) {
                Minecraft mc = Minecraft.func_71410_x();
                SelectorScreen<Object> screen = new SelectorScreen<Object>(mc.field_71462_r, this.state.values, this.state.value, this.state.displayFunction, T -> {
                    this.state.setValue(T);
                    this.setDisplayText(this.state.getCurrentText());
                    if (this.onChange != null) {
                        this.onChange.accept(this);
                    }
                });
                mc.func_147108_a(screen);
            } else {
                this.state.cycleBackwards();
                this.setDisplayText(this.state.getCurrentText());
                if (this.onChange != null) {
                    this.onChange.accept(this);
                }
            }
        } else if (GuiScreen.func_146272_n() || button == 1) {
            this.state.cycleBackwards();
            this.setDisplayText(this.state.getCurrentText());
            if (this.onChange != null) {
                this.onChange.accept(this);
            }
        } else {
            this.state.cycle();
            this.setDisplayText(this.state.getCurrentText());
            if (this.onChange != null) {
                this.onChange.accept(this);
            }
        }
    }

    public List<T> getValues() {
        return this.state.getValues();
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    public T getValue() {
        return this.state.getValue();
    }

    public static class CycleState<T> {
        Function<T, ITextComponent> displayFunction;
        List<T> values;
        T value;
        CycleButton<T> owner;

        @SafeVarargs
        public CycleState(T value, ITextComponent name, T ... values) {
            this(value, (T T) -> name, Arrays.asList(values));
        }

        public CycleState(T value, ITextComponent name, List<T> values) {
            this(value, (T T) -> name, values);
        }

        @SafeVarargs
        public CycleState(T value, Function<T, ITextComponent> displayFunction, T ... values) {
            this(value, displayFunction, Arrays.asList(values));
        }

        public CycleState(T value, Function<T, ITextComponent> displayFunction, List<T> values) {
            this.displayFunction = displayFunction;
            this.values = values;
            this.value = value;
        }

        public ITextComponent getCurrentText() {
            return this.displayFunction.apply(this.value);
        }

        public ITextComponent getText(T value) {
            return this.displayFunction.apply(value);
        }

        public int getIndex() {
            return this.values.indexOf(this.value);
        }

        public List<T> getValues() {
            return this.values;
        }

        public T getValue() {
            return this.value;
        }

        public CycleState<T> setOwner(CycleButton<T> owner) {
            this.owner = owner;
            return this;
        }

        public CycleButton<T> getOwner() {
            return this.owner;
        }

        public boolean setValues(List<T> newValues) {
            this.values = newValues;
            if (!this.values.contains(this.value)) {
                return this.setValue(this.values.get(0));
            }
            if (this.owner != null) {
                this.owner.setDisplayText(this.getCurrentText());
            }
            return false;
        }

        public boolean setValue(T value) {
            int index = this.values.indexOf(value);
            if (index != -1 && index != this.getIndex()) {
                this.value = this.values.get(index);
                return true;
            }
            return false;
        }

        public void updateText() {
            if (this.owner != null) {
                this.owner.setDisplayText(this.getCurrentText());
            }
        }

        public void cycleBackwards() {
            int index = this.getIndex() - 1;
            this.value = this.values.get(index < 0 ? this.values.size() - 1 : index);
        }

        public void cycle() {
            this.value = this.values.get((this.getIndex() + 1) % this.values.size());
        }
    }
}

