/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.networking;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.INetworkManager;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.base.impl.networking.ChannelHandler;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<IPregenPacket>
implements INetworkManager {
    private EnumMap<Side, FMLEmbeddedChannel> channel;
    ChannelHandler manager;
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet();
    boolean serverInstalled = false;

    @Override
    public INetworkManager init() {
        this.manager = new ChannelHandler();
        this.channel = NetworkRegistry.INSTANCE.newChannel("chunkpregenerator", new io.netty.channel.ChannelHandler[]{this.manager, this});
        return this;
    }

    @Override
    public void registerPacket(int index, Class<? extends IPregenPacket> packet) {
        this.manager.registerPacket(index, packet);
    }

    @Override
    public void sendToServer(IPregenPacket packet) {
        this.channel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channel.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    @Override
    public void sendToPlayer(IPregenPacket packet, EntityPlayer player) {
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    @Override
    public void sendToAllPlayers(IPregenPacket packet) {
        for (EntityPlayer entityPlayer : this.getAllPlayers()) {
            FMLEmbeddedChannel data = this.channel.get(Side.SERVER);
            data.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            data.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayer);
            data.writeOutbound(new Object[]{packet});
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, IPregenPacket msg) throws Exception {
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        if (netHandler == null) {
            throw new RuntimeException("No nethandler found: " + ctx);
        }
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread(netHandler);
        if (msg.needsMainThreads()) {
            thread.func_152344_a(() -> msg.process(this.getPlayer(netHandler)));
        } else {
            msg.process(this.getPlayer(netHandler));
        }
    }

    @Override
    public void onPlayerJoined(EntityPlayer player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.func_110124_au());
        } else {
            this.serverInstalled = true;
        }
    }

    @Override
    public void onPlayerLeft(EntityPlayer player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.func_110124_au());
        } else {
            this.serverInstalled = false;
        }
    }

    @Override
    public boolean isInWorld() {
        return ChunkPregenerator.PROXY.getClientPlayer() != null;
    }

    private List<EntityPlayerMP> getAllPlayers() {
        ObjectArrayList players = new ObjectArrayList();
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public boolean isInstalled(EntityPlayer player) {
        return player instanceof EntityPlayerMP ? this.isInstalledOnClient((EntityPlayerMP)player) : this.isInstalledOnServer();
    }

    @Override
    public boolean isInstalledOnClient(EntityPlayerMP player) {
        return this.clientInstalledPlayers.contains(player.func_110124_au());
    }

    @Override
    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public EntityPlayer getPlayer(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return ChunkPregenerator.PROXY.getClientPlayer();
    }
}

