/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.config.api.ConfigType;
import pregenerator.config.gui.api.BackgroundTexture;
import pregenerator.config.gui.api.IModConfig;
import pregenerator.config.gui.screen.ConfigScreen;
import pregenerator.config.gui.screen.RequestScreen;

public class ConfigFeatures {
    @SideOnly(value=Side.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, String ... path) {
        ConfigFeatures.openRemoteConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            ConfigFeatures.openLocalConfigFolder(config, texture, path);
            return;
        }
        if (config.getConfigType() == ConfigType.CLIENT) {
            ChunkPregenerator.LOGGER.info("Tried to open a local config in the Remote Opener");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            ChunkPregenerator.LOGGER.info("Tried to open a Remote config when there was no remote attached");
            return;
        }
        if (!mc.func_71356_B() && mc.field_71439_g.func_184840_I() < 4) {
            ChunkPregenerator.LOGGER.info("Tried to open a Remote config without permission");
            return;
        }
        mc.func_147108_a((GuiScreen)new RequestScreen(texture.asHolder(), ConfigScreen.Navigator.create(config).withWalker(path), mc.field_71462_r, config));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, String ... path) {
        ConfigFeatures.openLocalConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        if (!config.isLocalConfig()) {
            ChunkPregenerator.LOGGER.info("Tried to open a Remote config in the Local Opener");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new ConfigScreen(ConfigScreen.Navigator.create(config).withWalker(path), config, mc.field_71462_r, texture.asHolder()));
    }
}

