/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import pregenerator.config.config.ConfigEntry;
import pregenerator.config.config.ConfigHandler;

public class HashSetCache<T> {
    public final ConfigEntry.ArrayConfigEntry<T> configEntry;
    private final Set<T> cache = new ObjectOpenHashSet();

    private HashSetCache(ConfigEntry.ArrayConfigEntry<T> configEntry, ConfigHandler configHandler) {
        this.configEntry = configEntry;
        configHandler.addLoadedListener(this::reload);
    }

    private void reload() {
        this.cache.clear();
        for (Object val : (Object[])this.configEntry.getValue()) {
            this.cache.add(val);
        }
    }

    public boolean contains(T value) {
        return this.cache.contains(value);
    }

    public static <T> HashSetCache<T> create(ConfigEntry.ArrayConfigEntry<T> configEntry, ConfigHandler configHandler) {
        return new HashSetCache<T>(configEntry, configHandler);
    }
}

