/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.config;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import pregenerator.config.gui.api.IArrayNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.api.IValueNode;
import pregenerator.config.gui.config.ConfigElement;
import pregenerator.config.gui.widgets.CarbonButton;

public class BooleanElement
extends ConfigElement {
    private CarbonButton trueButton;
    private CarbonButton falseButton;

    public BooleanElement(IConfigNode node, IValueNode value) {
        super(node, value);
    }

    public BooleanElement(IConfigNode node, IArrayNode array, int index) {
        super(node, array, index);
    }

    @Override
    public void init() {
        super.init();
        int width = this.isArray() ? 72 : 36;
        this.trueButton = this.addChild(new CarbonButton(0, 0, width, 18, I18n.func_135052_a((String)"gui.chunk_pregen.config.boolean.true", (Object[])new Object[0]), this::onTrue), this.isArray() ? ConfigElement.GuiAlign.CENTER : ConfigElement.GuiAlign.RIGHT, this.isArray() ? width / 2 : width);
        this.falseButton = this.addChild(new CarbonButton(0, 0, width, 18, I18n.func_135052_a((String)"gui.chunk_pregen.config.boolean.false", (Object[])new Object[0]), this::onFalse), this.isArray() ? ConfigElement.GuiAlign.CENTER : ConfigElement.GuiAlign.RIGHT, this.isArray() ? -(width / 2) : 0);
        this.updateData();
    }

    private void updateData() {
        boolean isTrue = Boolean.parseBoolean(this.value.get());
        this.trueButton.field_146124_l = !isTrue;
        this.falseButton.field_146124_l = isTrue;
    }

    @Override
    public void tick() {
        super.tick();
        this.updateData();
    }

    protected void onTrue(GuiButton button) {
        this.value.set("true");
    }

    protected void onFalse(GuiButton button) {
        this.value.set("false");
    }
}

