/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.config;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.gui.api.IArrayNode;
import pregenerator.config.gui.api.ICompoundNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.api.IValueNode;
import pregenerator.config.gui.config.Element;
import pregenerator.config.gui.screen.ListSelectionScreen;
import pregenerator.config.gui.widgets.CarbonHoverIconButton;
import pregenerator.config.gui.widgets.CarbonIconButton;
import pregenerator.config.gui.widgets.GuiUtils;
import pregenerator.config.gui.widgets.IOwnable;
import pregenerator.config.gui.widgets.Icon;
import pregenerator.config.gui.widgets.screen.IInteractable;
import pregenerator.config.gui.widgets.screen.IWidget;

public class ConfigElement
extends Element {
    private static final ITextComponent DELETE = new TextComponentTranslation("gui.chunk_pregen.config.delete", new Object[0]);
    private static final ITextComponent REVERT = new TextComponentTranslation("gui.chunk_pregen.config.revert", new Object[0]);
    private static final ITextComponent DEFAULT = new TextComponentTranslation("gui.chunk_pregen.config.default", new Object[0]);
    private static final ITextComponent SUGGESTIONS = new TextComponentTranslation("gui.chunk_pregen.config.suggestions", new Object[0]);
    private static final ITextComponent RELOAD = new TextComponentTranslation("gui.chunk_pregen.config.reload", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    private static final ITextComponent RESTART = new TextComponentTranslation("gui.chunk_pregen.config.restart", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    protected List<IInteractable> listeners = new ObjectArrayList();
    protected List<Map.Entry<IWidget, AlignOffset>> mappedListeners = new ObjectArrayList();
    protected IConfigNode node;
    protected IValueNode value;
    protected IArrayNode array;
    protected ICompoundNode compound;
    protected int compoundIndex = -1;
    protected CarbonIconButton setReset;
    protected CarbonIconButton setDefault;
    protected CarbonIconButton suggestion;
    protected CarbonHoverIconButton moveDown;
    protected CarbonHoverIconButton moveUp;

    public ConfigElement(IConfigNode node) {
        super(node.getName());
        this.node = node;
        this.value = node.asValue();
    }

    public ConfigElement(IConfigNode node, IValueNode value) {
        super(node.getName());
        this.node = node;
        this.value = value;
    }

    public ConfigElement(IConfigNode node, IArrayNode array) {
        super(node.getName());
        this.node = node;
        this.array = array;
    }

    public ConfigElement(IConfigNode node, IArrayNode array, int index) {
        super(node.getName());
        this.node = node;
        this.array = array;
        this.value = array.asValue(index);
    }

    protected <T extends IWidget> T addChild(T element) {
        return this.addChild(element, GuiAlign.RIGHT, 0);
    }

    protected <T extends IWidget> T addChild(T element, int xOffset) {
        return this.addChild(element, GuiAlign.RIGHT, xOffset);
    }

    protected <T extends IWidget> T addChild(T element, GuiAlign align, int xOffset) {
        this.listeners.add(element);
        this.mappedListeners.add(new AbstractMap.SimpleEntry<T, AlignOffset>(element, new AlignOffset(align, -xOffset - 19)));
        if (this.owner != null && element instanceof IOwnable) {
            ((IOwnable)((Object)element)).setOwner(this.owner);
        }
        return element;
    }

    @Override
    public void init() {
        super.init();
        if (this.createResetButtons(this.value)) {
            if (this.isArray()) {
                this.setReset = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.DELETE, "", this::onDeleted).setIconOnly(), -31);
                this.setReset.field_146124_l = this.isReset();
                this.moveDown = new CarbonHoverIconButton(0, 0, 15, 8, new CarbonHoverIconButton.IconInfo(0, -3, 16, 16), Icon.MOVE_DOWN, Icon.MOVE_DOWN_HOVERED, this::onMoveDown);
                this.listeners.add(this.moveDown);
                this.moveUp = new CarbonHoverIconButton(0, 0, 15, 8, new CarbonHoverIconButton.IconInfo(0, -3, 16, 16), Icon.MOVE_UP, Icon.MOVE_UP_HOVERED, this::onMoveUp);
                this.listeners.add(this.moveUp);
            } else {
                this.setReset = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.REVERT, "", this::onReset).setIconOnly(), -21);
                this.setDefault = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.SET_DEFAULT, "", this::onDefault).setIconOnly(), -40);
                this.suggestion = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.SUGGESTIONS, "", this::onSuggestion).setIconOnly(), -59);
                this.setReset.field_146124_l = this.isReset();
                this.setDefault.field_146124_l = !this.isDefault();
                this.suggestion.field_146125_m = false;
            }
        }
        if (this.owner != null) {
            for (IInteractable entry : this.listeners) {
                if (!(entry instanceof IOwnable)) continue;
                ((IOwnable)((Object)entry)).setOwner(this.owner);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.setReset != null) {
            this.setReset.field_146124_l = this.isReset();
        }
        if (this.setDefault != null) {
            this.setDefault.field_146124_l = !this.isDefault();
        }
    }

    @Override
    public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        if (this.renderName() && !this.isArray()) {
            this.renderName(left, top, this.isChanged(), this.isCompound() ? 80 : 200, height);
            if (!this.isCompound()) {
                if (this.node.requiresReload()) {
                    GuiUtils.drawTextureRegion(left - 16, top + height / 2 - 6, 12.0f, 12.0f, Icon.RELOAD, 16.0f, 16.0f);
                    if (mouseX >= left - 16 && mouseX <= left - 4 && mouseY >= top && mouseY <= top + height && this.owner.isInsideList(mouseX, mouseY)) {
                        this.owner.addTooltips(RELOAD);
                    }
                }
                if (this.node.requiresRestart()) {
                    GuiUtils.drawTextureRegion(left - 16, top + height / 2 - 6, 12.0f, 12.0f, Icon.RESTART, 16.0f, 16.0f);
                    if (mouseX >= left - 16 && mouseX <= left - 4 && mouseY >= top && mouseY <= top + height && this.owner.isInsideList(mouseX, mouseY)) {
                        this.owner.addTooltips(RESTART);
                    }
                }
            }
        }
        int maxX = Integer.MAX_VALUE;
        if (this.renderChildren()) {
            if (this.isArray()) {
                this.moveUp.field_146128_h = left + width - 16;
                this.moveUp.field_146129_i = top;
                this.moveUp.field_146125_m = this.canMoveUp();
                this.moveUp.render(this.mc, mouseX, mouseY, partialTicks);
                this.moveDown.field_146128_h = left + width - 16;
                this.moveDown.field_146129_i = top + 10;
                this.moveDown.field_146125_m = this.canMoveDown();
                this.moveDown.render(this.mc, mouseX, mouseY, partialTicks);
                if (this.moveDown.field_146125_m || this.moveUp.field_146125_m) {
                    left -= 8;
                }
            }
            for (Map.Entry<IWidget, AlignOffset> entry : this.mappedListeners) {
                IWidget widget = entry.getKey();
                AlignOffset offset = entry.getValue();
                widget.setX(offset.align.align(left, width, widget.getWidgetWidth()) + offset.offset);
                widget.setY(top);
                widget.render(this.mc, mouseX, mouseY, partialTicks);
                maxX = Math.min(maxX, widget.getX());
            }
        }
        maxX = this.getMaxX(maxX);
        if (this.isArray()) {
            TextComponentString comp = new TextComponentString(this.indexOf() + ":");
            this.renderText((ITextComponent)comp, maxX - 115, top - 1, 105.0f, height, GuiAlign.RIGHT, -1);
        }
        if (mouseY >= top && mouseY <= top + height && mouseX >= left && mouseX <= maxX - 2 && this.owner.isInsideList(mouseX, mouseY)) {
            this.owner.addTooltips(this.node.getTooltip());
        }
        if (this.isArray()) {
            if (this.setReset.isHovered() && this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(DELETE);
            }
        } else {
            if (this.setReset.isHovered() && this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(REVERT);
            }
            if (this.setDefault.isHovered() && this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(DEFAULT);
            }
            this.suggestion.field_146125_m = this.hasSuggestions();
            if (this.suggestion.field_146125_m && this.suggestion.isHovered() & this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(SUGGESTIONS);
            }
        }
    }

    protected boolean hasSuggestions() {
        if (this.isCompound()) {
            if (this.compound.isForcedSuggestion(this.compoundIndex)) {
                return false;
            }
            List<ISuggestionProvider.Suggestion> suggestions = this.compound.getValidValues(this.compoundIndex);
            return suggestions != null && suggestions.size() > 0;
        }
        if (this.node != null && this.node.isForcingSuggestions()) {
            return false;
        }
        List<ISuggestionProvider.Suggestion> suggestions = this.node == null ? null : this.node.getValidValues();
        return suggestions != null && suggestions.size() > 0;
    }

    public void setCompound(ICompoundNode compound, int index) {
        this.compound = compound;
        this.compoundIndex = index;
        if (compound == null || index < 0) {
            return;
        }
        this.setName(compound.getName(index));
    }

    protected int getMaxX(int prevMaxX) {
        return prevMaxX;
    }

    protected boolean isArray() {
        return this.array != null;
    }

    protected boolean isCompound() {
        return this.compound != null && this.compoundIndex >= 0;
    }

    protected void onMoveDown(CarbonHoverIconButton button) {
        if (!this.isArray()) {
            return;
        }
        this.array.moveDown(this.indexOf());
        this.owner.updateInformation();
    }

    protected void onMoveUp(CarbonHoverIconButton button) {
        if (!this.isArray()) {
            return;
        }
        this.array.moveUp(this.indexOf());
        this.owner.updateInformation();
    }

    protected boolean canMoveUp() {
        return this.indexOf() > 0;
    }

    protected boolean canMoveDown() {
        return this.indexOf() < this.array.size() - 1;
    }

    protected boolean renderName() {
        return true;
    }

    protected boolean renderChildren() {
        return true;
    }

    protected boolean createResetButtons(IValueNode value) {
        return value != null;
    }

    protected int indexOf() {
        return this.array.indexOf(this.value);
    }

    protected boolean isReset() {
        return this.isArray() || this.value.isChanged();
    }

    @Override
    public boolean isChanged() {
        return this.value.isChanged();
    }

    @Override
    public boolean isDefault() {
        return this.value.isDefault();
    }

    public IConfigNode getNode() {
        return this.node;
    }

    protected void onDeleted(CarbonIconButton button) {
        if (!this.isArray()) {
            return;
        }
        this.owner.removeEntry(this);
    }

    protected void onReset(CarbonIconButton button) {
        this.value.setPrevious();
        this.updateValues();
    }

    protected void onDefault(CarbonIconButton button) {
        if (this.value == null) {
            return;
        }
        this.value.setDefault();
        this.updateValues();
    }

    protected void onSuggestion(CarbonIconButton button) {
        if (this.value == null) {
            return;
        }
        if (this.isCompound()) {
            this.mc.func_147108_a((GuiScreen)ListSelectionScreen.ofCompoundValue(this.mc.field_71462_r, this.node, this.value, this.compound, this.compoundIndex, this.owner.getCustomTexture()));
            return;
        }
        this.mc.func_147108_a((GuiScreen)ListSelectionScreen.ofValue(this.mc.field_71462_r, this.node, this.value, this.owner.getCustomTexture()));
    }

    @Override
    public void updateValues() {
    }

    @Override
    public List<? extends IInteractable> children() {
        return this.listeners;
    }

    public static enum GuiAlign {
        LEFT,
        CENTER,
        RIGHT;


        public int align(int left, int bounds, int width) {
            switch (this) {
                case LEFT: {
                    return left;
                }
                case CENTER: {
                    return left + bounds / 2 - width / 2;
                }
                case RIGHT: {
                    return left + bounds - width - 42;
                }
            }
            return left;
        }

        public float align(float width) {
            switch (this) {
                case CENTER: {
                    return width * -0.5f;
                }
                case RIGHT: {
                    return -width;
                }
            }
            return 0.0f;
        }

        public float alignCenter() {
            switch (this) {
                case CENTER: {
                    return 0.0f;
                }
                case RIGHT: {
                    return 0.5f;
                }
            }
            return -0.5f;
        }
    }

    public static class AlignOffset {
        GuiAlign align;
        int offset;

        public AlignOffset(GuiAlign align, int offset) {
            this.align = align;
            this.offset = offset;
        }
    }
}

