/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.impl.carbon;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.util.Strings;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.config.ConfigEntry;
import pregenerator.config.gui.api.DataType;
import pregenerator.config.gui.api.IArrayNode;
import pregenerator.config.gui.api.ICompoundNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.api.IValueNode;
import pregenerator.config.gui.impl.carbon.CompoundArrayNode;
import pregenerator.config.gui.impl.carbon.CompoundNode;
import pregenerator.config.impl.ReloadMode;
import pregenerator.config.utils.Helpers;
import pregenerator.config.utils.IEntryDataType;

public class ConfigCompoundLeaf
implements IConfigNode {
    ConfigEntry<?> entry;
    CompoundNode value;
    CompoundArrayNode array;

    public ConfigCompoundLeaf(ConfigEntry<?> entry) {
        this.entry = entry;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public IValueNode asValue() {
        return null;
    }

    @Override
    public IArrayNode asArray() {
        if (!this.isArray()) {
            return null;
        }
        if (this.array == null) {
            this.array = new CompoundArrayNode(this.entry, (ConfigEntry.IArrayConfig)((Object)this.entry), this.getDataType(), this.generateNames(), this.entry.getDataType().asCompound());
        }
        return this.array;
    }

    @Override
    public ICompoundNode asCompound() {
        if (this.isArray()) {
            return null;
        }
        if (this.value == null) {
            this.value = new CompoundNode(this.entry, this.getDataType(), this.generateNames(), this.entry.getDataType().asCompound());
        }
        return this.value;
    }

    private String[] generateNames() {
        List<Map.Entry<String, IEntryDataType.EntryDataType>> types = this.entry.getDataType().asCompound().getCompound();
        String[] names = new String[types.size()];
        int m = types.size();
        for (int i = 0; i < m; ++i) {
            names[i] = types.get(i).getKey();
        }
        return names;
    }

    @Override
    public List<DataType> getDataType() {
        IEntryDataType.CompoundDataType compound = this.entry.getDataType().asCompound();
        ObjectArrayList result = new ObjectArrayList();
        for (Map.Entry<String, IEntryDataType.EntryDataType> entry : compound.getCompound()) {
            result.add(DataType.byConfig(entry.getValue(), compound.getVariant(entry.getKey())));
        }
        return result;
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getValidValues() {
        return this.entry.getSuggestions(T -> true);
    }

    @Override
    public boolean isForcingSuggestions() {
        return this.entry.areSuggestionsForced();
    }

    @Override
    public boolean isArray() {
        return this.entry instanceof ConfigEntry.IArrayConfig;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged() || this.array != null && this.array.isChanged();
    }

    @Override
    public boolean requiresRestart() {
        return this.entry.getReloadState() == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.entry.getReloadState() == ReloadMode.WORLD;
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
        if (this.array != null) {
            this.array.save();
        }
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
        if (this.array != null) {
            this.array.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.isArray()) {
            if (this.array == null) {
                this.asArray();
            }
            this.array.setDefault();
        } else {
            if (this.value == null) {
                this.asCompound();
            }
            this.value.setDefault();
        }
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(this.entry.getKey());
    }

    @Override
    public ITextComponent getTooltip() {
        String limit;
        TextComponentString comp = new TextComponentString("");
        comp.func_150257_a(new TextComponentString(this.entry.getKey()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        String[] array = this.entry.getComment();
        if (array != null && array.length > 0) {
            comp.func_150258_a("\n");
            int i = 0;
            while (i < array.length) {
                comp.func_150258_a(array[i++]).func_150258_a("\n");
            }
        }
        if (!Strings.isBlank((String)(limit = this.entry.getLimitations()))) {
            String[] split = Helpers.splitArray(limit, ",");
            int i = 0;
            int m = split.length;
            while (i < m) {
                comp.func_150258_a("\n").func_150257_a(new TextComponentString(split[i++]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
        }
        return comp;
    }
}

