/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.impl.carbon;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.util.Strings;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.config.ConfigEntry;
import pregenerator.config.gui.api.DataType;
import pregenerator.config.gui.api.IArrayNode;
import pregenerator.config.gui.api.ICompoundNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.api.IValueNode;
import pregenerator.config.gui.impl.carbon.ArrayNode;
import pregenerator.config.gui.impl.carbon.ValueNode;
import pregenerator.config.impl.ReloadMode;

public class ConfigLeaf
implements IConfigNode {
    ConfigEntry<?> entry;
    ValueNode value;
    ArrayNode arrayValue;

    public ConfigLeaf(ConfigEntry<?> entry) {
        this.entry = entry;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public IValueNode asValue() {
        if (this.isArray()) {
            return null;
        }
        if (this.value == null) {
            this.value = new ValueNode(this.entry);
        }
        return this.value;
    }

    @Override
    public IArrayNode asArray() {
        if (!this.isArray()) {
            return null;
        }
        if (this.arrayValue == null) {
            this.arrayValue = new ArrayNode(this.entry, (ConfigEntry.IArrayConfig)((Object)this.entry), DataType.bySimple(this.entry.getDataType().asDataType()));
        }
        return this.arrayValue;
    }

    @Override
    public ICompoundNode asCompound() {
        return null;
    }

    @Override
    public List<DataType> getDataType() {
        return ObjectLists.singleton((Object)DataType.bySimple(this.entry.getDataType().asDataType()));
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getValidValues() {
        return this.entry.getSuggestions(T -> true);
    }

    @Override
    public boolean isForcingSuggestions() {
        return this.entry.areSuggestionsForced();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isArray() {
        return this.entry instanceof ConfigEntry.IArrayConfig;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged() || this.arrayValue != null && this.arrayValue.isChanged();
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
        if (this.arrayValue != null) {
            this.arrayValue.save();
        }
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
        if (this.arrayValue != null) {
            this.arrayValue.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.isArray()) {
            if (this.arrayValue == null) {
                this.asArray();
            }
            this.arrayValue.setDefault();
        } else {
            if (this.value == null) {
                this.asValue();
            }
            this.value.setDefault();
        }
    }

    @Override
    public boolean requiresRestart() {
        return this.entry.getReloadState() == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.entry.getReloadState() == ReloadMode.WORLD;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(this.entry.getKey());
    }

    @Override
    public ITextComponent getTooltip() {
        String limit;
        TextComponentString comp = new TextComponentString("");
        comp.func_150257_a(new TextComponentString(this.entry.getKey()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        String[] array = this.entry.getComment();
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.func_150258_a("\n").func_150258_a(array[i++]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            }
        }
        if (!Strings.isBlank((String)(limit = this.entry.getLimitations()))) {
            comp.func_150258_a("\n").func_150257_a(new TextComponentString(limit).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
        }
        return comp;
    }
}

