/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.screen;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import pregenerator.config.gui.api.BackgroundTexture;
import pregenerator.config.gui.api.DataType;
import pregenerator.config.gui.api.IArrayNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.config.CompoundElement;
import pregenerator.config.gui.config.ConfigElement;
import pregenerator.config.gui.config.Element;
import pregenerator.config.gui.config.ListScreen;
import pregenerator.config.gui.screen.CompoundScreen;
import pregenerator.config.gui.screen.ListSelectionScreen;
import pregenerator.config.gui.widgets.CarbonButton;

public class ArrayScreen
extends ListScreen {
    GuiScreen prev;
    IConfigNode entry;
    IArrayNode array;
    List<DataType> type;

    public ArrayScreen(IConfigNode entry, GuiScreen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(entry.getName(), customTexture);
        this.prev = prev;
        this.entry = entry;
        this.array = entry.asArray();
        this.type = entry.getDataType();
        this.array.createTemp();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.addWidget(new CarbonButton(x - 92, y - 27, 80, 20, I18n.func_135052_a((String)"gui.chunk_pregen.config.apply", (Object[])new Object[0]), this::apply));
        this.addWidget(new CarbonButton(x - 10, y - 27, 20, 20, "+", this::createEntry));
        this.addWidget(new CarbonButton(x + 12, y - 27, 80, 20, I18n.func_135052_a((String)"gui.chunk_pregen.config.back", (Object[])new Object[0]), this::goBack));
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    @Override
    protected boolean shouldHaveSearch() {
        return false;
    }

    @Override
    public void onClose() {
        this.array.setPrevious();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void apply(GuiButton button) {
        this.array.apply();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void goBack(GuiButton button) {
        if (this.array.isChanged()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, V) -> {
                if (T) {
                    this.array.setPrevious();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.prev : this));
            }, new TextComponentTranslation("gui.chunk_pregen.config.warn.changed", new Object[0]).func_150254_d(), new TextComponentTranslation("gui.chunk_pregen.config.warn.changed.desc", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.array.setPrevious();
        this.field_146297_k.func_147108_a(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        if (this.type.size() > 1) {
            int m = this.array.size();
            for (int i = 0; i < m; ++i) {
                elements.accept(new CompoundElement(this.entry, this.array, this.array.asCompound(i)));
            }
            return;
        }
        int m = this.array.size();
        for (int i = 0; i < m; ++i) {
            ConfigElement element = this.type.get(0).create(this.entry, this.array, i);
            if (element == null) continue;
            elements.accept(element);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 30, -1);
    }

    public void createEntry(GuiButton button) {
        int size = this.array.size();
        this.array.createNode();
        if (this.entry.getValidValues().size() > 0) {
            ListSelectionScreen screen = this.entry.getDataType().size() > 1 ? ListSelectionScreen.ofCompound(this.prev, this.entry, this.array.asCompound(size), this.getCustomTexture()) : ListSelectionScreen.ofValue(this.prev, this.entry, this.array.asValue(size), this.getCustomTexture());
            screen.withListener(() -> this.postCreate(size, true), () -> this.array.removeNode(size)).disableAbortWarning();
            this.field_146297_k.func_147108_a((GuiScreen)screen);
            return;
        }
        this.postCreate(size, false);
    }

    private void postCreate(int size, boolean reopen) {
        if (this.type.size() > 1) {
            CompoundScreen screen = new CompoundScreen(this.entry, this.array.asCompound(size), this, this.getCustomTexture());
            screen.setAbortListener(() -> this.array.removeNode(size));
            this.field_146297_k.func_147108_a((GuiScreen)screen);
            this.lastScroll = Double.MAX_VALUE;
            return;
        }
        ConfigElement element = this.type.get(0).create(this.entry, this.array, size);
        if (element != null) {
            this.addEntry(element);
            this.visibleList.addElement(element);
            this.visibleList.setScrollAmount(this.visibleList.getMaxScroll());
        }
        if (reopen) {
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    @Override
    public void removeEntry(Element element) {
        int index = this.allEntries.indexOf(element);
        if (index == -1) {
            return;
        }
        this.visibleList.removeElement(element);
        this.allEntries.remove(index);
        this.array.removeNode(index);
        this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
    }
}

