/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.screen;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import pregenerator.config.gui.api.BackgroundTexture;
import pregenerator.config.gui.api.DataType;
import pregenerator.config.gui.api.ICompoundNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.api.IValueNode;
import pregenerator.config.gui.config.ConfigElement;
import pregenerator.config.gui.config.Element;
import pregenerator.config.gui.config.ListScreen;
import pregenerator.config.gui.config.SelectionElement;
import pregenerator.config.gui.widgets.CarbonButton;

public class CompoundScreen
extends ListScreen {
    GuiScreen prev;
    IConfigNode entry;
    ICompoundNode compound;
    List<DataType> type;
    GuiButton applyValue;
    Runnable closeListener = null;

    public CompoundScreen(IConfigNode entry, ICompoundNode node, GuiScreen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(entry.getName(), customTexture);
        this.prev = prev;
        this.entry = entry;
        this.compound = node;
        this.type = entry.getDataType();
        this.compound.createTemp();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.applyValue = this.addWidget(new CarbonButton(x - 82, y - 27, 80, 20, I18n.func_135052_a((String)"gui.chunk_pregen.config.apply", (Object[])new Object[0]), this::apply));
        this.addWidget(new CarbonButton(x + 2, y - 27, 80, 20, I18n.func_135052_a((String)"gui.chunk_pregen.config.back", (Object[])new Object[0]), this::goBack));
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    @Override
    public void tick() {
        super.tick();
        this.applyValue.field_146124_l = this.compound.isValid();
    }

    @Override
    public void onClose() {
        this.notifyClose();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void apply(GuiButton button) {
        this.compound.apply();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void notifyClose() {
        this.compound.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    private void goBack(GuiButton button) {
        if (this.compound.isChanged()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, K) -> {
                if (T) {
                    this.notifyClose();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.prev : this));
            }, new TextComponentTranslation("gui.chunk_pregen.config.warn.changed", new Object[0]).func_150254_d(), new TextComponentTranslation("gui.chunk_pregen.config.warn.changed.desc", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.notifyClose();
        this.field_146297_k.func_147108_a(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        List<IValueNode> values = this.compound.getValues();
        int m = this.type.size();
        for (int i = 0; i < m; ++i) {
            if (this.compound.isForcedSuggestion(i)) {
                elements.accept(new SelectionElement(this.entry, values.get(i)));
                continue;
            }
            ConfigElement element = this.type.get(i).create(this.entry, values.get(i));
            if (element == null) continue;
            element.setCompound(this.compound, i);
            elements.accept(element);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 8, -1);
    }
}

