/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.gui.screen;

import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.gui.api.BackgroundTexture;
import pregenerator.config.gui.api.ICompoundNode;
import pregenerator.config.gui.api.IConfigNode;
import pregenerator.config.gui.api.INode;
import pregenerator.config.gui.api.ISuggestionRenderer;
import pregenerator.config.gui.api.IValueNode;
import pregenerator.config.gui.config.ConfigElement;
import pregenerator.config.gui.config.Element;
import pregenerator.config.gui.config.ElementList;
import pregenerator.config.gui.config.ListScreen;
import pregenerator.config.gui.widgets.CarbonButton;

public abstract class ListSelectionScreen
extends ListScreen {
    IConfigNode node;
    INode value;
    GuiScreen parent;
    GuiButton apply;
    Runnable abortListener;
    Runnable successListener;
    boolean dontWarn;

    public ListSelectionScreen(GuiScreen parent, IConfigNode node, INode value, BackgroundTexture.BackgroundHolder customTexture) {
        super(node.getName(), customTexture);
        this.parent = parent;
        this.node = node;
        this.value = value;
        this.value.createTemp();
    }

    public static ListSelectionScreen ofValue(GuiScreen parent, IConfigNode node, IValueNode value, BackgroundTexture.BackgroundHolder customTexture) {
        return new Value(parent, node, value, customTexture);
    }

    public static ListSelectionScreen ofCompound(GuiScreen parent, IConfigNode node, ICompoundNode value, BackgroundTexture.BackgroundHolder customTexture) {
        return new Compound(parent, node, value, customTexture);
    }

    public static ListSelectionScreen ofCompoundValue(GuiScreen parent, IConfigNode node, IValueNode value, ICompoundNode compound, int index, BackgroundTexture.BackgroundHolder customTexture) {
        return new CompoundValue(parent, node, value, compound, index, customTexture);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.visibleList.setRenderSelection(true);
        this.loadDefault();
        this.visibleList.setCallback(T -> this.setValue(((SelectionElement)T).getSuggestion().getValue()));
        int x = this.field_146294_l / 2 - 100;
        int y = this.field_146295_m;
        this.apply = this.addWidget(new CarbonButton(x + 10, y - 27, 85, 20, I18n.func_135052_a((String)"gui.chunk_pregen.config.pick", (Object[])new Object[0]), this::save));
        this.addWidget(new CarbonButton(x + 105, y - 27, 85, 20, I18n.func_135052_a((String)"gui.chunk_pregen.config.cancel", (Object[])new Object[0]), this::cancel));
    }

    public ListSelectionScreen withListener(Runnable success, Runnable abort) {
        this.successListener = success;
        this.abortListener = abort;
        return this;
    }

    public ListSelectionScreen disableAbortWarning() {
        this.dontWarn = true;
        return this;
    }

    protected abstract void loadDefault();

    protected abstract void setValue(String var1);

    protected void findDefault(String defaultValue) {
        for (Element element : this.allEntries) {
            if (!((SelectionElement)element).getSuggestion().getValue().equals(defaultValue)) continue;
            this.visibleList.setSelected(element);
            break;
        }
        this.visibleList.scrollToSelected(true);
    }

    @Override
    protected List<Element> sortElements(List<Element> list) {
        list.sort(Comparator.comparing(Element::getName, String.CASE_INSENSITIVE_ORDER));
        return list;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.apply.field_146124_l = this.value.isChanged();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 8, -1);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (ISuggestionProvider.Suggestion entry : this.node.getValidValues()) {
            elements.accept(new SelectionElement(entry, this.visibleList));
        }
    }

    @Override
    public void onClose() {
        this.abort();
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void save(GuiButton button) {
        this.value.apply();
        if (this.successListener != null) {
            this.successListener.run();
        } else {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    private void cancel(GuiButton button) {
        if (this.value.isChanged() && !this.dontWarn) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, V) -> {
                if (T) {
                    this.abort();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.parent : this));
            }, new TextComponentTranslation("gui.chunk_pregen.config.warn.changed", new Object[0]).func_150254_d(), new TextComponentTranslation("gui.chunk_pregen.config.warn.changed.desc", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.abort();
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void abort() {
        this.value.setPrevious();
        if (this.abortListener != null) {
            this.abortListener.run();
        }
    }

    private class SelectionElement
    extends Element {
        ISuggestionProvider.Suggestion suggestion;
        ElementList myList;
        int lastClick;
        ISuggestionRenderer renderer;
        boolean loaded;

        public SelectionElement(ISuggestionProvider.Suggestion suggestion, ElementList list) {
            super((ITextComponent)new TextComponentTranslation(suggestion.getName(), new Object[0]));
            this.lastClick = -1;
            this.loaded = false;
            this.suggestion = suggestion;
            this.myList = list;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ITextComponent comp;
            ISuggestionRenderer renderer = this.getRenderer();
            if (renderer != null && (comp = renderer.renderSuggestion(this.suggestion.getValue(), left, top)) != null && mouseX >= left && mouseX <= left + 20 && mouseY >= top && mouseY <= top + 20) {
                this.owner.addTooltips(comp);
            }
            this.renderText(new TextComponentString("").func_150255_a(new Style().func_150238_a(this.myList.getSelected() == this ? TextFormatting.YELLOW : TextFormatting.WHITE)).func_150257_a(this.name), left + (renderer != null ? 20 : 0), top, width - 5, height - 1, ConfigElement.GuiAlign.LEFT, -1);
        }

        private ISuggestionRenderer getRenderer() {
            if (this.loaded) {
                return this.renderer;
            }
            this.loaded = true;
            if (this.suggestion.getType() != null) {
                this.renderer = ISuggestionRenderer.Registry.getRendererForType(this.suggestion.getType());
            }
            return this.renderer;
        }

        public ISuggestionProvider.Suggestion getSuggestion() {
            return this.suggestion;
        }

        @Override
        public boolean mouseClick(double p_94737_, double p_94738_, int p_94739_) {
            if (this.myList.getSelected() == this) {
                if (this.lastClick >= 0 && this.myList.getLastTick() - this.lastClick <= 5) {
                    ListSelectionScreen.this.save(null);
                    return true;
                }
                this.lastClick = this.myList.getLastTick();
            } else {
                this.lastClick = this.myList.getLastTick();
            }
            this.myList.setSelected(this);
            return true;
        }
    }

    public static class Compound
    extends ListSelectionScreen {
        public Compound(GuiScreen parent, IConfigNode node, ICompoundNode value, BackgroundTexture.BackgroundHolder customTexture) {
            super(parent, node, value, customTexture);
        }

        @Override
        protected void loadDefault() {
            this.findDefault(((ICompoundNode)this.value).get());
        }

        @Override
        protected void setValue(String value) {
            ((ICompoundNode)this.value).set(value);
        }
    }

    public static class CompoundValue
    extends ListSelectionScreen {
        ICompoundNode compound;
        int index;

        public CompoundValue(GuiScreen parent, IConfigNode node, IValueNode value, ICompoundNode compound, int index, BackgroundTexture.BackgroundHolder customTexture) {
            super(parent, node, value, customTexture);
            this.compound = compound;
            this.index = index;
        }

        @Override
        protected void loadDefault() {
            this.findDefault(((IValueNode)this.value).get());
        }

        @Override
        protected void setValue(String value) {
            ((IValueNode)this.value).set(value);
        }

        @Override
        protected void collectElements(Consumer<Element> elements) {
            for (ISuggestionProvider.Suggestion entry : this.compound.getValidValues(this.index)) {
                elements.accept(new SelectionElement(entry, this.visibleList));
            }
        }
    }

    public static class Value
    extends ListSelectionScreen {
        public Value(GuiScreen parent, IConfigNode node, IValueNode value, BackgroundTexture.BackgroundHolder customTexture) {
            super(parent, node, value, customTexture);
        }

        @Override
        protected void loadDefault() {
            this.findDefault(((IValueNode)this.value).get());
        }

        @Override
        protected void setValue(String value) {
            ((IValueNode)this.value).set(value);
        }
    }
}

