/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.impl.entries;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.api.buffer.IReadBuffer;
import pregenerator.config.api.buffer.IWriteBuffer;
import pregenerator.config.config.ConfigEntry;
import pregenerator.config.utils.IEntryDataType;
import pregenerator.config.utils.MultilinePolicy;
import pregenerator.config.utils.ParseResult;

public class ColorValue
extends ConfigEntry.BasicConfigEntry<ColorWrapper> {
    public ColorValue(String key, int defaultValue, String ... comment) {
        super(key, new ColorWrapper(defaultValue), comment);
    }

    protected ColorValue copy() {
        return new ColorValue(this.getKey(), this.get(), this.getComment());
    }

    public final ColorValue addSuggestions(int ... values) {
        ObjectArrayList suggestions = new ObjectArrayList();
        for (int value : values) {
            suggestions.add(ISuggestionProvider.Suggestion.namedTypeValue(Long.toHexString(0xFF00000000L | (long)value).substring(2), this.serializedValue(MultilinePolicy.DISABLED, new ColorWrapper(value)), ColorWrapper.class));
        }
        return this;
    }

    @Override
    public final ColorValue addSuggestion(String name, int value) {
        return (ColorValue)this.addSingleSuggestion(ISuggestionProvider.Suggestion.namedTypeValue(name, this.serializedValue(MultilinePolicy.DISABLED, new ColorWrapper(value)), ColorWrapper.class));
    }

    @Override
    public ParseResult<ColorWrapper> parseValue(String value) {
        ParseResult<Integer> result = ColorWrapper.parseInt(value);
        return result.hasError() ? result.onlyError() : ParseResult.success(new ColorWrapper(result.getValue()));
    }

    @Override
    public IEntryDataType getDataType() {
        return IEntryDataType.SimpleDataType.ofVariant(ColorWrapper.class);
    }

    public int get() {
        return ((ColorWrapper)this.getValue()).getColor();
    }

    public int getRGB() {
        return ((ColorWrapper)this.getValue()).getColor() & 0xFFFFFF;
    }

    public int getRGBA() {
        return ((ColorWrapper)this.getValue()).getColor() & 0xFFFFFFFF;
    }

    @Override
    protected String serializedValue(MultilinePolicy policy, ColorWrapper value) {
        return ColorWrapper.serialize(value.getColor());
    }

    @Override
    public char getPrefix() {
        return 'C';
    }

    @Override
    public String getLimitations() {
        return "";
    }

    @Override
    public void serialize(IWriteBuffer buffer) {
        buffer.writeInt(this.get());
    }

    @Override
    protected void deserializeValue(IReadBuffer buffer) {
        this.set(new ColorWrapper(buffer.readInt()));
    }

    public static ParseResult<ColorValue> parse(String key, String value, String ... comment) {
        ParseResult<Integer> result = ColorWrapper.parseInt(value);
        if (result.hasError()) {
            return result.withDefault(new ColorValue(key, 0, comment));
        }
        return ParseResult.success(new ColorValue(key, result.getValue(), comment));
    }

    public static class ColorWrapper {
        int color;

        public ColorWrapper(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public static ParseResult<Integer> parseInt(String value) {
            try {
                return ParseResult.success(Long.decode(value).intValue());
            }
            catch (Exception e) {
                return ParseResult.error(value, e, "Couldn't parse Colour");
            }
        }

        public static String serialize(long color) {
            return "0x" + Long.toHexString(0xFF00000000L | color & 0xFFFFFFFFL).substring(2);
        }
    }
}

