/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.impl.entries;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pregenerator.config.api.ISuggestionProvider;
import pregenerator.config.api.buffer.IReadBuffer;
import pregenerator.config.api.buffer.IWriteBuffer;
import pregenerator.config.config.ConfigEntry;
import pregenerator.config.config.ConfigSection;
import pregenerator.config.utils.Helpers;
import pregenerator.config.utils.IEntryDataType;
import pregenerator.config.utils.MultilinePolicy;
import pregenerator.config.utils.ParseResult;

public class RegistryValue<T extends IForgeRegistryEntry<T>>
extends ConfigEntry.CollectionConfigEntry<T, Set<T>>
implements ConfigEntry.IArrayConfig {
    ForgeRegistry<T> registry;
    Class<T> clz;
    Predicate<T> filter;

    protected RegistryValue(String key, IForgeRegistry<T> registry, Class<T> clz, Set<T> defaultValue, Predicate<T> filter, String ... comment) {
        super(key, defaultValue, comment);
        this.registry = (ForgeRegistry)registry;
        this.clz = clz;
        this.filter = filter;
        this.addSuggestionProvider(new RegistrySuggestions(this));
    }

    public static <E extends IForgeRegistryEntry<E>> Builder<E> builder(String key, Class<E> clz) {
        return new Builder(key, clz);
    }

    @Override
    protected RegistryValue<T> copy() {
        return new RegistryValue<T>(this.getKey(), this.registry, this.clz, (Set)this.getDefault(), this.filter, this.getComment());
    }

    @Override
    protected String serializedValue(MultilinePolicy policy, Set<T> value) {
        String[] result = new String[value.size()];
        int i = 0;
        for (IForgeRegistryEntry entry : value) {
            result[i] = this.registry.getKey(entry).toString();
        }
        return this.serializeArray(policy, result);
    }

    @Override
    public ParseResult<Set<T>> parseValue(String value) {
        String[] values = Helpers.splitArray(value, ",");
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int m = values.length;
        for (int i = 0; i < m; ++i) {
            IForgeRegistryEntry entry = this.registry.getValue(new ResourceLocation(values[i]));
            if (entry == null || this.filter != null && !this.filter.test(entry)) continue;
            result.add(entry);
        }
        return ParseResult.success(result);
    }

    @Override
    public ParseResult<Boolean> canSet(Set<T> value) {
        ParseResult<Boolean> result = super.canSet(value);
        if (result.hasError()) {
            return result;
        }
        for (IForgeRegistryEntry entry : value) {
            if (!this.registry.containsValue(entry)) {
                return ParseResult.partial(false, NoSuchElementException::new, "Value [" + entry + "] doesn't exist in the registry");
            }
            if (this.filter == null || this.filter.test(entry)) continue;
            return ParseResult.partial(false, IllegalArgumentException::new, "Value [" + this.registry.getKey(entry) + "] isn't allowed");
        }
        return ParseResult.success(true);
    }

    @Override
    public List<String> getEntries() {
        ObjectArrayList result = new ObjectArrayList();
        for (IForgeRegistryEntry entry : (Set)this.getValue()) {
            result.add(this.registry.getKey(entry).toString());
        }
        return result;
    }

    @Override
    public List<String> getDefaults() {
        ObjectArrayList result = new ObjectArrayList();
        for (IForgeRegistryEntry entry : (Set)this.getDefault()) {
            result.add(this.registry.getKey(entry).toString());
        }
        return result;
    }

    @Override
    public ParseResult<Boolean> canSetArray(List<String> entries) {
        if (entries == null) {
            return ParseResult.partial(false, NullPointerException::new, "Value isn't allowed to be null");
        }
        int m = entries.size();
        for (int i = 0; i < m; ++i) {
            IForgeRegistryEntry result = this.registry.getValue(new ResourceLocation(entries.get(i)));
            if (result == null) {
                return ParseResult.partial(false, NoSuchElementException::new, "Value [" + entries.get(i) + "] doesn't exist in the registry");
            }
            if (this.filter == null || this.filter.test(result)) continue;
            return ParseResult.partial(false, IllegalArgumentException::new, "Value [" + entries.get(i) + "] isn't allowed");
        }
        return ParseResult.success(true);
    }

    @Override
    public void setArray(List<String> entries) {
        StringJoiner joiner = new StringJoiner(",");
        for (String s : entries) {
            joiner.add(s);
        }
        this.deserializeValue(joiner.toString());
    }

    @Override
    public IEntryDataType getDataType() {
        return IEntryDataType.SimpleDataType.ofVariant(this.clz);
    }

    @Override
    public char getPrefix() {
        return 'R';
    }

    @Override
    public String getLimitations() {
        return "";
    }

    @Override
    public void serialize(IWriteBuffer buffer) {
        Set value = (Set)this.getValue();
        buffer.writeVarInt(value.size());
        for (IForgeRegistryEntry entry : value) {
            buffer.writeVarInt(this.registry.getID(entry));
        }
    }

    @Override
    protected void deserializeValue(IReadBuffer buffer) {
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            IForgeRegistryEntry entry = this.registry.getValue(buffer.readVarInt());
            if (entry == null) continue;
            result.add(entry);
        }
    }

    @Override
    protected Set<T> create(T value) {
        return ObjectSets.singleton(value);
    }

    public static class Builder<E extends IForgeRegistryEntry<E>> {
        Class<E> clz;
        String key;
        Set<E> values = new ObjectLinkedOpenHashSet();
        Predicate<E> filter;
        String[] comments;

        private Builder(String key, Class<E> clz) {
            this.key = key;
            this.clz = clz;
        }

        public Builder<E> addDefault(E ... elements) {
            this.values.addAll((Collection<E>)ObjectArrayList.wrap((Object[])elements));
            return this;
        }

        public Builder<E> addDefaults(Collection<E> elements) {
            this.values.addAll(elements);
            return this;
        }

        public Builder<E> withFilter(Predicate<E> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<E> withComment(String ... comments) {
            this.comments = comments;
            return this;
        }

        public RegistryValue<E> build(IForgeRegistry<E> registry) {
            return new RegistryValue<E>(this.key, registry, this.clz, this.values, this.filter, this.comments);
        }

        public RegistryValue<E> build(IForgeRegistry<E> registry, ConfigSection section) {
            return section.add(new RegistryValue<E>(this.key, registry, this.clz, this.values, this.filter, this.comments));
        }
    }

    public static class RegistrySuggestions<T extends IForgeRegistryEntry<T>>
    implements ISuggestionProvider {
        RegistryValue<T> value;

        public RegistrySuggestions(RegistryValue<T> value) {
            this.value = value;
        }

        @Override
        public void provideSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
            for (IForgeRegistryEntry entry : this.value.registry) {
                String key = this.value.registry.getKey(entry).toString();
                ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedTypeValue(key, key, this.value.clz);
                if (!filter.test(suggestion)) continue;
                output.accept(suggestion);
            }
        }
    }
}

